<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" >
	<link rel="stylesheet" type="text/css" href="{@SYS.JSP}/menu/matrixMenu.css?v={@USER.YMDH}" />
	<style type="text/css">
		<og:equals val1="{@group}" val2="{@group}">
			table.MTRIX_GRP td.{@group} { background-color:linen; }
		</og:equals>

		<og:equals val1="{@group}" nullCheck="true" >
			table.MTRIX_GRP td.GUI_ALL { background-color:linen; }
		</og:equals>
	</style>
</og:head>

<body oncontextmenu="return false;">

<jsp:directive.include file="/jsp/custom/matrix_info.jsp" />

<!-- セッションがない場合は、jspInit(セッションタイムアウト対策) -->
<og:equals val1="{@menuType}" nullCheck="true">
	<og:jspInit />
</og:equals>

<!-- 6.3.8.3 (2015/10/03) autoRun.jsp の実行。TYPE=1 は、マトリクスメニュー用 -->
<og:input type="button" lbl="autoRun" caseIf="{@SYS.USE_AUTO_RUN}"
	onClick="window.open('autoRun.jsp?TYPE=1&amp;DATE={@DATE.YMDHMS}','sub','width=800,height=480,scrollbars=yes');return false;" />

<!-- メニューのタイプ分け -->
<og:value command="SET" key="menuType" scope="session" value="matrix" />
<og:value command="SET" key="menuTop"  scope="session" value="{@SYS.JSP}/menu/matrixMenu.jsp" />

<!-- グループ部分 -->
<table class="MTRIX_GRP" summary="Matrix Menu Group" >
	<og:topMenu 
		menuType	= "GROUP" 
		href		= "matrixMenu.jsp" 
		target		= "_top" 
		imageOnly	= "false"
		sideCount	= "8"
		cache		= "{@cache}"
		match		= "{@match}"
		unmatch		= "{@unmatch}"
	/>
</table>

<!-- MATRIX2（大分類無しボタンメニュー） -->
<table class="MTRIX_BTN" summary="Matrix Menu Group" >
	<og:topMenu 
		menuType	= "MATRIX2" 
		href		= "matrixMenu.jsp" 
		target		= "_top" 
		imageOnly	= "false"
		cache		= "{@cache}"
		match		= "{@match}"
		unmatch		= "{@unmatch}"
		sideCount	= "6"
		minCellCount= "8"
		maxCellCount= "8"
		groups		= "{@group}"
	>
		<og:help useFaq="true" />
	</og:topMenu>
</table>

<jsp:directive.include file="/jsp/custom/menu_end.jsp" />

</body>
</jsp:root>
