/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom;

import java.lang.reflect.Field;
import org.apache.xerces.dom.DocumentImpl;
import org.odftoolkit.odfdom.OdfAttribute;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfElementFactory;
import org.odftoolkit.odfdom.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.doc.office.OdfOfficeBody;
import org.odftoolkit.odfdom.doc.office.OdfOfficeMasterStyles;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfFileDom
extends DocumentImpl {
    private static final long serialVersionUID = 766167617530147000L;
    private String mPackagePath;
    private OdfDocument mOdfDocument;

    public OdfFileDom(OdfDocument odfDocument, String packagePath) {
        this.mOdfDocument = odfDocument;
        this.mPackagePath = packagePath;
    }

    public OdfDocument getOdfDocument() {
        return this.mOdfDocument;
    }

    public String getPackagePath() {
        return this.mPackagePath;
    }

    public OdfElement getRootElement() {
        return (OdfElement)((Object)this.getDocumentElement());
    }

    public OdfElement createElementNS(String nsuri, String qname) throws DOMException {
        return this.createElementNS(OdfName.get(nsuri, qname));
    }

    public OdfElement createElementNS(OdfName name) throws DOMException {
        return OdfElementFactory.newOdfElement(this, name);
    }

    public OdfAttribute createAttributeNS(String nsuri, String qname) throws DOMException {
        return this.createAttributeNS(OdfName.get(nsuri, qname));
    }

    public OdfAttribute createAttributeNS(OdfName name) throws DOMException {
        return OdfElementFactory.newOdfAttribute(this, name);
    }

    public <T extends OdfElement> T newOdfElement(Class<T> clazz) {
        try {
            Field fname = clazz.getField("ELEMENT_NAME");
            OdfName name = (OdfName)fname.get(null);
            return (T)((Object)this.createElementNS(name));
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            return null;
        }
    }

    public OdfOfficeAutomaticStyles getAutomaticStyles() {
        return OdfElement.findFirstChildNode(OdfOfficeAutomaticStyles.class, this.getFirstChild());
    }

    public OdfOfficeAutomaticStyles getOrCreateAutomaticStyles() {
        OdfOfficeAutomaticStyles automaticStyles = this.getAutomaticStyles();
        if (automaticStyles == null) {
            automaticStyles = this.newOdfElement(OdfOfficeAutomaticStyles.class);
            Node parent = this.getFirstChild();
            OdfElement sibling = OdfElement.findFirstChildNode(OdfOfficeBody.class, parent);
            if (sibling == null) {
                sibling = OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, parent);
            }
            if (sibling == null) {
                parent.appendChild((Node)((Object)automaticStyles));
            } else {
                parent.insertBefore((Node)((Object)automaticStyles), (Node)((Object)sibling));
            }
        }
        return automaticStyles;
    }

    public String toString() {
        return ((OdfElement)((Object)this.getDocumentElement())).toString();
    }
}

