/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIrxd
extends T4CTTIMsg {
    static final byte[] NO_BYTES = new byte[0];
    byte[] buffer;
    byte[] bufferCHAR;
    BitSet bvcColSent = null;
    int nbOfColumns = 0;
    boolean bvcFound = false;
    static final byte TTICMD_UNAUTHORIZED = 1;
    private int[] indicesOfColumnsToBeCopied = null;
    static int call_count = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIrxd(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)7);
    }

    void init() {
    }

    void setNumberOfColumns(int n2) {
        this.nbOfColumns = n2;
        this.bvcFound = false;
        if (this.bvcColSent == null || this.bvcColSent.length() < this.nbOfColumns) {
            this.bvcColSent = new BitSet(this.nbOfColumns);
        } else {
            this.bvcColSent.clear();
        }
    }

    void unmarshalBVC(int n2) throws SQLException, IOException {
        this.bvcColSent.clear();
        int n3 = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = (byte)(this.meg.unmarshalUB1() & 0xFF);
            this.bvcColSent.set(i2, by);
        }
        this.bvcFound = true;
    }

    void readBitVector(byte[] byArray, int n2) throws SQLException, IOException {
        this.bvcColSent.clear();
        if (n2 == 0) {
            this.bvcFound = false;
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                byte by = byArray[i2];
                this.bvcColSent.set(i2, by);
            }
            this.bvcFound = true;
        }
    }

    Vector<IOException> marshal(byte[] byArray, char[] cArray, short[] sArray, int n2, byte[] byArray2, DBConversion dBConversion, InputStream[] inputStreamArray, byte[][] byArray3, OracleTypeADT[] oracleTypeADTArray, byte[] byArray4, char[] cArray2, short[] sArray2, byte[] byArray5, int n3, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4, boolean bl2, ByteArray byteArray, long[] lArray, int[] nArray5, boolean bl3) throws IOException {
        if (bl3) {
            return this.marshalBindDBA(sArray, n2, inputStreamArray, byArray3, byArray4, cArray2, sArray2, byArray5, n3, nArray, bl, nArray2, nArray3, nArray4, bl2, byteArray, lArray, nArray5);
        }
        return this.marshalPrimitive(byArray, cArray, sArray, n2, byArray2, dBConversion, inputStreamArray, byArray3, oracleTypeADTArray, byArray4, cArray2, sArray2, byArray5, n3, nArray, bl, nArray2, nArray3, nArray4, bl2);
    }

    Vector<IOException> marshalBindDBA(short[] sArray, int n2, InputStream[] inputStreamArray, byte[][] byArray, byte[] byArray2, char[] cArray, short[] sArray2, byte[] byArray3, int n3, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4, boolean bl2, ByteArray byteArray, long[] lArray, int[] nArray5) throws IOException {
        Vector<IOException> vector = null;
        try {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            this.marshalTTCcode();
            int n11 = sArray[n2 + 0] & 0xFFFF;
            int n12 = 0;
            int n13 = nArray3[0];
            int[] nArray6 = nArray4[0];
            int n14 = 0;
            if (bl2) {
                n10 = 1;
                assert (n13 > 0) : "No postoned columns in RXD";
            } else {
                for (n9 = 0; n9 < n11; ++n9) {
                    int n15;
                    int n16;
                    if (n12 < n13 && nArray6[n12] == n9) {
                        ++n12;
                        continue;
                    }
                    n8 = 0;
                    n7 = n2 + 5 + 10 * n9;
                    n6 = sArray[n7 + 0] & 0xFFFF;
                    if (byArray3 != null && (byArray3[n9] & 0x20) == 0) {
                        if (n6 != 998) continue;
                        ++n14;
                        continue;
                    }
                    int n17 = ((sArray[n7 + 7] & 0xFFFF) << 16) + (sArray[n7 + 8] & 0xFFFF) + n3;
                    n5 = ((sArray[n7 + 5] & 0xFFFF) << 16) + (sArray[n7 + 6] & 0xFFFF) + n3;
                    int n18 = sArray[n17] & 0xFFFF;
                    n4 = sArray[n5];
                    if (n6 == 116) {
                        this.meg.marshalUB1((short)1);
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n6 == 994) {
                        n4 = -1;
                        n16 = nArray2[3 + n9 * 4 + 0];
                        if (n16 == 109) {
                            n8 = 1;
                        }
                    } else if (n6 == 8 || n6 == 24 || !bl && nArray != null && nArray.length > n9 && nArray[n9] > this.connection.maxNonStreamBindByteSize) {
                        if (n13 >= nArray6.length) {
                            int[] nArray7 = new int[nArray6.length << 1];
                            System.arraycopy(nArray6, 0, nArray7, 0, nArray6.length);
                            nArray6 = nArray7;
                        }
                        nArray6[n13++] = n9;
                        continue;
                    }
                    if (n4 == -1) {
                        if (n6 == 109 || n8 != 0) {
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (n6 == 998) {
                            ++n14;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n6 == 112 || n6 == 113 || n6 == 114) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n6 != 8 && n6 != 24) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (n6 == 998) {
                        n16 = (sArray2[6 + n14 * 8 + 4] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n14 * 8 + 5] & 0xFFFF;
                        n15 = (sArray2[6 + n14 * 8 + 6] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n14 * 8 + 7] & 0xFFFF;
                        int n19 = sArray2[6 + n14 * 8] & 0xFFFF;
                        int n20 = sArray2[6 + n14 * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(n16);
                        byte[] byArray4 = null;
                        for (int i2 = 0; i2 < n16; ++i2) {
                            int n21 = n15 + i2 * n20;
                            if (n19 == 9) {
                                int n22 = cArray[n21] / 2;
                                if (byArray4 == null) {
                                    byArray4 = this.connection.getByteBuffer(n22 * 4);
                                } else if (byArray4.length < n22 * 4) {
                                    this.connection.cacheBuffer(byArray4);
                                    byArray4 = this.connection.getByteBuffer(n22 * 4);
                                }
                                int n23 = this.connection.conversion.javaCharsToCHARBytes(cArray, n21 + 1, byArray4, 0, n22);
                                this.meg.marshalCLR(byArray4, n23);
                                continue;
                            }
                            n18 = byArray2[n21];
                            if (n18 < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(byArray2, n21 + 1, n18);
                        }
                        this.connection.cacheBuffer(byArray4);
                        ++n14;
                        continue;
                    }
                    int n24 = sArray[n7 + 1] & 0xFFFF;
                    if (n24 != 0) {
                        if (n6 == 6) {
                            --n18;
                        } else if (n6 == 9) {
                            n18 -= 2;
                        } else if (n6 == 114 || n6 == 113 || n6 == 112) {
                            this.meg.marshalUB4(n18);
                        }
                        if (n6 == 109 || n6 == 111) {
                            if (byArray == null) {
                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.marshal: parameterDatum is null");
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                            byte[] byArray5 = byArray[n9];
                            int n25 = n18 = byArray5 == null ? 0 : byArray5.length;
                            if (n6 == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(n18);
                                this.meg.marshalUB2(1);
                            }
                            if (n18 <= 0) continue;
                            this.meg.marshalCLR(byArray5, 0, n18);
                            continue;
                        }
                        if (n6 == 104) {
                            n16 = n3 * n11 + n9;
                            n15 = nArray5[n16];
                            byte[] byArray6 = new byte[n15];
                            byteArray.get(lArray[n16], byArray6, 0, n15);
                            long[] lArray2 = T4CRowidAccessor.stringToRowid(byArray6, 2, 18);
                            short s2 = 14;
                            long l2 = lArray2[0];
                            int n26 = (int)lArray2[1];
                            short s3 = 0;
                            long l3 = lArray2[2];
                            int n27 = (int)lArray2[3];
                            if (l2 == 0L && n26 == 0 && l3 == 0L && n27 == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1(s2);
                            this.meg.marshalUB4(l2);
                            this.meg.marshalUB2(n26);
                            this.meg.marshalUB1(s3);
                            this.meg.marshalUB4(l3);
                            this.meg.marshalUB2(n27);
                            continue;
                        }
                        if (n6 == 208) {
                            this.meg.marshalUB4(n18 -= 2);
                            n16 = n3 * n11 + n9;
                            this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n16], nArray5[n16]);
                            continue;
                        }
                        if (n18 < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        n16 = n3 * n11 + n9;
                        this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n16], nArray5[n16]);
                        continue;
                    }
                    n16 = n3 * n11 + n9;
                    this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n16], nArray5[n16]);
                }
                n10 = n13;
            }
            if (n13 > 0) {
                for (n9 = 0; n9 < n10; ++n9) {
                    InputStream inputStream;
                    int n28;
                    n8 = nArray6[n9];
                    n7 = n2 + 5 + 10 * n8;
                    n6 = sArray[n7 + 0] & 0xFFFF;
                    n5 = ((sArray[n7 + 5] & 0xFFFF) << 16) + (sArray[n7 + 6] & 0xFFFF) + n3;
                    n4 = sArray[n5];
                    if (n4 == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n6 == 996) {
                        n28 = n3 * n11 + n8;
                        this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n28], nArray5[n28]);
                        continue;
                    }
                    if (n6 != 8 && n6 != 24) {
                        n28 = n3 * n11 + n8;
                        this.meg.marshalCLR((DynamicByteArray)byteArray, lArray[n28], nArray5[n28]);
                        continue;
                    }
                    n28 = n8;
                    if (inputStreamArray == null || (inputStream = inputStreamArray[n28]) == null) continue;
                    try {
                        this.meg.marshalCLR(inputStream, 0);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (vector == null) {
                            vector = new Vector<IOException>();
                        }
                        vector.add(iOException);
                    }
                }
            }
            nArray3[0] = n13;
            nArray4[0] = nArray6;
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException();
            iOException.initCause(sQLException);
            throw iOException;
        }
        return vector;
    }

    Vector<IOException> marshalPrimitive(byte[] byArray, char[] cArray, short[] sArray, int n2, byte[] byArray2, DBConversion dBConversion, InputStream[] inputStreamArray, byte[][] byArray3, OracleTypeADT[] oracleTypeADTArray, byte[] byArray4, char[] cArray2, short[] sArray2, byte[] byArray5, int n3, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4, boolean bl2) throws IOException {
        Vector<IOException> vector = null;
        try {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            this.marshalTTCcode();
            int n18 = sArray[n2 + 0] & 0xFFFF;
            int n19 = 0;
            int n20 = nArray3[0];
            int[] nArray5 = nArray4[0];
            int n21 = 0;
            if (bl2) {
                n17 = 1;
                assert (n20 > 0) : "No postoned columns in RXD";
            } else {
                for (n16 = 0; n16 < n18; ++n16) {
                    short s2;
                    int n22;
                    int n23;
                    int n24;
                    if (n19 < n20 && nArray5[n19] == n16) {
                        ++n19;
                        continue;
                    }
                    n15 = 0;
                    n14 = n2 + 5 + 10 * n16;
                    n13 = sArray[n14 + 0] & 0xFFFF;
                    if (byArray5 != null && (byArray5[n16] & 0x20) == 0) {
                        if (n13 != 998) continue;
                        ++n21;
                        continue;
                    }
                    n12 = ((sArray[n14 + 7] & 0xFFFF) << 16) + (sArray[n14 + 8] & 0xFFFF) + n3;
                    n11 = ((sArray[n14 + 5] & 0xFFFF) << 16) + (sArray[n14 + 6] & 0xFFFF) + n3;
                    n10 = sArray[n12] & 0xFFFF;
                    n9 = sArray[n11];
                    if (n13 == 116) {
                        this.meg.marshalUB1((short)1);
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n13 == 994) {
                        n9 = -1;
                        n24 = nArray2[3 + n16 * 4 + 0];
                        if (n24 == 109) {
                            n15 = 1;
                        }
                    } else if (n13 == 8 || n13 == 24 || !bl && nArray != null && nArray.length > n16 && nArray[n16] > this.connection.maxNonStreamBindByteSize) {
                        if (n20 >= nArray5.length) {
                            int[] nArray6 = new int[nArray5.length << 1];
                            System.arraycopy(nArray5, 0, nArray6, 0, nArray5.length);
                            nArray5 = nArray6;
                        }
                        nArray5[n20++] = n16;
                        continue;
                    }
                    if (n9 == -1) {
                        if (n13 == 109 || n15 != 0) {
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (n13 == 998) {
                            ++n21;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n13 == 112 || n13 == 113 || n13 == 114) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n13 != 8 && n13 != 24) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (n13 == 998) {
                        n24 = (sArray2[6 + n21 * 8 + 4] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n21 * 8 + 5] & 0xFFFF;
                        n23 = (sArray2[6 + n21 * 8 + 6] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n21 * 8 + 7] & 0xFFFF;
                        int n25 = sArray2[6 + n21 * 8] & 0xFFFF;
                        int n26 = sArray2[6 + n21 * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(n24);
                        for (n22 = 0; n22 < n24; ++n22) {
                            s2 = n23 + n22 * n26;
                            if (n25 == 9) {
                                n8 = cArray2[s2] / 2;
                                n7 = 0;
                                n7 = dBConversion.javaCharsToCHARBytes(cArray2, s2 + 1, byArray2, 0, n8);
                                this.meg.marshalCLR(byArray2, n7);
                                continue;
                            }
                            n10 = byArray4[s2];
                            if (n10 < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(byArray4, s2 + 1, n10);
                        }
                        ++n21;
                        continue;
                    }
                    int n27 = sArray[n14 + 1] & 0xFFFF;
                    if (n27 != 0) {
                        int n28 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n27 * n3;
                        if (n13 == 6) {
                            ++n28;
                            --n10;
                        } else if (n13 == 9) {
                            n28 += 2;
                            n10 -= 2;
                        } else if (n13 == 114 || n13 == 113 || n13 == 112) {
                            this.meg.marshalUB4(n10);
                        }
                        if (n13 == 109 || n13 == 111) {
                            if (byArray3 == null) {
                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.marshal: parameterDatum is null");
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                            byte[] byArray6 = byArray3[n16];
                            int n29 = n10 = byArray6 == null ? 0 : byArray6.length;
                            if (n13 == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(n10);
                                this.meg.marshalUB2(1);
                            }
                            if (n10 <= 0) continue;
                            this.meg.marshalCLR(byArray6, 0, n10);
                            continue;
                        }
                        if (n13 == 104) {
                            long[] lArray = T4CRowidAccessor.stringToRowid(byArray, n28 += 2, 18);
                            n23 = 14;
                            long l2 = lArray[0];
                            n22 = (int)lArray[1];
                            s2 = 0;
                            long l3 = lArray[2];
                            int n30 = (int)lArray[3];
                            if (l2 == 0L && n22 == 0 && l3 == 0L && n30 == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1((short)n23);
                            this.meg.marshalUB4(l2);
                            this.meg.marshalUB2(n22);
                            this.meg.marshalUB1(s2);
                            this.meg.marshalUB4(l3);
                            this.meg.marshalUB2(n30);
                            continue;
                        }
                        if (n13 == 208) {
                            this.meg.marshalUB4(n10 -= 2);
                            this.meg.marshalCLR(byArray, n28 += 2, n10);
                            continue;
                        }
                        if (n10 < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        this.meg.marshalCLR(byArray, n28, n10);
                        continue;
                    }
                    n6 = sArray[n14 + 9] & 0xFFFF;
                    n5 = sArray[n14 + 2] & 0xFFFF;
                    n4 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n5 * n3 + 1;
                    if (n13 == 996) {
                        n24 = cArray[n4 - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < n24) {
                            this.bufferCHAR = new byte[n24];
                        }
                        for (n23 = 0; n23 < n24; ++n23) {
                            this.bufferCHAR[n23] = (byte)((cArray[n4 + n23 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (n23 >= n24 - 1) continue;
                            this.bufferCHAR[n23 + 1] = (byte)(cArray[n4 + n23 / 2] & 0xFF & 0xFF);
                            ++n23;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, n24);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (n13 == 96) {
                        n8 = n10 / 2;
                        --n4;
                    } else {
                        n8 = (n10 - 2) / 2;
                    }
                    n7 = 0;
                    n7 = n6 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n4, byArray2, 0, n8) : dBConversion.javaCharsToCHARBytes(cArray, n4, byArray2, 0, n8);
                    this.meg.marshalCLR(byArray2, n7);
                }
                n17 = n20;
            }
            if (n20 > 0) {
                for (n16 = 0; n16 < n17; ++n16) {
                    InputStream inputStream;
                    int n31;
                    n15 = nArray5[n16];
                    n14 = n2 + 5 + 10 * n15;
                    n13 = sArray[n14 + 0] & 0xFFFF;
                    n12 = ((sArray[n14 + 7] & 0xFFFF) << 16) + (sArray[n14 + 8] & 0xFFFF) + n3;
                    n11 = ((sArray[n14 + 5] & 0xFFFF) << 16) + (sArray[n14 + 6] & 0xFFFF) + n3;
                    n9 = sArray[n11];
                    n10 = sArray[n12] & 0xFFFF;
                    n5 = sArray[n14 + 2] & 0xFFFF;
                    n4 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n5 * n3 + 1;
                    if (n9 == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n13 == 996) {
                        n31 = cArray[n4 - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < n31) {
                            this.bufferCHAR = new byte[n31];
                        }
                        for (int i2 = 0; i2 < n31; ++i2) {
                            this.bufferCHAR[i2] = (byte)((cArray[n4 + i2 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (i2 >= n31 - 1) continue;
                            this.bufferCHAR[i2 + 1] = (byte)(cArray[n4 + i2 / 2] & 0xFF & 0xFF);
                            ++i2;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, n31);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (n13 != 8 && n13 != 24) {
                        if (n13 == 96) {
                            n8 = n10 / 2;
                            --n4;
                        } else {
                            n8 = (n10 - 2) / 2;
                        }
                        n6 = sArray[n14 + 9] & 0xFFFF;
                        n7 = 0;
                        n7 = n6 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n4, byArray2, 0, n8) : dBConversion.javaCharsToCHARBytes(cArray, n4, byArray2, 0, n8);
                        this.meg.marshalCLR(byArray2, n7);
                        continue;
                    }
                    n31 = n15;
                    if (inputStreamArray == null || (inputStream = inputStreamArray[n31]) == null) continue;
                    try {
                        this.meg.marshalCLR(inputStream, 0);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (vector == null) {
                            vector = new Vector<IOException>();
                        }
                        vector.add(iOException);
                    }
                }
            }
            nArray3[0] = n20;
            nArray4[0] = nArray5;
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException();
            iOException.initCause(sQLException);
            throw iOException;
        }
        return vector;
    }

    boolean unmarshal(Accessor[] accessorArray, int n2) throws SQLException, IOException {
        return this.unmarshal(accessorArray, 0, n2);
    }

    void copyRowsAsNeeded(Accessor[] accessorArray, int n2) throws SQLException, IOException {
        int n3;
        int n4 = Math.min(n2, accessorArray.length);
        for (n3 = 0; n3 < n4; ++n3) {
            Accessor accessor = accessorArray[n3];
            if (!accessor.isUseLess && !this.bvcColSent.get(accessor.physicalColumnIndex)) break;
        }
        if (n3 < n4) {
            if (this.indicesOfColumnsToBeCopied == null || this.indicesOfColumnsToBeCopied.length != this.nbOfColumns) {
                this.indicesOfColumnsToBeCopied = new int[this.nbOfColumns];
            }
            int n5 = 0;
            while (n3 < n4) {
                Accessor accessor = accessorArray[n3];
                if (!accessor.isUseLess && !this.bvcColSent.get(accessor.physicalColumnIndex)) {
                    this.indicesOfColumnsToBeCopied[n5++] = n3;
                }
                ++n3;
            }
            long l2 = -1L;
            while (n5 > 0) {
                int n6;
                int n7 = 0;
                Accessor accessor = accessorArray[this.indicesOfColumnsToBeCopied[n7]];
                long l3 = accessor.getOffset(accessor.getPreviousRowProcessed());
                for (n6 = 1; n6 < n5; ++n6) {
                    int n8 = this.indicesOfColumnsToBeCopied[n6];
                    accessor = accessorArray[this.indicesOfColumnsToBeCopied[n6]];
                    long l4 = accessor.getOffset(accessor.getPreviousRowProcessed());
                    if (l4 >= l3) continue;
                    l3 = l4;
                    n7 = n6;
                    if (l4 == -1L) break;
                }
                n6 = this.indicesOfColumnsToBeCopied[n7];
                accessor = accessorArray[n6];
                assert (accessor.isNull(accessor.getPreviousRowProcessed()) || l2 < l3) : "lastOffset: " + l2 + "\tleastOffset: " + l3 + "\tindexOfLeastOffet: " + n7;
                l2 = l3;
                try {
                    accessor.copyRow();
                }
                catch (AssertionError assertionError) {
                    String string = this.dumpIndicesOfColumnsToBeCopied(n5, this.indicesOfColumnsToBeCopied, accessorArray);
                    AssertionError assertionError2 = new AssertionError((Object)(string + "\nlastOffset: " + l2 + "\tleastOffset: " + l3 + "\tindexOfLeastOffet: " + n7));
                    ((Throwable)((Object)assertionError2)).initCause((Throwable)((Object)assertionError));
                    throw assertionError2;
                }
                this.indicesOfColumnsToBeCopied[n7] = this.indicesOfColumnsToBeCopied[--n5];
            }
        }
    }

    boolean unmarshal(Accessor[] accessorArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        for (n4 = n2; n4 < n3 && n4 < accessorArray.length; ++n4) {
            if (accessorArray[n4] == null || accessorArray[n4].physicalColumnIndex >= 0) continue;
            int n5 = 0;
            for (int i2 = 0; i2 < n3 && i2 < accessorArray.length; ++i2) {
                if (accessorArray[i2] == null) continue;
                accessorArray[i2].physicalColumnIndex = n5++;
                if (accessorArray[i2].isUseLess) continue;
            }
        }
        if (this.bvcFound && n2 == 0) {
            this.copyRowsAsNeeded(accessorArray, n3);
        }
        for (n4 = n2; n4 < n3 && n4 < accessorArray.length; ++n4) {
            if (accessorArray[n4] == null || this.bvcFound && !accessorArray[n4].isUseLess && !this.bvcColSent.get(accessorArray[n4].physicalColumnIndex)) continue;
            if (accessorArray[n4].statement.statementType == 2 || accessorArray[n4].statement.sqlKind.isPlsqlOrCall()) {
                accessorArray[n4].setCapacity(1);
            }
            if (!accessorArray[n4].unmarshalOneRow()) continue;
            return true;
        }
        this.bvcFound = false;
        return false;
    }

    String dumpIndicesOfColumnsToBeCopied(int n2, int[] nArray, Accessor[] accessorArray) throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("dump indicesOfColumnsToBeCopied call_count: " + call_count++ + " numColumnsToBeCopied: " + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = accessorArray[nArray[i2]].getOffset(0);
            printWriter.println("copy order: " + i2 + " index: " + nArray[i2] + " offset: " + l2);
        }
        printWriter.println();
        return stringWriter.toString();
    }

    boolean unmarshal(Accessor[] accessorArray, int n2, int n3, int n4) throws SQLException, IOException {
        return false;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static final class BitSet {
        private static final int[] SET_MASK = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        private static final int[] CLEAR_MASK = new int[]{254, 253, 251, 247, 239, 223, 191, 127};
        private final int capacity;
        private final byte[] bits;

        BitSet(int n2) {
            this.bits = new byte[(n2 + 7) / 8];
            this.capacity = this.bits.length * 8;
        }

        final int length() {
            return this.capacity;
        }

        final void set(int n2) {
            int n3 = n2 / 8;
            this.bits[n3] = (byte)(this.bits[n3] | SET_MASK[n2 % 8]);
        }

        final void set(int n2, byte by) {
            this.bits[n2] = by;
        }

        final void clear(int n2) {
            int n3 = n2 / 8;
            this.bits[n3] = (byte)(this.bits[n3] & CLEAR_MASK[n2 % 8]);
        }

        final boolean get(int n2) {
            return (this.bits[n2 / 8] & SET_MASK[n2 % 8]) > 0;
        }

        final void clear() {
            for (int i2 = 0; i2 < this.bits.length; ++i2) {
                this.bits[i2] = 0;
            }
        }
    }
}

