/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public final class ValueTimestampUtc
extends Value {
    public static final int PRECISION = 23;
    static final int DISPLAY_SIZE = 27;
    static final int DEFAULT_SCALE = 10;
    private final long utcDateTimeNanos;

    private ValueTimestampUtc(long l) {
        this.utcDateTimeNanos = l;
    }

    public static ValueTimestampUtc fromMillisNanos(long l, int n) {
        if (n < 0 || n >= 1000000) {
            throw new IllegalArgumentException("nanos out of range " + n);
        }
        return (ValueTimestampUtc)Value.cache(new ValueTimestampUtc(l * 1000L * 1000L + (long)n));
    }

    public static ValueTimestampUtc fromMillis(long l) {
        return ValueTimestampUtc.fromMillisNanos(l, 0);
    }

    public static ValueTimestampUtc fromNanos(long l) {
        return (ValueTimestampUtc)Value.cache(new ValueTimestampUtc(l));
    }

    public static ValueTimestampUtc parse(String string) {
        ValueTimestamp valueTimestamp = ValueTimestamp.parse(string);
        Timestamp timestamp = valueTimestamp.getTimestamp();
        return ValueTimestampUtc.fromMillisNanos(timestamp.getTime(), timestamp.getNanos());
    }

    public long getUtcDateTimeNanos() {
        return this.utcDateTimeNanos;
    }

    public long getUtcDateTimeMillis() {
        return this.utcDateTimeNanos / 1000L / 1000L;
    }

    int getNanosSinceLastMillis() {
        return (int)(this.utcDateTimeNanos % 1000000L);
    }

    @Override
    public Timestamp getTimestamp() {
        Timestamp timestamp = new Timestamp(this.getUtcDateTimeMillis());
        timestamp.setNanos(this.getNanosSinceLastMillis());
        return timestamp;
    }

    @Override
    public int getType() {
        return 23;
    }

    @Override
    public String getString() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTimeInMillis(this.getUtcDateTimeMillis());
        StringBuilder stringBuilder = new StringBuilder(27);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        if (n > 0 && n < 10000) {
            StringUtils.appendZeroPadded(stringBuilder, 4, n);
        } else {
            stringBuilder.append(n);
        }
        stringBuilder.append('-');
        StringUtils.appendZeroPadded(stringBuilder, 2, n2);
        stringBuilder.append('-');
        StringUtils.appendZeroPadded(stringBuilder, 2, n3);
        stringBuilder.append(' ');
        long l = gregorianCalendar.get(11);
        l *= 24L;
        l += (long)gregorianCalendar.get(12);
        l *= 60L;
        l += (long)gregorianCalendar.get(13);
        l *= 60L;
        l += (long)gregorianCalendar.get(14);
        l *= 1000000L;
        ValueTime.appendTime(stringBuilder, l += (long)this.getNanosSinceLastMillis(), true);
        stringBuilder.append(" UTC");
        return stringBuilder.toString();
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP UTC '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 23L;
    }

    @Override
    public int getScale() {
        return 10;
    }

    @Override
    public int getDisplaySize() {
        return 27;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 10) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        return this;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestampUtc valueTimestampUtc = (ValueTimestampUtc)value;
        return MathUtils.compareLong(this.utcDateTimeNanos, valueTimestampUtc.utcDateTimeNanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestampUtc)) {
            return false;
        }
        ValueTimestampUtc valueTimestampUtc = (ValueTimestampUtc)object;
        return this.utcDateTimeNanos == valueTimestampUtc.utcDateTimeNanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.utcDateTimeNanos ^ this.utcDateTimeNanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public long getLong() {
        return this.utcDateTimeNanos;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setTimestamp(n, this.getTimestamp());
    }

    @Override
    public Value add(Value value) {
        ValueTimestampUtc valueTimestampUtc = (ValueTimestampUtc)value.convertTo(23);
        long l = this.utcDateTimeNanos + valueTimestampUtc.utcDateTimeNanos;
        return new ValueTimestampUtc(l);
    }

    @Override
    public Value subtract(Value value) {
        ValueTimestampUtc valueTimestampUtc = (ValueTimestampUtc)value.convertTo(23);
        long l = this.utcDateTimeNanos - valueTimestampUtc.utcDateTimeNanos;
        return new ValueTimestampUtc(l);
    }
}

