/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.firebirdsql.ds.RootCommonDataSource;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBXAConnection;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBSQLException;

public class FBXADataSource
extends RootCommonDataSource
implements XADataSource {
    private String user;
    private String password;
    private String database;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    private String getUrl() {
        return "jdbc:firebirdsql:" + this.database;
    }

    private static AbstractConnection createConnection(String url, String user, String password) throws ResourceException, SQLException, GDSException {
        FBManagedConnectionFactory mcf = FBXADataSource.createMcf(url, user, password);
        FBConnectionRequestInfo subjectCri = mcf.getDefaultConnectionRequestInfo();
        subjectCri.setUserName(user);
        subjectCri.setPassword(password);
        FBManagedConnection mc = (FBManagedConnection)mcf.createManagedConnection(null, subjectCri);
        mc.setManagedEnvironment(false);
        mc.setConnectionSharing(false);
        return (AbstractConnection)mc.getConnection(null, subjectCri);
    }

    private static FBManagedConnectionFactory createMcf(String url, String user, String password) throws SQLException, ResourceException, GDSException, FBResourceException {
        GDSType type = GDSFactory.getTypeForProtocol(url);
        Properties originalInfo = new Properties();
        originalInfo.setProperty("user", user);
        originalInfo.setProperty("password", password);
        Map<String, String> normalizedInfo = FBDriverPropertyManager.normalize(url, originalInfo);
        int qMarkIndex = url.indexOf(63);
        if (qMarkIndex != -1) {
            url = url.substring(0, qMarkIndex);
        }
        FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
        FBConnectionRequestInfo subjectCri = mcf.getDefaultConnectionRequestInfo();
        subjectCri.setUserName(user);
        subjectCri.setPassword(password);
        String databaseURL = GDSFactory.getDatabasePath(type, url);
        mcf.setDatabase(databaseURL);
        for (Map.Entry<String, String> entry : normalizedInfo.entrySet()) {
            mcf.setNonStandardProperty(entry.getKey(), entry.getValue());
        }
        FBConnectionHelper.processTpbMapping(mcf.getGDS(), mcf, originalInfo);
        mcf = mcf.canonicalize();
        return mcf;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.user, this.password);
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.database == null) {
            throw new SQLException("database cannot be null");
        }
        if (user == null) {
            throw new SQLException("user cannot be null");
        }
        if (password == null) {
            throw new SQLException("password cannot be null");
        }
        try {
            AbstractConnection c = FBXADataSource.createConnection(this.getUrl(), user, password);
            return new FBXAConnection(c);
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
    }
}

