/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.text.BreakIterator;
import java.util.regex.Pattern;
import org.firebirdsql.jdbc.FBEscapedCallParser;
import org.firebirdsql.jdbc.FBEscapedFunctionHelper;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBSQLParseException;

public class FBEscapedParser {
    public static final int USE_BUILT_IN = 0;
    public static final int USE_STANDARD_UDF = 1;
    protected static final int UNDEFINED_STATE = 0;
    protected static final int NORMAL_STATE = 1;
    protected static final int LITERAL_STATE = 2;
    protected static final int ESCAPE_STATE = 4;
    public static final String ESCAPE_CALL_KEYWORD = "call";
    public static final String ESCAPE_CALL_KEYWORD3 = "?";
    public static final String ESCAPE_DATE_KEYWORD = "d";
    public static final String ESCAPE_TIME_KEYWORD = "t";
    public static final String ESCAPE_TIMESTAMP_KEYWORD = "ts";
    public static final String ESCAPE_FUNCTION_KEYWORD = "fn";
    public static final String ESCAPE_ESCAPE_KEYWORD = "escape";
    public static final String ESCAPE_OUTERJOIN_KEYWORS = "oj";
    private static final Pattern CHECK_ESCAPE_PATTERN = Pattern.compile("\\{(?:(?:\\?\\s*=\\s*)?call|d|ts?|escape|fn|oj)\\s", 2);
    private int state = 1;
    private int lastState = 1;
    private int nestedEscaped = 0;
    private int mode;

    public FBEscapedParser(int mode) {
        this.mode = mode;
    }

    protected int getLastState() {
        return this.lastState;
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) throws IllegalStateException {
        int tempState = this.getLastState();
        this.lastState = this.getState();
        switch (state) {
            case 1: 
            case 2: 
            case 4: {
                this.state = state;
                break;
            }
            default: {
                this.lastState = tempState;
                throw new IllegalStateException("State " + state + " is unknown.");
            }
        }
    }

    protected boolean isInState(int state) {
        return this.getState() == state;
    }

    protected boolean wasInState(int state) {
        return this.getLastState() == state;
    }

    protected void switchState(char testChar) {
        switch (testChar) {
            case '\'': {
                if (this.isInState(1)) {
                    this.setState(2);
                    break;
                }
                if (!this.isInState(2)) break;
                this.setState(1);
                break;
            }
            case '{': {
                if (this.isInState(1)) {
                    this.setState(4);
                }
                ++this.nestedEscaped;
                break;
            }
            case '}': {
                if (this.isInState(4)) {
                    --this.nestedEscaped;
                }
                if (this.nestedEscaped != 0) break;
                this.setState(1);
            }
        }
    }

    protected boolean checkForEscapes(String sql) {
        return CHECK_ESCAPE_PATTERN.matcher(sql).find();
    }

    public String parse(String sql) throws SQLException {
        this.lastState = 1;
        this.state = 1;
        this.nestedEscaped = 0;
        if (!this.checkForEscapes(sql)) {
            return sql;
        }
        try {
            StringBuilder buffer = new StringBuilder();
            StringBuilder escape = new StringBuilder();
            for (int i = 0; i < sql.length(); ++i) {
                char currentChar = sql.charAt(i);
                this.switchState(currentChar);
                if (this.isInState(1) && (this.wasInState(1) || this.wasInState(2))) {
                    buffer.append(currentChar);
                    continue;
                }
                if (this.isInState(1) && this.wasInState(4)) {
                    buffer.append(this.escapeToNative(escape.substring(1, escape.length())));
                    escape.setLength(0);
                    this.setState(1);
                    continue;
                }
                if (this.isInState(4)) {
                    escape.append(currentChar);
                    continue;
                }
                if (!this.isInState(2)) continue;
                buffer.append(currentChar);
            }
            return buffer.toString();
        }
        catch (IllegalStateException e) {
            FBSQLParseException parseException = new FBSQLParseException("Parser reached an invalid state: " + e.getMessage());
            parseException.initCause(e);
            throw parseException;
        }
    }

    protected void processEscaped(String escaped, StringBuilder keyword, StringBuilder payload) {
        keyword.setLength(0);
        payload.setLength(0);
        BreakIterator iterator = BreakIterator.getWordInstance();
        iterator.setText(escaped);
        int keyStart = iterator.first();
        int keyEnd = iterator.next();
        keyword.append(escaped.substring(keyStart, keyEnd));
        payload.append(escaped.substring(keyEnd, escaped.length()));
    }

    protected String escapeToNative(String escaped) throws SQLException {
        StringBuilder keyword = new StringBuilder();
        StringBuilder payload = new StringBuilder();
        this.processEscaped(escaped, keyword, payload);
        if (keyword.toString().equalsIgnoreCase(ESCAPE_CALL_KEYWORD)) {
            return this.convertProcedureCall("{" + keyword + ' ' + payload + '}');
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_CALL_KEYWORD3)) {
            return this.convertProcedureCall("{?" + payload + '}');
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_DATE_KEYWORD)) {
            return this.toDateString(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_ESCAPE_KEYWORD)) {
            return this.convertEscapeString(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_FUNCTION_KEYWORD)) {
            return this.convertEscapedFunction(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_OUTERJOIN_KEYWORS)) {
            return this.convertOuterJoin(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_TIME_KEYWORD)) {
            return this.toTimeString(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_TIMESTAMP_KEYWORD)) {
            return this.toTimestampString(payload.toString().trim());
        }
        throw new FBSQLParseException("Unknown keyword " + keyword + " for escaped syntax.");
    }

    protected String toDateString(String dateStr) throws FBSQLParseException {
        return dateStr;
    }

    protected String toTimeString(String timeStr) throws FBSQLParseException {
        return timeStr;
    }

    protected String toTimestampString(String timestampStr) throws FBSQLParseException {
        return timestampStr;
    }

    protected String convertProcedureCall(String procedureCall) throws SQLException {
        FBEscapedCallParser tempParser = new FBEscapedCallParser(this.mode);
        FBProcedureCall call = tempParser.parseCall(procedureCall);
        call.checkParameters();
        return call.getSQL(false);
    }

    protected String convertOuterJoin(String outerJoin) throws FBSQLParseException {
        return outerJoin;
    }

    protected String convertEscapeString(String escapeString) {
        return "ESCAPE " + escapeString;
    }

    protected String convertEscapedFunction(String escapedFunction) throws FBSQLParseException {
        String templateResult = FBEscapedFunctionHelper.convertTemplate(escapedFunction, this.mode);
        if (templateResult != null) {
            return templateResult;
        }
        return escapedFunction;
    }

    public static boolean supportsStoredProcedures() {
        return true;
    }

    public static boolean supportsLikeEscapeClause() {
        return false;
    }
}

