/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import oracle.i18n.text.UTFUtility;

public class UTF8ValidationFilter
extends BufferedInputStream {
    private static final int DEFAULT_BUFFEER_SIZE = 8192;
    private static final byte[] M_UTF8_REPLACEMENT_CHAR = new byte[]{-17, -65, -67};
    private final ValidationBehavior m_ccb;
    private final byte[] m_buff = new byte[4];
    private final char[] m_cbuff = new char[2];
    private final byte[] m_onebyte = new byte[1];
    private int m_currentCharLen = 0;
    private int m_pos = 0;

    public UTF8ValidationFilter(InputStream inputStream) {
        this(inputStream, 8192, ValidationBehavior.REPORT);
    }

    public UTF8ValidationFilter(InputStream inputStream, int n) {
        this(inputStream, n, ValidationBehavior.REPORT);
    }

    public UTF8ValidationFilter(InputStream inputStream, int n, ValidationBehavior validationBehavior) {
        super(inputStream, n);
        this.m_ccb = validationBehavior;
    }

    @Override
    public synchronized int read() throws UTFDataFormatException, IOException {
        int n = this.read(this.m_onebyte, 0, 1);
        if (n == -1) {
            return -1;
        }
        return this.m_onebyte[0];
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws UTFDataFormatException, IOException {
        int n3;
        int n4 = n;
        int n5 = n + n2;
        if (this.m_currentCharLen > 0) {
            n3 = this.m_currentCharLen + 1 - this.m_pos;
            if (n4 + n3 > n5) {
                int n6 = n5 - n4;
                System.arraycopy(this.m_buff, this.m_pos, byArray, n4, n6);
                n4 += n6;
                this.m_pos += n6;
                return n6 > 0 ? n6 : -1;
            }
            System.arraycopy(this.m_buff, this.m_pos, byArray, n4, n3);
            n4 += n3;
            this.m_currentCharLen = 0;
        }
        this.m_pos = 0;
        while (n4 < n5 && (n3 = super.read()) != -1) {
            int n7;
            int n8 = n3 & 0xFF;
            switch (n8 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.m_currentCharLen = 0;
                    byArray[n4++] = (byte)n3;
                    break;
                }
                case 12: 
                case 13: {
                    this.m_currentCharLen = 1;
                    this.m_buff[0] = (byte)n3;
                    this.m_buff[1] = (byte)super.read();
                    if (this.m_buff[1] == -1) {
                        this.m_ccb.onFailConversion(new byte[]{(byte)n3}, this);
                        break;
                    }
                    n7 = UTFUtility.conv2ByteUTFtoUTF16((byte)n3, this.m_buff[1]);
                    if (n7 != 65533) break;
                    this.m_ccb.onFailConversion(new byte[]{(byte)n3, this.m_buff[1]}, this);
                    break;
                }
                case 14: {
                    int n9;
                    this.m_currentCharLen = 2;
                    this.m_buff[0] = (byte)n3;
                    n7 = super.read(this.m_buff, 1, 2);
                    if (n7 < 2) {
                        if (n7 == 1) {
                            this.m_ccb.onFailConversion(new byte[]{(byte)n3, this.m_buff[1]}, this);
                            break;
                        }
                        this.m_ccb.onFailConversion(new byte[]{(byte)n3}, this);
                        break;
                    }
                    if (n3 == M_UTF8_REPLACEMENT_CHAR[0] && this.m_buff[1] == M_UTF8_REPLACEMENT_CHAR[0] && this.m_buff[2] == M_UTF8_REPLACEMENT_CHAR[2] || (n9 = UTFUtility.conv3ByteUTFtoUTF16((byte)n3, this.m_buff[1], this.m_buff[2])) != 65533) break;
                    this.m_ccb.onFailConversion(new byte[]{(byte)n3, this.m_buff[1], this.m_buff[2]}, this);
                    break;
                }
                case 15: {
                    this.m_currentCharLen = 3;
                    this.m_buff[0] = (byte)n3;
                    n7 = super.read(this.m_buff, 1, 3);
                    if (n7 < 3) {
                        if (n7 == 2) {
                            this.m_ccb.onFailConversion(new byte[]{(byte)n3, this.m_buff[1], this.m_buff[2]}, this);
                            break;
                        }
                        if (n7 == 1) {
                            this.m_ccb.onFailConversion(new byte[]{(byte)n3, this.m_buff[1]}, this);
                            break;
                        }
                        this.m_ccb.onFailConversion(new byte[]{(byte)n3}, this);
                        break;
                    }
                    int n9 = UTFUtility.conv4ByteAL32UTF8toUTF16((byte)n3, this.m_buff[1], this.m_buff[2], this.m_buff[3], this.m_cbuff, 0);
                    if (n9 != 1) break;
                    this.m_ccb.onFailConversion(new byte[]{(byte)n3, this.m_buff[1], this.m_buff[2], this.m_buff[3]}, this);
                    break;
                }
                default: {
                    this.m_currentCharLen = 2;
                    this.m_ccb.onFailConversion(new byte[]{(byte)n3}, this);
                }
            }
            if (this.m_currentCharLen == 0) continue;
            n7 = 0;
            if (n4 + this.m_currentCharLen >= n5) {
                this.m_pos = n7 = n5 - n4;
            } else {
                n7 = this.m_currentCharLen + 1;
                this.m_currentCharLen = 0;
            }
            System.arraycopy(this.m_buff, 0, byArray, n4, n7);
            n4 += n7;
        }
        n3 = n4 - n;
        return n3 > 0 ? n3 : -1;
    }

    public static abstract class ValidationBehavior {
        static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
        public static final ValidationBehavior REPORT = new ValidationBehavior("Report Error"){

            @Override
            public void onFailConversion(byte[] byArray, UTF8ValidationFilter uTF8ValidationFilter) throws UTFDataFormatException {
                uTF8ValidationFilter.m_currentCharLen = 2;
                System.arraycopy(M_UTF8_REPLACEMENT_CHAR, 0, uTF8ValidationFilter.m_buff, 0, M_UTF8_REPLACEMENT_CHAR.length);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < byArray.length; ++i) {
                    String string = Integer.toHexString(byArray[i] + 256);
                    stringBuffer.append("0x").append(string.substring(string.length() - 2)).append(" ");
                }
                throw new UTFDataFormatException(stringBuffer.toString());
            }
        };
        public static final ValidationBehavior REPLACE = new ValidationBehavior("Replacement"){

            @Override
            public void onFailConversion(byte[] byArray, UTF8ValidationFilter uTF8ValidationFilter) throws UTFDataFormatException {
                uTF8ValidationFilter.m_currentCharLen = 2;
                System.arraycopy(M_UTF8_REPLACEMENT_CHAR, 0, uTF8ValidationFilter.m_buff, 0, M_UTF8_REPLACEMENT_CHAR.length);
            }
        };
        private final String m_name;

        private ValidationBehavior(String string) {
            this.m_name = string;
        }

        abstract void onFailConversion(byte[] var1, UTF8ValidationFilter var2) throws UTFDataFormatException;
    }
}

