/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Struct,
Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(string, connection, false, false);
    }

    private static boolean isValidObject(String string, Connection connection) throws SQLException {
        oracle.jdbc.OracleConnection oracleConnection = (oracle.jdbc.OracleConnection)connection;
        while (oracleConnection.unwrap() != null) {
            oracleConnection = oracleConnection.unwrap();
        }
        TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(string, oracleConnection);
        return typeDescriptor.getTypeCode() == 2002 || typeDescriptor.getTypeCode() == 2008;
    }

    public static StructDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (string == null || string.length() == 0 || connection == null || !StructDescriptor.isValidObject(string, connection)) {
            SQLException sQLException = DatabaseError.createSqlException(null, 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        String string2 = sQLName.getName();
        StructDescriptor structDescriptor = null;
        if (!bl2 && (structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2)) == null) {
            short s2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getVersionNumber();
            structDescriptor = s2 >= 12000 ? new StructDescriptor(string, connection) : new StructDescriptor(sQLName, connection);
            if (bl) {
                structDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        String string = sQLName.getName();
        StructDescriptor structDescriptor = null;
        if (!bl2 && (structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string)) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
            if (bl) {
                structDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static StructDescriptor createDescriptor(OracleTypeADT oracleTypeADT) throws SQLException {
        String string = oracleTypeADT.getFullName();
        OracleConnection oracleConnection = oracleTypeADT.getConnection();
        StructDescriptor structDescriptor = (StructDescriptor)oracleConnection.getDescriptor(string);
        if (structDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeADT.getSchemaName(), oracleTypeADT.getSimpleName(), oracleTypeADT.getConnection());
            structDescriptor = new StructDescriptor(sQLName, oracleTypeADT, (Connection)oracleConnection);
            oracleConnection.putDescriptor(string, (Object)structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, oracleConnection);
        return new StructDescriptor(sQLName, oracleTypeADT, (Connection)oracleConnection);
    }

    public StructDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)108, oracleTypeADT, connection);
    }

    public StructDescriptor(String string, Connection connection) throws SQLException {
        super((short)108, string, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)108, sQLName, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)108, sQLName, oracleTypeADT, connection);
        this.toid = oracleTypeADT.getTOID();
    }

    StructDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)108);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    StructDescriptor(AttributeDescriptor[] attributeDescriptorArray, Connection connection) throws SQLException {
        super((short)108);
        this.attributesDescriptor = attributeDescriptorArray;
        this.setPhysicalConnectionOf(connection);
        this.isTransient = true;
        this.initPickler();
        this.isInstanciable = Boolean.TRUE;
    }

    private void initPickler() throws SQLException {
        String string = null;
        try {
            if (this.isTransient) {
                string = this.getName();
                this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
            } else {
                string = this.typeNameByUser == null ? this.getName() : this.typeNameByUser;
                this.pickler = new OracleTypeADT(string, (Connection)this.connection);
                ((OracleTypeADT)this.pickler).init(this.connection);
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
            }
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + string + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.STRUCT;
    }

    @Override
    public int getTypeCode() throws SQLException {
        int n2 = this.getOracleTypeADT().getTypeCode();
        return n2;
    }

    @Override
    public int getTypeVersion() throws SQLException {
        int n2 = this.getOracleTypeADT().getTypeVersion();
        return n2;
    }

    void setAttributesDescriptor(AttributeDescriptor[] attributeDescriptorArray) {
        this.attributesDescriptor = attributeDescriptorArray;
    }

    public AttributeDescriptor[] getAttributesDescriptor() {
        return this.attributesDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    byte[] toBytes(STRUCT sTRUCT, boolean bl) throws SQLException {
        byte[] byArray = sTRUCT.shareBytes();
        if (byArray == null) {
            if (sTRUCT.datumArray != null) {
                byArray = this.pickler.linearize(sTRUCT);
                if (bl) return byArray;
                sTRUCT.setShareBytes(null);
                return byArray;
            }
            if (sTRUCT.objectArray != null) {
                sTRUCT.datumArray = this.toOracleArray(sTRUCT.objectArray);
                byArray = this.pickler.linearize(sTRUCT);
                if (bl) return byArray;
                sTRUCT.datumArray = null;
                sTRUCT.setShareBytes(null);
                return byArray;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (sTRUCT.imageLength == 0L) return byArray;
        if (sTRUCT.imageOffset == 0L) {
            if (sTRUCT.imageLength == (long)byArray.length) return byArray;
        }
        byte[] byArray2 = new byte[(int)sTRUCT.imageLength];
        System.arraycopy(byArray, (int)sTRUCT.imageOffset, byArray2, 0, (int)sTRUCT.imageLength);
        sTRUCT.setImage(byArray2, 0L, 0L);
        return byArray2;
    }

    Datum[] toOracleArray(STRUCT sTRUCT, boolean bl) throws SQLException {
        Datum[] datumArray = sTRUCT.datumArray;
        Datum[] datumArray2 = null;
        if (datumArray == null) {
            if (sTRUCT.objectArray != null) {
                datumArray = this.toOracleArray(sTRUCT.objectArray);
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 1, null);
                datumArray = sTRUCT.datumArray;
                if (!bl) {
                    sTRUCT.datumArray = null;
                }
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (bl) {
            sTRUCT.datumArray = datumArray;
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object[] toArray(STRUCT sTRUCT, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (sTRUCT.objectArray != null) return (Object[])sTRUCT.objectArray.clone();
        if (sTRUCT.datumArray != null) {
            objectArray = new Object[sTRUCT.datumArray.length];
            int n2 = 0;
            while (n2 < sTRUCT.datumArray.length) {
                if (sTRUCT.datumArray[n2] != null) {
                    objectArray[n2] = sTRUCT.datumArray[n2] instanceof STRUCT ? ((STRUCT)sTRUCT.datumArray[n2]).toJdbc(map) : sTRUCT.datumArray[n2].toJdbc();
                }
                ++n2;
            }
            return objectArray;
        }
        if (sTRUCT.shareBytes() != null) {
            if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
            }
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 2, map);
        objectArray = sTRUCT.objectArray;
        sTRUCT.objectArray = null;
        return objectArray;
    }

    @Override
    public int getLength() throws SQLException {
        return this.getFieldTypes().length;
    }

    public OracleTypeADT getOracleTypeADT() throws SQLException {
        if (this.pickler == null) {
            this.initPickler();
        }
        OracleTypeADT oracleTypeADT = (OracleTypeADT)this.pickler;
        return oracleTypeADT;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        return ((OracleTypeADT)this.pickler).getAttrTypes();
    }

    public SQLInput toJdbc2SQLInput(STRUCT sTRUCT, Map map) throws SQLException {
        return new OracleJdbc2SQLInput(this.toOracleArray(sTRUCT, false), map, this.connection);
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        return new OracleSQLOutput(this, this.connection);
    }

    public Datum[] toOracleArray(Object[] objectArray) throws SQLException {
        Datum[] datumArray = null;
        if (objectArray != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n2 = oracleTypeArray.length;
            if (objectArray.length != n2) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            datumArray = new Datum[n2];
            OracleConnection oracleConnection = this.connection;
            for (int i2 = 0; i2 < n2; ++i2) {
                datumArray[i2] = oracleTypeArray[i2].toDatumInternal(objectArray[i2], oracleConnection);
            }
        }
        return datumArray;
    }

    public Datum[] toOracleArray(Map map) throws SQLException {
        Datum[] datumArray = null;
        int n2 = 0;
        if (map != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n3 = oracleTypeArray.length;
            int n4 = map.size();
            datumArray = new Datum[n3];
            OracleConnection oracleConnection = this.connection;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object v2 = map.get(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1));
                datumArray[i2] = oracleTypeArray[i2].toDatum(v2, oracleConnection);
                if (v2 == null && !map.containsKey(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1))) continue;
                ++n2;
            }
            if (n2 < n4) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return datumArray;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.connection.newStructMetaData(this);
    }

    @Override
    public boolean isFinalType() throws SQLException {
        return this.getOracleTypeADT().isFinalType();
    }

    @Override
    public boolean isSubtype() throws SQLException {
        return this.getOracleTypeADT().isSubType();
    }

    @Override
    public boolean isInHierarchyOf(String string) throws SQLException {
        StructDescriptor structDescriptor = this;
        String string2 = structDescriptor.getName();
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        } else {
            while (true) {
                if ((string2 = structDescriptor.getSupertypeName()) == null) {
                    bl = false;
                    break;
                }
                if (string.equals(string2)) {
                    bl = true;
                    break;
                }
                structDescriptor = StructDescriptor.createDescriptor(string2, (Connection)this.connection);
            }
        }
        return bl;
    }

    @Override
    public boolean isInstantiable() throws SQLException {
        if (this.isInstanciable == null) {
            this.isInstanciable = this.getOracleTypeADT().isInstanciable();
        }
        return this.isInstanciable;
    }

    public boolean isJavaObject() throws SQLException {
        return this.getOracleTypeADT().isJavaObject();
    }

    @Override
    public String getSupertypeName() throws SQLException {
        String string = null;
        if (this.isSubtype()) {
            if (this.supertype == null) {
                this.supertype = this.getOracleTypeADT().getSuperTypeName();
            }
            string = this.supertype;
        }
        return string;
    }

    @Override
    public int getLocalAttributeCount() throws SQLException {
        int n2;
        if (!this.isSubtype()) {
            n2 = this.getOracleTypeADT().getAttrTypes().length;
        } else {
            if (this.numLocalAttrs == -1) {
                this.numLocalAttrs = this.getOracleTypeADT().getNumberOfLocalAttributes();
            }
            n2 = this.numLocalAttrs;
        }
        return n2;
    }

    @Override
    public String[] getSubtypeNames() throws SQLException {
        if (this.subtypes == null) {
            this.subtypes = this.getOracleTypeADT().getSubtypeNames();
        }
        return this.subtypes;
    }

    public String getJavaClassName() throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            string = StructDescriptor.getJavaObjectClassName(this.connection, this);
        }
        return string;
    }

    public String getAttributeJavaName(int n2) throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            string = this.attrJavaNames[n2];
        }
        return string;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        String[] stringArray = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            stringArray = this.attrJavaNames;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String getLanguage() throws SQLException {
        String string = null;
        string = this.isJavaObject() ? "JAVA" : "SQL";
        return string;
    }

    public static String getJavaObjectClassName(Connection connection, StructDescriptor structDescriptor) throws SQLException {
        return StructDescriptor.getJavaObjectClassName(connection, structDescriptor.getSchemaName(), structDescriptor.getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection connection, String string, String string2) throws SQLException {
        String string3;
        block8: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string3 = null;
            OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            oracleConnection.beginNonRequestCalls();
            try {
                preparedStatement = connection.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string3 = resultSet.getString(1);
                    break block8;
                }
                SQLException sQLException = DatabaseError.createSqlException(null, 100);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                oracleConnection.endNonRequestCalls();
            }
        }
        return string3;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Subtype=" + this.getOracleTypeADT().isSubType());
        stringBuffer.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        stringBuffer.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        stringBuffer.append("\n");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        for (int i3 = 0; i3 < n3; ++i3) {
            TypeDescriptor typeDescriptor;
            int n4 = resultSetMetaData.getColumnType(i3 + 1);
            if (n4 == 2002 || n4 == 2008) {
                typeDescriptor = StructDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((StructDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            if (n4 == 2003) {
                typeDescriptor = ArrayDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((ArrayDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            if (n4 == 2007) {
                typeDescriptor = OpaqueDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((OpaqueDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(resultSetMetaData.getColumnTypeName(i3 + 1));
            stringBuffer.append("\n");
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toOracleArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, (byte[])null, this.connection);
        sTRUCT.setDatumArray(datumArray);
        return this.pickler.linearize(sTRUCT);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        return this.toOracleArray(objectArray);
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, byArray, this.connection);
        return this.toOracleArray(sTRUCT, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.attrJavaNames == null) {
                this.connection.beginNonRequestCalls();
                String[] stringArray = null;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME, ATTR_NO from all_sqlj_type_attrs where owner = :1 and type_name = :2 order by ATTR_NO");
                    preparedStatement.setString(1, this.getSchemaName());
                    preparedStatement.setString(2, this.getTypeName());
                    resultSet = preparedStatement.executeQuery();
                    stringArray = new String[this.getOracleTypeADT().getAttrTypes().length];
                    int n2 = 0;
                    while (resultSet.next()) {
                        stringArray[resultSet.getInt((int)2) - 1] = resultSet.getString(1);
                        ++n2;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.connection.endNonRequestCalls();
                }
                this.attrJavaNames = stringArray;
            }
        }
    }

    @Override
    String tagName() {
        return "StructDescriptor";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

