/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.workflow.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.workflow.Execution;
import org.openstack4j.model.workflow.State;
import org.openstack4j.model.workflow.builder.ExecutionBuilder;

public abstract class BaseExecution
implements Execution {
    String id;
    String description;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    Date updatedAt;
    List<String> tags;
    @JsonProperty(value="workflow_name")
    String wfName;
    State state;
    @JsonProperty(value="state_info")
    String stateInfo;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getWorkflowName() {
        return this.wfName;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String getStateInfo() {
        return this.stateInfo;
    }

    public static abstract class BaseExecutionBuilder<T extends ExecutionBuilder<T, M>, M extends BaseExecution>
    implements ExecutionBuilder<T, M> {
        protected M model;

        BaseExecutionBuilder(M model) {
            this.model = model;
        }

        @Override
        public M build() {
            return this.model;
        }

        @Override
        public T from(Execution in) {
            return null;
        }

        @Override
        public T id(String id) {
            ((BaseExecution)this.model).id = id;
            return (T)this;
        }

        @Override
        public T description(String description) {
            ((BaseExecution)this.model).description = description;
            return (T)this;
        }

        @Override
        public T workflowName(String wfName) {
            ((BaseExecution)this.model).wfName = wfName;
            return (T)this;
        }

        @Override
        public T createdAt(Date createdAt) {
            ((BaseExecution)this.model).createdAt = createdAt;
            return (T)this;
        }

        @Override
        public T updatedAt(Date updatedAt) {
            ((BaseExecution)this.model).updatedAt = updatedAt;
            return (T)this;
        }

        @Override
        public T tags(List<String> tags) {
            ((BaseExecution)this.model).tags = tags;
            return (T)this;
        }

        public T state(State state) {
            ((BaseExecution)this.model).state = state;
            return (T)this;
        }

        public T stateInfo(String stateInfo) {
            ((BaseExecution)this.model).stateInfo = stateInfo;
            return (T)this;
        }
    }
}

