/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.opengion.fukurou.system.OgBuilder;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBLastSql;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class EditConfigTag
extends CommonTagSupport {
    private static final String VERSION = "6.9.2.1 (2018/03/12)";
    private static final long serialVersionUID = 692120180312L;
    private static final String CAN_EDIT_COMMON = HybsSystem.sys("EDIT_COMMON_ROLES");
    private static final String VIEW_PREFIX = "EDIT_VIEW_";
    private static final String SUM_PREFIX = "EDIT_SUM_";
    private static final String GROUP_PREFIX = "EDIT_GROUP_";
    private static final String SUBTOTAL_PREFIX = "EDIT_SUBTOTAL_";
    private static final String TOTAL_PREFIX = "EDIT_TOTAL_";
    private static final String ORDERBY_PREFIX = "EDIT_ORDERBY_";
    private static final String DESC_PREFIX = "EDIT_DESC_";
    private static final String GRANDTOTAL_PREFIX = "EDIT_GRANDTOTAL_";
    private static final String COMMON_PREFIX = "EDIT_COMMON_";
    private static final String FIRSTTOTAL_PREFIX = "EDIT_FIRSTTOTAL_";
    private String command;
    private String gamenId;
    private String editName;
    private transient DBTableModel table;
    private boolean orderOnly;

    @Override
    public int doEndTag() {
        DBEditConfig[] dBEditConfigArray;
        this.debugPrint();
        StringBuilder stringBuilder = new StringBuilder(200);
        DBEditConfig dBEditConfig = this.getUser().getEditConfig(this.gamenId, this.editName);
        if ("GET".equals(this.command)) {
            DBLastSql dBLastSql = (DBLastSql)this.getSessionAttribute("h_lastSql");
            if (dBLastSql != null) {
                if (dBLastSql.isViewEditable() && dBLastSql.isGuiMatch(this.gamenId)) {
                    this.setScope(dBLastSql.getScope());
                    this.table = (DBTableModel)this.getObject(dBLastSql.getTableId());
                    if (this.table != null) {
                        String string = null;
                        if (dBEditConfig == null) {
                            dBEditConfig = new DBEditConfig();
                            string = dBLastSql.getViewClmNames();
                        } else {
                            string = dBEditConfig.getViewClms(dBLastSql.getOrgClmNames());
                        }
                        stringBuilder.append(this.makeEditTable(string, dBEditConfig));
                    }
                } else {
                    String string = "<b style=\"font-color:red;\">" + this.getResource().getLabel("GEE0003") + "</b>";
                    this.jspPrint(string);
                }
            }
        } else if ("SET".equals(this.command)) {
            if (this.editName == null || this.editName.isEmpty()) {
                throw new HybsSystemException("\u7de8\u96c6\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            String string = this.getRequest().getParameter(COMMON_PREFIX);
            if (!"1".equals(string) && '*' == this.editName.charAt(0)) {
                throw new HybsSystemException("\u5171\u901a\u4ee5\u5916\u306e\u5834\u5408\u306f\u3001\u7de8\u96c6\u540d\u306b\u982d\u6587\u5b57\u306b*\u3092\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            this.saveEditConfig();
        } else if ("DELETE".equals(this.command)) {
            if (this.editName == null || this.editName.isEmpty()) {
                throw new HybsSystemException("\u7de8\u96c6\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            this.deleteEditConfig(dBEditConfig);
        } else if ("LIST".equals(this.command) && (dBEditConfigArray = this.getUser().getEditConfigs(this.gamenId)).length > 0) {
            stringBuilder.append(this.getEditSelect(dBEditConfigArray)).append(CR);
        }
        this.jspPrint(stringBuilder.toString());
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = "GET";
        this.gamenId = null;
        this.editName = null;
        this.table = null;
        this.orderOnly = false;
    }

    private String makeEditTable(String string, DBEditConfig dBEditConfig) {
        Object object;
        boolean bl = this.getUseSum(string);
        String[] stringArray = StringUtil.csv2Array((String)string, (char)'|');
        StringBuilder stringBuilder = new StringBuilder(200).append("<input type=\"hidden\" name=\"viewClms\" id=\"viewClms\" value=\"").append(string).append("\"/><div /><div style=\"float:left;\">").append(this.makeLabelRow(bl, dBEditConfig)).append("</div><div id=\"clmLayer\" style=\"float:left; width:670px; overflow-x:scroll;\">");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(this.makeSeparateRow(bl));
            }
            stringBuilder.append("<table class=\"clmGroup\" style=\"float:left;\"><tr>");
            object = StringUtil.csv2Array((String)stringArray[i]);
            for (int j = 0; j < ((String[])object).length; ++j) {
                String string2;
                boolean bl2 = !StringUtil.startsChar((CharSequence)object[j], (char)'!');
                String string3 = string2 = bl2 ? object[j] : object[j].substring(1);
                if ("rowCount".equals(string2)) continue;
                stringBuilder.append(this.makeColumnRow(string2, bl2, bl, dBEditConfig));
            }
            stringBuilder.append("</tr></table>");
        }
        stringBuilder.append("</div>");
        if (bl) {
            if (dBEditConfig == null) {
                throw new OgRuntimeException("DBEditConfig\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            String string4 = "<b>" + this.getDBColumn("EDIT_GRANDTOTAL_LABEL").getLongLabel() + ":</b>";
            object = "<b>" + this.getDBColumn("EDIT_FIRSTTOTAL_LABEL").getLongLabel() + ":</b>";
            stringBuilder.append("<div style=\"clear:both;\"><table>").append(this.makeCheckbox(GRANDTOTAL_PREFIX, dBEditConfig.useGrandTotal(), "h", string4, this.orderOnly)).append(this.makeCheckbox(FIRSTTOTAL_PREFIX, dBEditConfig.useFirstTotal(), "h", (String)object, this.orderOnly)).append("</table></div>");
        }
        return stringBuilder.toString();
    }

    private String makeLabelRow(boolean bl, DBEditConfig dBEditConfig) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(200).append("<table><tr><td style=\"margin:0px; padding:0px;\"><table>");
        if (this.getUser().isAccess(CAN_EDIT_COMMON)) {
            if (dBEditConfig == null) {
                throw new OgRuntimeException("DBEditConfig\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            string = "<b>" + this.getDBColumn("EDIT_COMMON_LABEL").getLongLabel() + ":</b>";
            stringBuilder.append(this.makeCheckbox(COMMON_PREFIX, dBEditConfig.isCommon(), "h", string, this.orderOnly));
        } else {
            stringBuilder.append(this.makeLabel(""));
        }
        string = "<b>" + this.getDBColumn("EDIT_VIEW_LABEL").getLongLabel() + ":</b>";
        stringBuilder.append(this.makeCheckbox("VIEW_ALL_CHECK", true, "h", string, this.orderOnly));
        if (bl) {
            stringBuilder.append(this.makeLabel("EDIT_SUM_LABEL"));
        }
        String string2 = "<b>" + this.getDBColumn("EDIT_GROUP_LABEL").getLongLabel() + "</b><img id=\"groupBtn\" src=\"" + HybsSystem.sys("JSP") + "/image/ball-green.gif\" />";
        stringBuilder.append(this.makeCell(string2, "h")).append(this.makeLabel("EDIT_SUBTOTAL_LABEL")).append(this.makeLabel("EDIT_TOTAL_LABEL")).append(this.makeLabel("EDIT_ORDERBY_LABEL")).append(this.makeLabel("EDIT_DESC_LABEL")).append("</table></td></tr></table>");
        return stringBuilder.toString();
    }

    private String makeColumnRow(String string2, boolean bl, boolean bl2, DBEditConfig dBEditConfig) {
        if (this.table == null) {
            throw new OgRuntimeException("DBTableModel\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        int n = this.table.getColumnNo(string2, false);
        DBColumn dBColumn = n < 0 ? this.getDBColumn(string2) : this.table.getDBColumn(n);
        return new OgBuilder().append(new CharSequence[]{"<td name=\"", string2}).append(new CharSequence[]{"\" class=\"sortItem\" style=\"margin:0px; padding:0px;\">"}).append(new CharSequence[]{"<table>"}).append(new CharSequence[]{this.makeLabel(dBColumn.getLongLabel())}).append(new CharSequence[]{this.makeCheckbox(VIEW_PREFIX + string2, bl, "0", "", this.orderOnly)}).appendIf(bl2, (Object)string2, string -> this.makeCheckbox(SUM_PREFIX + string, dBEditConfig.isSumClm((String)string), "1", "", this.orderOnly, this.isNumberClm((String)string))).append(new CharSequence[]{this.makeCheckbox(GROUP_PREFIX + string2, dBEditConfig.isGroupClm(string2), "0", "", this.orderOnly)}).append(new CharSequence[]{this.makeCheckbox(SUBTOTAL_PREFIX + string2, dBEditConfig.isSubTotalClm(string2), "1", "", this.orderOnly)}).append(new CharSequence[]{this.makeCheckbox(TOTAL_PREFIX + string2, dBEditConfig.isTotalClm(string2), "0", "", this.orderOnly)}).append(new CharSequence[]{this.makeInput(ORDERBY_PREFIX + string2, dBEditConfig.getOrder(string2), "1", "")}).append(new CharSequence[]{this.makeCheckbox(DESC_PREFIX + string2, dBEditConfig.isOrderByDesc(string2), "0", "", false)}).append(new CharSequence[]{"</table></td>"}).toString();
    }

    private String makeCheckbox(String string, boolean bl, String string2, String string3, boolean bl2) {
        return this.makeCheckbox(string, bl, string2, string3, bl2, true);
    }

    private String makeCheckbox(String string, boolean bl, String string2, String string3, boolean bl2, boolean bl3) {
        if (bl3) {
            String string4 = new TagBuffer("input").add("type", "checkbox").add("name", string).add("value", "1").add("checked", "checked", bl).add("disabled", "disabled", bl2).makeTag();
            String string5 = bl2 && bl ? string4 + new TagBuffer("input").add("type", "hidden").add("name", string).add("value", "1").makeTag() : string4;
            return this.makeCell(string3 + string5, string2);
        }
        return this.makeCell(string3 + "&nbsp;", string2);
    }

    private String makeInput(String string, String string2, String string3, String string4) {
        String string5 = new TagBuffer("input").add("type", "text").add("name", string).add("value", string2).add("style", "width:10px; font-size:10px;").add("maxlength", "2").add("class", "S9").makeTag();
        return this.makeCell(string4 + string5, string3);
    }

    private String makeSeparateRow(boolean bl) {
        String string = this.makeCell("&nbsp", "h");
        return new OgBuilder().append(new CharSequence[]{"<table style=\"float:left;\"><tr><td style=\"margin:0px; padding:0px;\"><table>"}).append(new CharSequence[]{string}).append(new CharSequence[]{string}).appendIf(bl, new CharSequence[]{string}).append(new CharSequence[]{string}).append(new CharSequence[]{string}).append(new CharSequence[]{string}).append(new CharSequence[]{string}).append(new CharSequence[]{string}).append(new CharSequence[]{"</table></td></tr></table>"}).toString();
    }

    private String makeLabel(String string) {
        return this.makeCell(this.getDBColumn(string).getLongLabel(), "h");
    }

    private String makeCell(String string, String string2) {
        return "<tr><td align=\"center\" style=\"height:22px;\" class=\"row_" + string2 + "\">" + string + "</td></tr>";
    }

    private boolean getUseSum(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = StringUtil.csv2Array((String)string.replace('|', ','));
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = string2 = StringUtil.startsChar((CharSequence)stringArray[i], (char)'!') ? stringArray[i].substring(1) : stringArray[i];
            if (!this.isNumberClm(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isNumberClm(String string) {
        if (string == null) {
            return false;
        }
        if (this.table == null) {
            throw new OgRuntimeException("DBTableModel\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        int n = this.table.getColumnNo(string, false);
        if (n >= 0) {
            DBColumn dBColumn = this.table.getDBColumn(n);
            return dBColumn != null && dBColumn.isNumberType();
        }
        return false;
    }

    private void saveEditConfig() {
        String string = this.getRequest().getParameter("viewClms");
        String string2 = this.getColumns(SUM_PREFIX);
        String string3 = this.getColumns(GROUP_PREFIX);
        String string4 = this.getColumns(SUBTOTAL_PREFIX);
        String string5 = this.getColumns(TOTAL_PREFIX);
        String string6 = this.getRequest().getParameter(GRANDTOTAL_PREFIX);
        String string7 = this.getRequest().getParameter(FIRSTTOTAL_PREFIX);
        String string8 = this.getOrderByColumns();
        String string9 = this.getRequest().getParameter(COMMON_PREFIX);
        if ("1".equals(string9) && '*' != this.editName.charAt(0)) {
            this.editName = "*" + this.editName;
        }
        this.setRequestAttribute("regEditName", this.editName);
        DBEditConfig dBEditConfig = new DBEditConfig(this.editName, string, string2, string3, string4, string5, string6, string7, string8, string9);
        this.getUser().addEditConfig(this.gamenId, this.editName, dBEditConfig);
    }

    private void deleteEditConfig(DBEditConfig dBEditConfig) {
        boolean bl = dBEditConfig.isCommon();
        if (bl && !this.getUser().isAccess(CAN_EDIT_COMMON)) {
            throw new HybsSystemException("\u5171\u901a\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u7de8\u96c6\u540d\u3092\u524a\u9664\u3059\u308b\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.getUser().deleteEditConfig(this.gamenId, this.editName);
    }

    private String getColumns(String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        Enumeration<?> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string) || !"1".equals(string2 = this.getRequest().getParameter(string3))) continue;
            String string4 = string3.substring(string.length());
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    private String getOrderByColumns() {
        Enumeration<?> enumeration = this.getParameterNames();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(ORDERBY_PREFIX) || (string = this.getRequest().getParameter(string2)) == null || string.length() <= 0) continue;
            String string3 = string2.substring(ORDERBY_PREFIX.length());
            String string4 = this.getRequest().getParameter(DESC_PREFIX + string3);
            if ("1".equals(string4)) {
                string3 = "!" + string3;
            }
            Integer n2 = null;
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            String string5 = (String)hashMap.get(n2);
            while (string5 != null) {
                n2 = n2 + 1;
                string5 = (String)hashMap.get(n2);
            }
            hashMap.put(n2, string3);
            arrayList.add(n2);
        }
        Collections.sort(arrayList);
        return arrayList.stream().map(n -> (String)hashMap.get(n)).collect(Collectors.joining(","));
    }

    private String getEditSelect(DBEditConfig ... dBEditConfigArray) {
        DBColumn dBColumn = this.getDBColumn("editName");
        StringBuilder stringBuilder = new StringBuilder(200).append("<span class=\"label editName\">").append(dBColumn.getLongLabel()).append(":</span><span class=\"editName\">").append("<select name=\"editName\">").append("<option />");
        for (DBEditConfig dBEditConfig : dBEditConfigArray) {
            String string = dBEditConfig.getEditName();
            stringBuilder.append("<option value=\"").append(string).append('\"');
            if (dBEditConfig.isCommon()) {
                stringBuilder.append(" class=\"commonEdit\"");
            }
            stringBuilder.append("\">").append(string).append("</option>");
        }
        stringBuilder.append("</select></span>");
        return stringBuilder.toString();
    }

    public void setCommand(String string) {
        this.command = StringUtil.nval((String)this.getRequestParameter(string), (String)this.command);
    }

    public void setGamenId(String string) {
        this.gamenId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.gamenId);
    }

    public void setEditName(String string) {
        this.editName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.editName);
    }

    public void setOrderOnly(String string) {
        this.orderOnly = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.orderOnly);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("command", (Object)this.command).println("gamenId", (Object)this.gamenId).println("editName", (Object)this.editName).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

