/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Locale;
import java.util.Set;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class EqualsTag
extends CommonTagSupport {
    private static final String VERSION = "6.9.3.0 (2018/03/26)";
    private static final long serialVersionUID = 693020180326L;
    private static final Set<String> OPERATOR_SET = new ArraySet((Object[])new String[]{"EQ", "LT", "LE", "GT", "GE", "GE"});
    private static final Set<String> COMP_TYPE_SET = new ArraySet((Object[])new String[]{"STRING", "NUMBER"});
    private String value1;
    private String value2;
    private boolean ignoreCase;
    private boolean useTrim;
    private boolean isStartsWith;
    private boolean nullCheck;
    private boolean notEquals;
    private boolean isContains;
    private boolean isEndsWith;
    private boolean isMatches;
    private boolean useStop;
    private String operator = "EQ";
    private String compareType = "STRING";
    private boolean isException;
    private boolean isOccurExce;

    @Override
    public int doStartTag() {
        if (this.useTrim) {
            if (this.value1 != null) {
                this.value1 = this.value1.trim();
            }
            if (this.value2 != null) {
                this.value2 = this.value2.trim();
            }
        }
        if (this.ignoreCase) {
            if (this.value1 != null) {
                this.value1 = this.value1.toUpperCase(Locale.JAPAN);
            }
            if (this.value2 != null) {
                this.value2 = this.value2.toUpperCase(Locale.JAPAN);
            }
        }
        boolean bl = (this.isStartsWith && this.startsWith(this.value1, this.value2) || this.isContains && this.contains(this.value1, this.value2) || this.isEndsWith && this.endsWith(this.value1, this.value2) || this.isMatches && this.matches(this.value1, this.value2) || this.nullCheck && this.isNullCheck(this.value1) || this.isException && this.isOccurExce || this.operation(this.value1, this.value2, this.operator, this.compareType)) ^ this.notEquals;
        this.useStop = this.useStop && bl;
        return bl ? 1 : 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        return this.useStop ? 5 : 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.value1 = null;
        this.value2 = null;
        this.ignoreCase = false;
        this.useTrim = false;
        this.isStartsWith = false;
        this.nullCheck = false;
        this.notEquals = false;
        this.isContains = false;
        this.isEndsWith = false;
        this.isMatches = false;
        this.useStop = false;
        this.operator = "EQ";
        this.compareType = "STRING";
        this.isException = false;
        this.isOccurExce = false;
    }

    private boolean operation(String string, String string2, String string3, String string4) {
        boolean bl;
        if (this.isNullCheck(string) || this.isNullCheck(string2)) {
            return false;
        }
        if ("STRING".equals(string4)) {
            switch (string3) {
                case "LT": {
                    bl = string.compareTo(string2) < 0;
                    break;
                }
                case "GT": {
                    bl = string.compareTo(string2) > 0;
                    break;
                }
                case "LE": {
                    bl = string.compareTo(string2) <= 0;
                    break;
                }
                case "GE": {
                    bl = string.compareTo(string2) >= 0;
                    break;
                }
                default: {
                    bl = string.equals(string2);
                    break;
                }
            }
        } else {
            double d = StringUtil.parseDouble((String)string);
            double d2 = StringUtil.parseDouble((String)string2);
            switch (string3) {
                case "LT": {
                    bl = d < d2;
                    break;
                }
                case "GT": {
                    bl = d > d2;
                    break;
                }
                case "LE": {
                    bl = d <= d2;
                    break;
                }
                case "GE": {
                    bl = d >= d2;
                    break;
                }
                default: {
                    bl = Math.abs(d - d2) < 1.0E-7;
                }
            }
        }
        return bl;
    }

    private boolean startsWith(String string, String string2) {
        return !this.isNullCheck(string) && !this.isNullCheck(string2) && string.startsWith(string2);
    }

    private boolean isNullCheck(String string) {
        return string == null || string.isEmpty();
    }

    private boolean contains(String string, String string2) {
        return !this.isNullCheck(string) && !this.isNullCheck(string2) && string.contains(string2);
    }

    private boolean endsWith(String string, String string2) {
        return !this.isNullCheck(string) && !this.isNullCheck(string2) && string.endsWith(string2);
    }

    private boolean matches(String string, String string2) {
        return !this.isNullCheck(string) && !this.isNullCheck(string2) && string.matches(string2);
    }

    public void setVal1(String string) {
        try {
            this.value1 = this.getRequestParameter(string);
        }
        catch (Throwable throwable) {
            this.isOccurExce = true;
        }
    }

    public void setVal2(String string) {
        try {
            this.value2 = this.getRequestParameter(string);
        }
        catch (Throwable throwable) {
            this.isOccurExce = true;
        }
    }

    public void setIgnoreCase(String string) {
        this.ignoreCase = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.ignoreCase);
    }

    public void setUseTrim(String string) {
        this.useTrim = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTrim);
    }

    public void setStartsWith(String string) {
        this.isStartsWith = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isStartsWith);
    }

    public void setNullCheck(String string) {
        this.nullCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.nullCheck);
    }

    public void setNotEquals(String string) {
        this.notEquals = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.notEquals);
    }

    public void setContains(String string) {
        this.isContains = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isContains);
    }

    public void setEndsWith(String string) {
        this.isEndsWith = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isEndsWith);
    }

    public void setMatches(String string) {
        this.isMatches = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMatches);
    }

    public void setUseStop(String string) {
        this.useStop = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useStop);
    }

    public void setIsException(String string) {
        this.isException = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isException);
    }

    public void setOperator(String string) {
        this.operator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.operator);
        if (!this.check(this.operator, OPERATOR_SET)) {
            String string2 = "\u6307\u5b9a\u306e\u30aa\u30da\u30ec\u30fc\u30b7\u30e7\u30f3\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u30aa\u30da\u30ec\u30fc\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "operator=[" + string + "] " + CR + "operatorList=" + String.join((CharSequence)", ", OPERATOR_SET);
            throw new HybsSystemException(string2);
        }
    }

    public void setCompareType(String string) {
        this.compareType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.compareType);
        if (!this.check(this.compareType, COMP_TYPE_SET)) {
            String string2 = "\u6307\u5b9a\u306ecompareType\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002compareType\u30a8\u30e9\u30fc" + CR + "compareType=[" + string + "] " + CR + "compareTypeList=" + String.join((CharSequence)", ", COMP_TYPE_SET);
            throw new HybsSystemException(string2);
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("value1", (Object)this.value1).println("value2", (Object)this.value2).println("ignoreCase", (Object)this.ignoreCase).println("useTrim", (Object)this.useTrim).println("startsWith", (Object)this.isStartsWith).println("nullCheck", (Object)this.nullCheck).println("notEquals", (Object)this.notEquals).println("contains", (Object)this.isContains).println("endsWith", (Object)this.isEndsWith).println("matches", (Object)this.isMatches).println("useStop", (Object)this.useStop).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

