/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.HTMLTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class InputTag
extends HTMLTagSupport {
    private static final String VERSION = "6.9.8.0 (2018/05/28)";
    private static final long serialVersionUID = 698020180528L;
    private static final Set<String> TYPE_SET = new ArraySet((Object[])new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "button", "image", "file", "hidden", "search", "tel", "url", "email", "datetime", "date", "month", "week", "time", "datetime-local", "number", "range", "color"});
    private static final Set<String> TD_SET = new ArraySet((Object[])new String[]{"yes", "no", "false"});
    private final String CLM = HybsSystem.sysBool("HTML_LABEL_SEPARATOR") ? ":" : "";
    private String tdFlag = "yes";
    private String colspan = "";
    private String rowspan = "";
    private String nextForm;
    private final int COLUMNS_MAXSIZE = HybsSystem.sysInt("HTML_COLUMNS_MAXSIZE");
    private String body;

    @Override
    public int doStartTag() {
        return this.useTag() ? 2 : 0;
    }

    @Override
    public int doAfterBody() {
        this.body = this.getBodyString();
        return 0;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tdFlag = "yes";
        this.colspan = "";
        this.rowspan = "";
        this.nextForm = null;
        this.body = null;
    }

    @Override
    protected String makeTag() {
        String string;
        if (this.get("value") == null) {
            this.set("value", "");
        }
        String string2 = this.get("name");
        if (this.getMsglbl() == null) {
            this.setLbl(string2);
        }
        if (this.nextForm != null) {
            string = "nextForm(this,'" + this.nextForm + "'," + this.get("maxlength") + ");";
            this.set("onKeyup", string);
        }
        if (this.body == null) {
            this.body = "";
        }
        string = this.get("type");
        StringBuilder stringBuilder = new StringBuilder(200);
        if ("yes".equals(this.tdFlag)) {
            if (string != null && ("radio".equals(string) || "checkbox".equals(string))) {
                if (this.get("id") == null) {
                    this.set("id", TaglibUtil.getTagId());
                }
                stringBuilder.append("<td align=\"right\"").append(this.rowspan).append('>').append(XHTMLTag.input((Attributes)this.getAttributes())).append(this.body).append("</td><td").append(this.colspan).append(this.rowspan).append("><label for=\"").append(this.get("id")).append("\">").append(this.getLongLabel()).append("</label></td>");
            } else if (string != null && ("submit".equals(string) || "reset".equals(string) || "button".equals(string))) {
                this.set("value", this.getMsglbl());
                stringBuilder.append("<td").append(this.colspan).append(this.rowspan).append('>').append(XHTMLTag.input((Attributes)this.getAttributes())).append(this.body).append("</td><td").append(this.rowspan).append("></td>");
            } else {
                stringBuilder.append("<td class=\"label\"").append(this.rowspan).append('>').append(this.getLongLabel()).append(this.CLM).append("</td><td").append(this.colspan).append(this.rowspan).append('>').append(XHTMLTag.input((Attributes)this.getAttributes())).append(this.makeAimaiPicker(string2)).append(this.makeMustHidden(string2)).append(this.body).append("</td>");
            }
        } else if ("no".equals(this.tdFlag)) {
            if (string != null && ("radio".equals(string) || "checkbox".equals(string))) {
                stringBuilder.append("<label>").append(XHTMLTag.input((Attributes)this.getAttributes())).append(this.body).append("<span class=\"label\">").append(this.getLongLabel()).append("</span></label>");
            } else if (string != null && ("submit".equals(string) || "reset".equals(string) || "button".equals(string))) {
                this.set("value", this.getMsglbl());
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes())).append(this.body);
            } else {
                stringBuilder.append("<span class=\"label\">").append(this.getLongLabel()).append(this.CLM).append("</span>").append(XHTMLTag.input((Attributes)this.getAttributes())).append(this.makeAimaiPicker(string2)).append(this.makeMustHidden(string2)).append(this.body);
            }
        } else if (string != null && ("submit".equals(string) || "reset".equals(string) || "button".equals(string))) {
            this.set("value", this.getMsglbl());
            stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes())).append(this.body);
        } else {
            stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes())).append(this.makeAimaiPicker(string2)).append(this.makeMustHidden(string2)).append(this.body);
        }
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.set("name", this.getRequestParameter(string));
    }

    public void setType(String string) {
        String string2 = this.getRequestParameter(string);
        if (!this.check(string2, TYPE_SET)) {
            String string3 = "type \u5c5e\u6027\u306f\u3001\u4e0b\u8a18\u306e\u4e2d\u304b\u3089\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002type=[" + string2 + "]  in [" + String.join((CharSequence)", ", TYPE_SET) + "]";
            throw new HybsSystemException(string3);
        }
        this.set("type", string2);
    }

    public void setValue(String string) {
        this.set("value", this.getRequestParameter(string));
    }

    public void setSize(String string) {
        this.set("size", this.getRequestParameter(string));
    }

    public void setMaxlength(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.set("maxlength", string2);
        if (this.get("size") == null && string2 != null) {
            int n = Integer.parseInt(string2);
            if (n > this.COLUMNS_MAXSIZE) {
                n = this.COLUMNS_MAXSIZE;
            }
            this.set("size", String.valueOf(n));
        }
    }

    public void setChecked(String string) {
        String string2 = this.getRequestParameter(string);
        if ("checked".equals(string2)) {
            this.set("checked", "checked");
        }
    }

    public void setSrc(String string) {
        this.set("src", this.getRequestParameter(string));
    }

    public void setAlt(String string) {
        this.set("alt", this.getRequestParameter(string));
    }

    public void setAccept(String string) {
        this.set("accept", this.getRequestParameter(string));
    }

    public void setUsemap(String string) {
        this.set("usemap", this.getRequestParameter(string));
    }

    public void setIsmap(String string) {
        this.set("ismap", this.getRequestParameter(string));
    }

    public void setTd(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tdFlag);
        if (!this.check(string2, TD_SET)) {
            String string3 = "Error in SelectTag [td]: " + string2 + "  in [" + String.join((CharSequence)", ", TD_SET) + "] only used.";
            throw new HybsSystemException(string3);
        }
        this.tdFlag = string2;
    }

    public void setLbls(String string2) {
        String[] stringArray = this.getCSVParameter(string2);
        String string3 = Stream.of(stringArray).map(string -> this.getLabel((String)string)).collect(Collectors.joining(","));
        this.setLbl(string3);
    }

    public void setColspan(String string) {
        this.colspan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.colspan);
        if (this.colspan.length() > 0) {
            this.colspan = " colspan=\"" + this.colspan + "\" ";
        }
    }

    public void setRowspan(String string) {
        this.rowspan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rowspan);
        if (this.rowspan.length() > 0) {
            this.rowspan = " rowspan=\"" + this.rowspan + "\" ";
        }
    }

    public void setNextForm(String string) {
        this.nextForm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nextForm);
    }

    public void setUseRealTimeCheck(String string) {
        String string2 = this.getRequestParameter(string);
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            this.add("optionAttributes", "realTimeChk=\"" + string2 + "\"");
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tdFlag", (Object)this.tdFlag).println("colspan", (Object)this.colspan).println("rowspan", (Object)this.rowspan).println("nextForm", (Object)this.nextForm).println("HTML_LABEL_SEPARATOR", (Object)this.CLM).println("HTML_COLUMNS_MAXSIZE", (Object)this.COLUMNS_MAXSIZE).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

