<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC22"
	title	= "ｿｰｽ全文検索"
	date	= "2015/06/24"
	author	= "k.Hasegawa"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- テキスト索引の同期化 は、とりあえず毎回実行しておきます。(良い方法があれば、教えて) -->
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF76_TXT_IDX' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF83_TXT_IDX' ) }
</og:query>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- OracleTextで、CONTAINS に CLM をそのまま渡した場合予約語エラーになる為、{} でエスケープする。 -->
	select ADDRESS,FILENAME,null AS NOLINE,MODIFIED,FILEPATH,1 as TBLTYPE
			<og:text caseNN  ="{@TEXT_DATA}">
				, CTX_DOC.SNIPPET('GF76_TXT_IDX',UNIQ,'{@TEXT_DATA}') AS TEXTBODY , SCORE(1) AS SCORE
			</og:text>
			<og:text caseNull="{@TEXT_DATA}">, TO_CHAR(TEXTBODY) AS TEXTBODY, 50 AS SCORE</og:text>
	from GF76
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and   TBLSYU	= '{@TBLSYU}'
	and   'true'	= '{@GF76}'
	<og:where startKey="and">
		<og:and value = "CONTAINS ( FILEPATH, '{@TEXT_DATA}',1 ) &gt; 0"	/>
		<og:and value = "ADDRESS	like '{@ADDRESS}'"	/>
		<og:and value = "FILENAME	like '{@FILENAME}'"	/>
		<og:and value = "FILEPATH	like '{@FILEPATH}'"	/>
	</og:where>
	union
	select OBJ_TYPE,OBJ_NAME,NOLINE,DYSET,null,2 as TBLTYPE
			<og:text caseNN  ="{@TEXT_DATA}">
				, CTX_DOC.SNIPPET('GF83_TXT_IDX',UNIQ,'{@TEXT_DATA}') AS SRC_TEXT , SCORE(1) AS SCORE
			</og:text>
			<og:text caseNull="{@TEXT_DATA}">,TO_CHAR(substr(SRC_TEXT,1,1300)) AS SRC_TEXT, 50 AS SCORE</og:text>
	from GF83
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and   TBLSYU	= '{@TBLSYU}'
	and   'true'	= '{@GF83}'
	<og:where startKey="and">
		<og:and value = "CONTAINS ( SRC_TEXT, '{@TEXT_DATA}',1 ) &gt; 0"	/>
		<og:and value = "OBJ_TYPE	like '{@OBJ_TYPE}'"	/>
		<og:and value = "OBJ_NAME	like '{@OBJ_NAME}'"	/>
	</og:where>
	union
	select A.TYPE, A.NAME,A.LINE,TO_CHAR(B.LAST_DDL_TIME,'YYYYMMDDHH24MISS'),null,3 as TBLTYPE
			,TO_CHAR(A.TEXT) AS TEXT , 50 AS SCORE
	from DBA_SOURCE A inner join ALL_OBJECTS B
		on  A.OWNER = B.OWNER
		and A.TYPE  = B.OBJECT_TYPE
		and A.NAME  = B.OBJECT_NAME
	where A.OWNER	= '{@SYSTEM_ID}'
	and   'true'	= '{@DBA_SOURCE}'
	<og:where startKey="and">
		<og:and value = "UPPER(A.TEXT) LIKE UPPER( '{@TEXT_DATA}' )"	/>
		<og:and value = "A.TYPE	like '{@TYPE}'"	/>
		<og:and value = "A.NAME	like '{@NAME}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "1,2,3,4" />
</og:query>

<og:columnEditor column="TBLTYPE" renderer="KVMENU" param="1:GF76 2:GF83 3:SRC" />

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	writable	= "false"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
