<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useTabLink="true">
	<style type="text/css">
		ul { float:left; }
	</style>
</og:head>

<og:equals val1="{@command}" val2="NEW">
	<!-- 共通前処理 -->
	<og:userInfo command="REMOVE"	key="BASE_GAMENID" />
	<og:userInfo command="SET"		key="BASE_GAMENID" value="{@GAMENID}" />

	<!-- 画面編集用前処理 -->
	<og:userInfo command="REMOVE"	key="EDIT_NAME" />
	<og:userInfo command="SET"		key="EDIT_NAME" value="{@editName}" />

	<!-- 出力方法編集用前処理 -->
	<og:fileUD typeDownload="true" />
	<og:userInfo command="SET"		key="CLM_NAMES" value="{@DB.CLM_NAMES}" />

	<!-- ファイルがなければ作成する。fileタグは、不成立時に、BODY部を実行する。-->
	<og:file action="exists" fileURL="{@SYS.REAL_PATH}report/{@USER.BASE_GAMENID}" file1="fileDownloadList.txt" useStop="false">
		<!-- 存在しない場合は、雛形ファイルをコピーして作成する。 -->
		<!-- copyST の file1 は、getResourceAsStream を使用の為、/gf/jsp/･･･ ではなく、/jsp/･･･ でのアドレス指定で取得します。 -->
		<og:file action="copyST"
					file1="/jsp/common/fileDownloadListDef.txt"
					file2="{@SYS.REAL_PATH}report/{@USER.BASE_GAMENID}/fileDownloadList.txt" >
			<og:message lbl="MSG0068" /><br />	<!-- 処理の実行中にエラーが発生しました。 -->
			<og:text>
	{@SYS.JSP}/common/fileDownloadListDef.txt ⇒ {@SYS.REAL_PATH}report/{@USER.BASE_GAMENID}/fileDownloadList.txt
			</og:text>
		</og:file>
	</og:file>

<!--
	<og:file action="mkdir" fileURL="{@SYS.REAL_PATH}report"/>
	<og:file action="mkdir" fileURL="{@SYS.REAL_PATH}report/{@USER.BASE_GAMENID}"/>

	<og:file action="exists" fileURL="{@SYS.REAL_PATH}report/{@USER.BASE_GAMENID}" file1="fileDownloadList.txt" useStop="false">
		<og:readTable
			command		= "NEW"
			fileURL		= "{@SYS.REAL_PATH}jsp/common/"
			filename	= "fileDownloadListDef.txt"
			scope		= "request"
			mainTrans	= "false"
		/>
		<og:writeTable
			fileURL		= "{@SYS.REAL_PATH}report/{@USER.BASE_GAMENID}"
			filename	= "fileDownloadList.txt"
			scope		= "request"
			headerSequence = "NLD"
		/>
	</og:file>
-->
</og:equals>

<og:text><img src="{@SYS.JSP}/image/close.gif" alt="close" onClick="top.window.close();" style="float:left; padding:2px; margin-right: 20px;" /></og:text>

<!-- 画面リソースの3桁目を指定しない、または"e"を指定した場合は、edit=trueの引数が送られる -->
<og:equals val1="{@edit}" val2="true">
	<og:tabLink listType="TAG" openTab="true" openTabName="CLMSEQ" constKeys="command" constVals="RENEW" target="EDIT">
		<og:tabList name="CLMSEQ" href="result_CLMSEQ.jsp" lbl="CONFIG_CLMSEQ" keys="fullEdit,readonly" vals="{@fullEdit},{@readonly}"/>
		<og:tabList name="REPORT" href="result_REPORT.jsp" lbl="CONFIG_REPORT" />
	</og:tabLink>
</og:equals>

<og:equals val1="{@edit}" val2="true" notEquals="true">
	<og:tabLink listType="TAG" openTab="true" openTabName="REPORT" constKeys="command" constVals="RENEW" target="EDIT">
		<og:tabList name="REPORT" href="result_REPORT.jsp" lbl="CONFIG_REPORT" />
	</og:tabLink>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
