/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class DBTypeCheckUtil {
    private static final String CODE = HybsSystem.sys("DB_ENCODE");
    private static final boolean USE_TEXT_LEN = HybsSystem.sysBool("DB_USE_TEXT_LENGTH");

    private DBTypeCheckUtil() {
    }

    public static String rangeCheck(String string, char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c <= c3 && c3 <= c2) {
                stringBuilder.append(c3);
                continue;
            }
            stringBuilder.append("<span class=\"NG\">").append(c3).append("</span>");
            bl = true;
        }
        return bl ? stringBuilder.toString() : null;
    }

    public static String sizeXCheck(String string, int n, int n2) {
        int n3 = string.indexOf(46);
        int n4 = n3 >= 0 ? n3 : string.length();
        if (string.charAt(0) == '-') {
            --n4;
        }
        return n4 > n ? String.valueOf(n4) : null;
    }

    public static String sizeYCheck(String string, int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        int n3 = string.indexOf(46);
        int n4 = n3 >= 0 ? string.length() - n3 - 1 : 0;
        if (n4 > n2) {
            return String.valueOf(n4);
        }
        return null;
    }

    public static String decimalPointCheck(String string) {
        String string2 = null;
        if (string.indexOf(46) != string.lastIndexOf(46)) {
            string2 = DBTypeCheckUtil.changeErrorPath(string, '.');
        }
        return string2;
    }

    public static String decimalCodeCheck(String string) {
        String string2 = null;
        if (string.lastIndexOf(45) > 0) {
            string2 = DBTypeCheckUtil.changeErrorPath(string, '-');
        }
        return string2;
    }

    public static String numberFormatCheck(String string) {
        char c;
        int n;
        boolean bl = false;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if ('0' <= c && '9' >= c || '-' == c) continue;
            bl = true;
            break;
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (('0' > c || '9' < c) && '-' != c) {
                    stringBuilder.append("<span class=\"NG\">").append(c).append("</span>");
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String decimalFormatCheck(String string) {
        char c;
        int n;
        boolean bl = false;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if ('0' <= c && '9' >= c || '.' == c || '-' == c) continue;
            bl = true;
            break;
        }
        if (string.length() == 1 && (string.charAt(0) == '.' || string.charAt(0) == '-')) {
            bl = true;
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (('0' > c || '9' < c) && '.' != c && '-' != c) {
                    stringBuilder.append("<span class=\"NG\">").append(c).append("</span>");
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String ymdFormatCheck(String string) {
        String string2;
        if (string.startsWith("0000") || string.startsWith("9999")) {
            return null;
        }
        int n = string.length();
        if (n >= 6 && (string2 = DBTypeCheckUtil.ymdhmsCheck(string, 4, 6, 1, 12)) != null) {
            return string2;
        }
        if (n >= 8 && (string2 = DBTypeCheckUtil.ymdhmsCheck(string, 6, 8, 1, 31)) != null) {
            return string2;
        }
        if (n >= 10 && (string2 = DBTypeCheckUtil.ymdhmsCheck(string, 8, 10, 0, 24)) != null) {
            return string2;
        }
        if (n >= 12 && (string2 = DBTypeCheckUtil.ymdhmsCheck(string, 10, 12, 0, 60)) != null) {
            return string2;
        }
        if (n == 14 && (string2 = DBTypeCheckUtil.ymdhmsCheck(string, 12, 14, 0, 60)) != null) {
            return string2;
        }
        return null;
    }

    public static String hmsFormatCheck(String string) {
        String string2;
        int n = string.length();
        if (n >= 2 && (string2 = DBTypeCheckUtil.ymdhmsCheck(string, 0, 2, 0, 24)) != null) {
            return string2;
        }
        if (n >= 4 && (string2 = DBTypeCheckUtil.ymdhmsCheck(string, 2, 4, 0, 60)) != null) {
            return string2;
        }
        if (n == 6 && (string2 = DBTypeCheckUtil.ymdhmsCheck(string, 4, 6, 0, 60)) != null) {
            return string2;
        }
        return null;
    }

    public static String ymdhmsCheck(String string, int n, int n2, int n3, int n4) {
        String string2 = null;
        int n5 = Integer.parseInt(string.substring(n, n2));
        if (n5 < n3 || n4 < n5) {
            string2 = string.substring(0, n) + "<span class=\"NG\">" + string.substring(n, n2) + "</span>" + string.substring(n2);
        }
        return string2;
    }

    private static String changeErrorPath(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c == c2) {
                stringBuilder.append("<span class=\"NG\">").append(c2).append("</span>");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String byteLengthCheck(String string, int n) {
        int n2;
        String string2 = null;
        if (USE_TEXT_LEN) {
            n2 = string.length();
        } else {
            byte[] byArray = StringUtil.makeByte((String)string, (String)CODE);
            n2 = byArray.length;
        }
        if (n2 > n) {
            string2 = String.valueOf(n2);
        }
        return string2;
    }

    public static String matcheCheck(String string, String string2) {
        return string2 == null || string2.isEmpty() || string.matches(string2) ? null : "<span class=\"NG\">" + string + "</span> regex=" + string2;
    }
}

