/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.CategoryCrosshairState;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.opengion.hayabusa.io.HybsDataset;
import org.opengion.hayabusa.io.HybsDrawItem;

public class HybsCategoryPlot
extends CategoryPlot {
    private static final long serialVersionUID = 602020140919L;
    private final ConcurrentMap<Integer, Double> barWdMap = new ConcurrentHashMap<Integer, Double>();
    private int serNo = -1;
    private int rangeSkip = -1;
    private final int hsCode = Long.valueOf(System.nanoTime()).hashCode();

    public HybsCategoryPlot() {
        this(-1);
    }

    protected HybsCategoryPlot(int n) {
        this.serNo = n;
    }

    protected void setSeriesPikup(int n) {
        int n2 = this.serNo;
        this.serNo = n;
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        CategoryURLGenerator categoryURLGenerator = categoryItemRenderer.getSeriesItemURLGenerator(n2);
        if (categoryURLGenerator != null) {
            categoryItemRenderer.setSeriesItemURLGenerator(n2, null);
            categoryItemRenderer.setSeriesItemURLGenerator(this.serNo, categoryURLGenerator);
        }
        if (categoryItemRenderer.isSeriesItemLabelsVisible(n2)) {
            categoryItemRenderer.setSeriesItemLabelsVisible(n2, false);
            categoryItemRenderer.setSeriesItemLabelsVisible(this.serNo, true);
        }
    }

    protected void setRangeSkip(int n) {
        this.rangeSkip = n;
    }

    protected void setBarWidth(int n, Double d) {
        if (d != null) {
            this.barWdMap.put(n, d);
        }
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, PlotRenderingInfo plotRenderingInfo, CategoryCrosshairState categoryCrosshairState) {
        boolean bl;
        boolean bl2 = false;
        CategoryDataset categoryDataset = this.getDataset(n);
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        this.mapDatasetToRangeAxis(n, n);
        CategoryAxis categoryAxis = null;
        categoryAxis = categoryItemRenderer instanceof StackedBarRenderer ? this.getDomainAxis(n) : this.getDomainAxisForDataset(n);
        ValueAxis valueAxis = this.getRangeAxis(n);
        boolean bl3 = bl = !DatasetUtilities.isEmptyOrNull((CategoryDataset)categoryDataset);
        if (bl && categoryItemRenderer != null) {
            bl2 = true;
            CategoryItemRendererState categoryItemRendererState = categoryItemRenderer.initialise(graphics2D, rectangle2D, (CategoryPlot)this, n, plotRenderingInfo);
            Double d = (Double)this.barWdMap.get(n);
            if (d != null) {
                categoryItemRendererState.setBarWidth(d.doubleValue());
            }
            if (categoryItemRenderer instanceof HybsDrawItem) {
                if (categoryDataset instanceof HybsDataset) {
                    Color[] colorArray = ((HybsDataset)categoryDataset).getCategoryColor();
                    ((HybsDrawItem)categoryItemRenderer).setCategoryColor(colorArray);
                }
                ((HybsDrawItem)categoryItemRenderer).drawItem2(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, this.serNo);
            } else {
                int n2 = categoryDataset.getColumnCount();
                int n3 = categoryDataset.getRowCount();
                int n4 = categoryItemRenderer.getPassCount();
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            if (k == this.serNo) continue;
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, (CategoryPlot)this, categoryAxis, valueAxis, categoryDataset, k, j, i);
                        }
                        if (this.serNo < 0) continue;
                        categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, (CategoryPlot)this, categoryAxis, valueAxis, categoryDataset, this.serNo, j, i);
                    }
                }
            }
        }
        return bl2;
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.rangeSkip <= 0) {
            super.drawRangeGridlines(graphics2D, rectangle2D, list);
        } else if (this.isRangeGridlinesVisible()) {
            Stroke stroke = this.getRangeGridlineStroke();
            Paint paint = this.getRangeGridlinePaint();
            if (stroke != null && paint != null) {
                ValueAxis valueAxis = this.getRangeAxis();
                CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                if (valueAxis != null && categoryItemRenderer != null) {
                    Iterator iterator = list.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        ValueTick valueTick = (ValueTick)iterator.next();
                        if (n % this.rangeSkip == 0) {
                            categoryItemRenderer.drawRangeGridline(graphics2D, (CategoryPlot)this, valueAxis, rectangle2D, valueTick.getValue());
                        }
                        ++n;
                    }
                }
            }
        }
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.hsCode == ((HybsCategoryPlot)((Object)object)).hsCode;
    }

    public int hashCode() {
        return this.hsCode;
    }
}

