/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Arrays;
import java.util.Comparator;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.html.ViewForm;
import org.opengion.hayabusa.html.ViewFormFactory;
import org.opengion.hayabusa.resource.ResourceManager;

final class TaglibUtil {
    static final String VIEW_ID = "HYBS_VIEW";
    static final String LINK_ID = "HYBS_LINK";
    static final String MARK_ID = "HYBS_MARK";
    private static int tagId;
    private static final Comparator<? super ErrMsg> ERR_COMP;

    private TaglibUtil() {
    }

    static String getTagId() {
        String string = "ID" + tagId++;
        if (tagId >= 100000) {
            tagId = 0;
        }
        return string;
    }

    static String makeHTMLErrorTable(ErrorMessage errorMessage, ResourceManager resourceManager) {
        if (errorMessage == null) {
            return "";
        }
        String[] stringArray = errorMessage.isSetPgStep() ? new String[]{"ROW_NO", "KEKKA", "MSGID", "MESSAGE", "PG", "STEP"} : new String[]{"ROW_NO", "KEKKA", "MSGID", "MESSAGE"};
        int n = stringArray.length;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n);
        for (int i = 0; i < n; ++i) {
            DBColumn dBColumn = resourceManager.makeDBColumn(stringArray[i]);
            dBTableModel.setDBColumn(i, dBColumn);
        }
        ErrMsg[] errMsgArray = errorMessage.toArray();
        Arrays.sort(errMsgArray, ERR_COMP);
        for (int i = 0; i < errorMessage.size(); ++i) {
            ErrMsg errMsg = errMsgArray[i];
            String[] stringArray2 = new String[n];
            stringArray2[0] = String.valueOf(errMsg.getNo());
            stringArray2[1] = String.valueOf(errMsg.getKekka());
            stringArray2[2] = errMsg.getId();
            String string = resourceManager.getLabel(errMsg);
            if (string != null) {
                int n2;
                if ((string = string.trim()).contains("Exception:")) {
                    string = string.replaceAll("Exception: ", "Exception:\n");
                }
                if ((n2 = string.indexOf("JasperException")) >= 0) {
                    int n3 = string.indexOf("\n\n", n2);
                    string = n3 >= 0 ? string.substring(0, n2) + StringUtil.htmlFilter((String)string.substring(n2, n3)) + string.substring(n3) : string.substring(0, n2) + StringUtil.htmlFilter((String)string.substring(n2));
                }
                stringArray2[3] = "<pre>" + string + "</pre>";
            }
            if (errorMessage.isSetPgStep()) {
                stringArray2[4] = errMsg.getPg();
                stringArray2[5] = errMsg.getStep();
            }
            dBTableModel.addColumnValues(stringArray2, null, false);
            String string2 = resourceManager.getDescription(errMsg);
            if (string2 == null || string2.length() <= 0) continue;
            String[] stringArray3 = new String[n];
            stringArray3[3] = string2;
            dBTableModel.addColumnValues(stringArray3, null, false);
        }
        ViewForm viewForm = ViewFormFactory.newInstance("HTMLTable");
        viewForm.init(dBTableModel);
        if (!errorMessage.isOK()) {
            viewForm.setViewClass("errorView");
            viewForm.setBgColorCycle(-1 * errorMessage.getKekka());
            viewForm.setNumberType("delete");
            viewForm.setUseTableSorter(false);
            viewForm.setUseScrollBar(false);
        }
        return viewForm.create();
    }

    static String makeHTMLSimpleErrorList(ErrorMessage errorMessage, ResourceManager resourceManager) {
        if (errorMessage == null) {
            return "";
        }
        String[] stringArray = new String[]{"MESSAGE"};
        int n = stringArray.length;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n);
        for (int i = 0; i < n; ++i) {
            DBColumn dBColumn = resourceManager.makeDBColumn(stringArray[i]);
            dBTableModel.setDBColumn(i, dBColumn);
        }
        ErrMsg[] errMsgArray = errorMessage.toArray();
        Arrays.sort(errMsgArray, ERR_COMP);
        for (int i = 0; i < errorMessage.size(); ++i) {
            ErrMsg errMsg = errMsgArray[i];
            String[] stringArray2 = new String[n];
            stringArray2[0] = resourceManager.getShortLabel(errMsg.getId()) + "(" + errMsg.getId() + ")";
            dBTableModel.addColumnValues(stringArray2, null, false);
        }
        ViewForm viewForm = ViewFormFactory.newInstance("HTMLSimpleList");
        viewForm.init(dBTableModel);
        if (!errorMessage.isOK()) {
            viewForm.setBgColorCycle(-1 * errorMessage.getKekka());
        }
        return viewForm.create();
    }

    static {
        ERR_COMP = new Comparator<ErrMsg>(){

            @Override
            public int compare(ErrMsg errMsg, ErrMsg errMsg2) {
                return errMsg.getNo() - errMsg2.getNo();
            }
        };
    }
}

