/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.opengion.fukurou.fileexec.XLogger;

public final class MsgUtil {
    private static final XLogger LOGGER = XLogger.getLogger(MsgUtil.class.getName());
    public static final String F_BS_NM = "org.opengion.fukurou.message";
    private static final int BUFFER_MIDDLE = 200;
    private static final int STACKTRACE_COUNT = 5;
    private static final ResourceBundle.Control UTF8_CONTROL = new ResourceBundle.Control(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            Object object;
            String string3 = this.toBundleName(string, locale);
            String string4 = this.toResourceName(string3, "properties");
            InputStream inputStream = null;
            if (bl) {
                URLConnection uRLConnection;
                object = classLoader.getResource(string4);
                if (object != null && (uRLConnection = ((URL)object).openConnection()) != null) {
                    uRLConnection.setUseCaches(false);
                    inputStream = uRLConnection.getInputStream();
                }
            } else {
                inputStream = classLoader.getResourceAsStream(string4);
            }
            object = null;
            if (inputStream != null) {
                try {
                    object = new PropertyResourceBundle(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
                }
                finally {
                    inputStream.close();
                }
            }
            return object;
        }
    };

    private MsgUtil() {
    }

    public static String getMsg(String string, Object ... objectArray) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(F_BS_NM, Locale.getDefault(), UTF8_CONTROL);
        try {
            return string + ":" + MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
        catch (RuntimeException runtimeException) {
            String string2 = string + "[" + Arrays.toString(objectArray) + "]";
            LOGGER.warning(runtimeException, () -> "\u3010WARNING\u3011 " + string2);
            return string2;
        }
    }

    public static RuntimeException throwException(String string, Object ... objectArray) {
        return MsgUtil.throwException(null, string, objectArray);
    }

    public static RuntimeException throwException(Throwable throwable, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(200).append(MsgUtil.getMsg(string, objectArray));
        if (throwable != null) {
            stringBuilder.append("\n\t").append(throwable.getMessage());
        }
        String string2 = stringBuilder.toString();
        RuntimeException runtimeException = new RuntimeException(string2, throwable);
        LOGGER.warning(runtimeException, () -> "\u3010WARNING\u3011 " + string2);
        return runtimeException;
    }

    public static String errPrintln(String string, Object ... objectArray) {
        return MsgUtil.errPrintln(null, string, objectArray);
    }

    public static String errPrintln(Throwable throwable, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(200).append(MsgUtil.getMsg(string, objectArray));
        if (throwable != null) {
            stringBuilder.append("\n\t").append(throwable.getMessage());
            int n = 0;
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string2 = stackTraceElement.getClassName();
                if (string2.contains("MsgUtil") || !string2.contains("jp.euromap.eu63") && n >= 5) continue;
                stringBuilder.append("\n\t").append(stackTraceElement.toString());
                ++n;
            }
        }
        LOGGER.warning(() -> "\u3010WARNING\u3011 " + stringBuilder.toString());
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(F_BS_NM, Locale.getDefault(), UTF8_CONTROL);
        for (String string : new TreeSet<String>(resourceBundle.keySet())) {
            System.out.println(string + ":\t" + resourceBundle.getString(string));
        }
    }
}

