/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsEntry;

public class Process_TableWriter
extends AbstractProcess
implements ChainProcess {
    private static final String CNST_KEY = "const_";
    private String outfile;
    private PrintWriter writer;
    private char separator = (char)9;
    private String[] cnstClm;
    private int[] cnstClmNos;
    private String[] constVal;
    private File file;
    private String encode = System.getProperty("file.encoding");
    private boolean append;
    private boolean useHeader = true;
    private boolean useNumber = true;
    private boolean useWquot;
    private boolean useDataWquot = true;
    private boolean omitCTRL;
    private String lineFormat;
    private boolean display;
    private boolean debug;
    private boolean firstRow = true;
    private int count;
    private Formatter format;
    private static final Map<String, String> MUST_PROPARTY = new LinkedHashMap<String, String>();
    private static final Map<String, String> USABLE_PROPARTY;

    public Process_TableWriter() {
        super("org.opengion.fukurou.process.Process_TableWriter", MUST_PROPARTY, USABLE_PROPARTY);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.outfile = argument.getProparty("outfile");
        this.encode = argument.getProparty("encode", this.encode);
        this.append = argument.getProparty("append", this.append);
        this.useHeader = argument.getProparty("useHeader", this.useHeader);
        this.useNumber = argument.getProparty("useNumber", this.useNumber);
        this.useWquot = argument.getProparty("useWquot", this.useWquot);
        this.useDataWquot = argument.getProparty("useDataWquot", this.useDataWquot);
        this.omitCTRL = argument.getProparty("omitCTRL", this.omitCTRL);
        HybsEntry[] hybsEntryArray = argument.getEntrys(CNST_KEY);
        this.lineFormat = argument.getProparty("lineFormat", this.lineFormat);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        String string = argument.getProparty("sep", null);
        if (string != null && string.length() > 0) {
            this.separator = string.charAt(0);
        }
        int n = hybsEntryArray.length;
        this.cnstClm = new String[n];
        this.constVal = new String[n];
        for (int i = 0; i < n; ++i) {
            this.cnstClm[i] = hybsEntryArray[i].getKey();
            this.constVal[i] = hybsEntryArray[i].getValue();
        }
        if (this.outfile == null) {
            throw new OgRuntimeException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.file = new File(this.outfile);
        File file = this.file.getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            String string2 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file + "]";
            throw new OgRuntimeException(string2);
        }
    }

    @Override
    public void end(boolean bl) {
        if (this.writer != null) {
            this.writer.flush();
            Closer.ioClose(this.writer);
            this.writer = null;
        }
    }

    @Override
    public LineModel action(LineModel lineModel) {
        int n;
        ++this.count;
        if (this.firstRow) {
            this.writer = FileUtil.getPrintWriter(this.file, this.encode, this.append);
            if (this.useHeader && this.useNumber) {
                this.writeName(lineModel);
            }
            n = this.cnstClm.length;
            this.cnstClmNos = new int[n];
            for (int i = 0; i < n; ++i) {
                this.cnstClmNos[i] = lineModel.getColumnNo(this.cnstClm[i]);
            }
            if (this.lineFormat != null) {
                this.format = new Formatter(lineModel, this.lineFormat);
            }
            this.firstRow = false;
            if (this.display) {
                this.println(lineModel.nameLine());
            }
        }
        for (n = 0; n < this.cnstClmNos.length; ++n) {
            lineModel.setValue(this.cnstClmNos[n], this.constVal[n]);
        }
        if (this.lineFormat == null) {
            this.writeData(lineModel);
        } else {
            String string = this.format.getLineFormatString(lineModel);
            this.writer.println(string);
        }
        if (this.display) {
            this.println(lineModel.dataLine());
        }
        return lineModel;
    }

    private void writeName(LineModel lineModel) {
        int n = lineModel.size();
        this.writer.print("#Name");
        for (int i = 0; i < n; ++i) {
            this.writer.print(this.separator);
            this.writer.print(lineModel.getName(i));
        }
        this.writer.println();
    }

    private void writeData(LineModel lineModel) {
        int n = lineModel.size();
        if (this.useNumber) {
            this.writer.print(lineModel.getRowNo());
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            if (this.useNumber || i != 0) {
                this.writer.print(this.separator);
            }
            if ((object = lineModel.getValue(i)) == null) {
                object = "";
            }
            String string = String.valueOf(object);
            if (this.useDataWquot && string.indexOf(34) >= 0) {
                string = string.replaceAll("\"", "\"\"");
            }
            if (this.omitCTRL) {
                string = string.replaceAll("\\s", " ");
            }
            if (!this.omitCTRL && string.indexOf(CR) >= 0 || this.useWquot) {
                string = "\"" + string + "\"";
            }
            this.writer.print(string);
        }
        this.writer.println();
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + '\t' + "Output File  : " + this.outfile + CR + '\t' + "Output Count : " + this.count;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(500).append("Process_TableWriter \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f\u30c7\u30fc\u30bf\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u66f8\u304d\u8fbc\u3080").append(CR).append("CainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append(CR).append("\u4e0a\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002)\u304b\u3089").append(CR).append("\u53d7\u3051\u53d6\u3063\u305fLineModel \u3092\u5143\u306b\u3001DBTableModel \u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb\u3092\u51fa\u529b\u3057\u307e\u3059\u3002").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_TableWriter().usage());
    }

    static {
        MUST_PROPARTY.put("outfile", "\u51fa\u529b\uff8c\uff67\uff72\uff99\u540d (\u5fc5\u9808)");
        USABLE_PROPARTY = new LinkedHashMap<String, String>();
        USABLE_PROPARTY.put("sep", "\u533a\u5207\u308a\u6587\u5b57(\u521d\u671f\u5024:\uff80\uff8c\uff9e)");
        USABLE_PROPARTY.put("encode", "\u51fa\u529b\uff8c\uff67\uff72\uff99\u306e\uff74\uff9d\uff7a\uff70\uff84\uff9e\uff80\uff72\uff8c\uff9f");
        USABLE_PROPARTY.put("append", "\u51fa\u529b\uff8c\uff67\uff72\uff99\u3092\u3001\u8ffd\u8a18\u3059\u308b(true)\u304b\u65b0\u898f\u4f5c\u6210\u3059\u308b(false)\u304b\u3002");
        USABLE_PROPARTY.put("useHeader", "\uff8d\uff6f\uff80\uff9e\uff70\u60c5\u5831(#NAME\u884c)\u3092\u51fa\u529b\u3059\u308b(true)\u304b\u51fa\u529b\u3057\u306a\u3044(false)\u304b\u3002");
        USABLE_PROPARTY.put("useNumber", "\u884c\u756a\u53f7\u3092\u51fa\u529b\u3059\u308b(true)\u304b\u51fa\u529b\u3057\u306a\u3044(false)\u304b\u3002");
        USABLE_PROPARTY.put("useWquot", "\u51fa\u529b\uff83\uff9e\uff70\uff80\u3092\uff80\uff9e\uff8c\uff9e\uff99\uff78\uff75\uff70\uff83\uff70\uff7c\uff6e\uff9d\u3067\u62ec\u308b(true)\u304b\u305d\u306e\u307e\u307e(false)\u304b\u3002");
        USABLE_PROPARTY.put("useDataWquot", "\u51fa\u529b\uff83\uff9e\uff70\uff80\u4e2d\u306e\uff80\uff9e\uff8c\uff9e\uff99\uff78\uff75\uff70\uff83\uff70\uff7c\uff6e\uff9d\u3092\u91cd\u306d\u308b(true)\u304b\u305d\u306e\u307e\u307e(false)\u304b\u3002");
        USABLE_PROPARTY.put("omitCTRL", "\uff7a\uff9d\uff84\uff9b\uff70\uff99\u6587\u5b57\u3092\u524a\u9664\u3059\u308b(true)\u304b\u305d\u306e\u307e\u307e(false)\u304b\u3002");
        USABLE_PROPARTY.put(CNST_KEY, "LineModel \u306e\u30ad\u30fc(const_ \u306b\u7d9a\u304f\u6587\u5b57\u5217)\u306e\u5024\u306b\u3001\u56fa\u5b9a\u5024\u3092" + CR + "\u8a2d\u5b9a\u3057\u307e\u3059\u3002\u30ad\u30fc\u304c\u7570\u306a\u308c\u3070\u3001\u8907\u6570\u306e\u30ab\u30e9\u30e0\u540d\u3092\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + CR + "\u4f8b: -const_FGJ=1");
        USABLE_PROPARTY.put("lineFormat", "1\u884c\u5206\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        USABLE_PROPARTY.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + " (\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        USABLE_PROPARTY.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

