/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.ColorMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.JsChartData;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.JsChartTag;

public class JsChartDataTag
extends CommonTagSupport {
    private static final String VERSION = "7.0.1.2 (2018/11/04)";
    private static final long serialVersionUID = 701220181104L;
    private static final Set<String> SET_TYPE = new ArraySet((Object[])new String[]{"line", "bar"});
    private static final Set<String> SET_PSTYLE = new ArraySet((Object[])new String[]{"circle", "triangle", "rect", "rectRot", "cross", "crossRot", "star", "line", "dash"});
    private static final Set<String> SET_POSITION = new ArraySet((Object[])new String[]{"left", "right"});
    private static final Set<String> SET_SCALE = new ArraySet((Object[])new String[]{"linear", "category", "realtime"});
    private static final Set<String> SET_BOOLEAN = new ArraySet((Object[])new String[]{"true", "false"});
    private JsChartData jsData = new JsChartData();
    private String yAxisID;
    private boolean fill;
    private String borderColor;
    private String backgroundColor;
    private static final String D_TENSION = "0.4";

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        JsChartTag jsChartTag = (JsChartTag)JsChartDataTag.findAncestorWithClass((Tag)this, JsChartTag.class);
        if (jsChartTag == null) {
            throw new HybsSystemException("jsChart \u30bf\u30b0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        int n = jsChartTag.getJsChartDataSize();
        if (this.yAxisID == null) {
            this.yAxisID = "y" + n;
        }
        if (n == 0) {
            this.jsData.setUseAxis(true);
        }
        this.jsData.setId(this.yAxisID);
        this.setBorderOrBackColor(n, jsChartTag.isOneColor());
        this.jsData.addDataset("fill", String.valueOf(this.fill), true);
        jsChartTag.addJsChartData(this.jsData);
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.jsData = new JsChartData();
        this.yAxisID = null;
        this.fill = false;
        this.borderColor = null;
        this.backgroundColor = null;
    }

    private void setBorderOrBackColor(int n, boolean bl) {
        if (this.borderColor == null && this.backgroundColor != null) {
            this.borderColor = this.backgroundColor;
        } else if (this.backgroundColor == null && this.borderColor != null) {
            this.backgroundColor = this.borderColor;
        } else if (this.borderColor == null && this.backgroundColor == null) {
            this.backgroundColor = this.borderColor = bl ? ColorMap.getColorKey((int)n) : "['" + String.join((CharSequence)"','", ColorMap.getColorKeys()) + "']";
        }
        if ("PASTEL".equalsIgnoreCase(this.borderColor)) {
            this.borderColor = bl ? ColorMap.getPastelKey((int)n) : "['" + String.join((CharSequence)"','", ColorMap.getPastelKeys()) + "']";
        } else if ("VIVID".equalsIgnoreCase(this.borderColor)) {
            String string = this.borderColor = bl ? ColorMap.getVibidKey((int)n) : "['" + String.join((CharSequence)"','", ColorMap.getVibidKeys()) + "']";
        }
        if ("PASTEL".equalsIgnoreCase(this.backgroundColor)) {
            this.backgroundColor = bl ? ColorMap.getPastelKey((int)n) : "['" + String.join((CharSequence)"','", ColorMap.getPastelKeys()) + "']";
        } else if ("VIVID".equalsIgnoreCase(this.backgroundColor)) {
            this.backgroundColor = bl ? ColorMap.getVibidKey((int)n) : "['" + String.join((CharSequence)"','", ColorMap.getVibidKeys()) + "']";
        }
        this.jsData.addDataset("borderColor", this.borderColor, false);
        this.jsData.addDataset("backgroundColor", this.backgroundColor, false);
    }

    private void checkPara(String string, Set<String> set, String string2) {
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string}) && !this.check(string, set)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e").append(string2).append("\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append(string2).append("=[").append(string).append(']').append(CR).append(set);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setChartColumn(String string) {
        this.jsData.setChartColumn(StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setLabel(String string) {
        this.jsData.addDataset("label", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setType(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.checkPara(string2, SET_TYPE, "type");
        this.jsData.addDataset("type", string2, false);
    }

    public void setFill(String string) {
        this.fill = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.fill);
    }

    public void setTension(String string) {
        this.jsData.addDataset("tension", StringUtil.nval((String)this.getRequestParameter(string), (String)D_TENSION), true);
    }

    public void setBorderColor(String string) {
        this.borderColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.borderColor);
    }

    public void setColorNo(String string) {
        if (this.borderColor == null) {
            String[] stringArray = this.getCSVParameter(string);
            if (stringArray.length == 1) {
                this.borderColor = ColorMap.getColorKey((String)stringArray[0]);
            } else {
                StringJoiner stringJoiner = new StringJoiner("','", "['", "']");
                for (String string2 : stringArray) {
                    stringJoiner.add(ColorMap.getColorKey((String)string2, (String)"rgba( 255,255,255,0 )"));
                }
                this.borderColor = stringJoiner.toString();
            }
        }
    }

    public void setBorderWidth(String string) {
        this.jsData.addDataset("borderWidth", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setBackgroundColor(String string) {
        this.backgroundColor = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setPointStyle(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.checkPara(string2, SET_PSTYLE, "pointStyle");
        this.jsData.addDataset("pointStyle", string2, false);
    }

    public void setPointRadius(String string) {
        this.jsData.addDataset("pointRadius", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setShowLine(String string) {
        this.jsData.addDataset("showLine", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setSpanGaps(String string) {
        this.jsData.addDataset("spanGaps", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setPointBGColor(String string) {
        this.jsData.addDataset("pointBackgroundColor", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setUseAxis(String string) {
        this.jsData.setUseAxis(StringUtil.nval((String)this.getRequestParameter(string), (boolean)false));
    }

    public void setId(String string) {
        this.yAxisID = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setPosition(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.checkPara(string2, SET_POSITION, "position");
        this.jsData.addAxis("position", string2, false);
    }

    public void setScaleType(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        try {
            this.checkPara(string2, SET_SCALE, "type");
        }
        catch (HybsSystemException hybsSystemException) {
            System.err.println(hybsSystemException.getMessage());
        }
        this.jsData.addAxis("type", string2, false);
    }

    public void setYlabel(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            String string3 = "{display: true,labelString:'" + string2 + "'}";
            this.jsData.addAxis("scaleLabel", string3, true);
        }
    }

    public void setBeginAtZero(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.checkPara(string2, SET_BOOLEAN, "beginAtZero");
        this.jsData.addTicks("beginAtZero", string2, true);
    }

    public void setFontColor(String string) {
        this.jsData.addTicks("fontColor", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setScaleCallback(String string) {
        this.jsData.addTicks("callback", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setMax(String string) {
        this.jsData.addTicks("max", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setMin(String string) {
        this.jsData.addTicks("min", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setStepSize(String string) {
        this.jsData.addTicks("stepSize", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setTicks(String string) {
        this.jsData.addAxis("ticks", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setGridColor(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            String string3 = "{color:'" + string2 + "'}";
            this.jsData.addAxis("gridLines", string3, true);
        }
    }

    public void setGridLines(String string) {
        this.jsData.addAxis("gridLines", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setCategoryList(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            Pattern pattern = Pattern.compile(" *, *");
            Matcher matcher = pattern.matcher(string2);
            String string3 = "['" + matcher.replaceAll("','") + "']";
            this.jsData.addAxis("labels", string3, true);
        }
    }

    public void setOptDataset(String string) {
        this.jsData.addOptions("dataset", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptAxis(String string) {
        this.jsData.addOptions("axis", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptTicks(String string) {
        this.jsData.addOptions("ticks", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptScaleLabel(String string) {
        this.jsData.addOptions("scaleLabel", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptGridLines(String string) {
        this.jsData.addOptions("gridLines", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSIION", (Object)VERSION).println("JsChartData", (Object)this.jsData).fixForm().toString();
    }
}

