/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.io.JsChartData;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class JsChartTag
extends CommonTagSupport {
    private static final String VERSION = "7.0.1.2 (2018/11/04)";
    private static final long serialVersionUID = 701220181104L;
    private static final String STREAMING_JS = "common/option/chartjs-plugin-streaming.min.js";
    private static final String SCRIPT_STREAMING_JS = "<script type=\"text/javascript\" src=\"/" + HybsSystem.getContextName() + "/jsp/common/option/chartjs-plugin-streaming.min.js?v=20181105123712\" ><!-- --></script>" + CR;
    public static final String CTYPE_LINE = "line";
    public static final String CTYPE_BAR = "bar";
    public static final String CTYPE_HBAR = "horizontalBar";
    public static final String CTYPE_RADAR = "radar";
    public static final String CTYPE_POLAR = "polarArea";
    public static final String CTYPE_PIE = "pie";
    public static final String CTYPE_DOUGHNUT = "doughnut";
    private static final Set<String> CTYPE_SET = new ArraySet((Object[])new String[]{"line", "bar", "horizontalBar", "radar", "polarArea", "pie", "doughnut"});
    private static final Set<String> SET_CI_TYPE = new ArraySet((Object[])new String[]{"radar", "polarArea", "pie", "doughnut"});
    private static final String TYPE_CATEGORY = "category";
    private static final String TYPE_LINEAR = "linear";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_REALTIME = "realtime";
    private static final Set<String> SET_POSITION = new ArraySet((Object[])new String[]{"top", "right", "bottom", "left"});
    private static final Set<String> SET_TIMEUNIT = new ArraySet((Object[])new String[]{"year", "quarter", "month", "week", "day", "hour", "minute", "second"});
    private static final Set<String> SET_XSCALE = new ArraySet((Object[])new String[]{"category", "time", "linear", "realtime"});
    private static final Set<String> SET_BOOLEAN = new ArraySet((Object[])new String[]{"true", "false"});
    private static final String CANVAS_NAME = "hybscanvas";
    private static final String MARK_DEF_COLOR = "BLUE";
    private static final String MARK_DEF_ADJUST = "-6";
    private final transient List<JsChartData> jsChartData = new ArrayList<JsChartData>();
    private JsChartData jsXAxis = new JsChartData();
    private String chartBody;
    private String chartType;
    private String labelColumn;
    private String id;
    private String height = "400";
    private String width = "400";
    private String title;
    private String titlePosition;
    private String legendPosition;
    private String legendDisplay;
    private boolean usePointStyle;
    private boolean useLegend;
    private String barWidthPer = "0.8";
    private String onClick;
    private String plugins;
    private String xscaleType = "category";
    private String xposition;
    private boolean valueQuot;
    private String tableId = "h_tblmdl";
    private String markValues;
    private String markColors;
    private String markLbls;
    private String markAdjust;
    private String xmarkValues;
    private String xmarkColors;
    private String markWidth = "2";
    private String markDash;
    private String markFontSize = "10";
    private boolean useZoom;
    private String varColumns;
    private boolean useZeroDataOmit;
    private boolean useRenderer;
    private String sortColumn;
    private String optChart;
    private String optOptions;

    @Override
    protected void release2() {
        super.release2();
        this.jsChartData.clear();
        this.jsXAxis = new JsChartData();
        this.chartBody = null;
        this.chartType = null;
        this.id = null;
        this.height = "400";
        this.width = "400";
        this.labelColumn = null;
        this.title = null;
        this.titlePosition = null;
        this.legendPosition = null;
        this.legendDisplay = null;
        this.usePointStyle = false;
        this.useLegend = false;
        this.barWidthPer = "0.8";
        this.onClick = null;
        this.plugins = null;
        this.xscaleType = TYPE_CATEGORY;
        this.xposition = null;
        this.valueQuot = false;
        this.tableId = "h_tblmdl";
        this.markValues = null;
        this.markColors = null;
        this.markLbls = null;
        this.markAdjust = null;
        this.xmarkValues = null;
        this.xmarkColors = null;
        this.markWidth = "2";
        this.markDash = null;
        this.markFontSize = "10";
        this.useZoom = false;
        this.varColumns = null;
        this.useZeroDataOmit = false;
        this.useRenderer = false;
        this.sortColumn = null;
        this.optChart = null;
        this.optOptions = null;
    }

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.chartBody = this.getBodyString();
        if (this.chartBody != null) {
            this.chartBody = this.chartBody.trim();
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        this.id = this.id == null ? this.tableId : this.id;
        this.jspPrint(this.jsChartOutput());
        return 6;
    }

    private String jsChartOutput() {
        char[] cArray;
        int n;
        String string;
        int n2;
        String string2;
        int n3;
        int n4;
        Object object;
        Object object2;
        Object object3;
        int n5;
        StringBuilder stringBuilder = new StringBuilder(200);
        String string3 = "cd_" + this.id;
        String string4 = "chart_" + this.id;
        Object object4 = (DBTableModel)this.getObject(this.tableId);
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{this.sortColumn})) {
            n5 = object4.getColumnNo(this.sortColumn, false);
            object3 = new DBTableModelSorter();
            ((DBTableModelSorter)object3).setModel((DBTableModel)this.getObject(this.tableId));
            ((DBTableModelSorter)object3).sortByColumn(n5, true);
            object4 = object3;
        }
        n5 = object4.getRowCount();
        if (this.useZeroDataOmit) {
            object3 = this.jsChartData.iterator();
            while (object3.hasNext()) {
                object2 = (JsChartData)object3.next();
                object = ((JsChartData)object2).getChartColumn();
                n4 = object4.getColumnNo((String)object, false);
                boolean bl = true;
                if (n4 >= 0) {
                    for (n3 = 0; n3 < n5; ++n3) {
                        string2 = (String)object4.getValue(n3, n4);
                        if (!StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2}) || "0".equals(string2) || "0.0".equals(string2) || "0.00".equals(string2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                object3.remove();
            }
        }
        int n6 = this.jsChartData.size();
        object2 = new String[n6];
        object = new int[n6];
        n4 = object4.getColumnNo(this.labelColumn, false);
        DBColumn dBColumn = object4.getDBColumn(n4);
        for (n3 = 0; n3 < n6; ++n3) {
            string2 = this.jsChartData.get(n3).getChartColumn();
            object2[n3] = string2;
            object[n3] = object4.getColumnNo(string2, false);
        }
        if (TYPE_REALTIME.equals(this.xscaleType)) {
            stringBuilder.append(SCRIPT_STREAMING_JS);
        }
        stringBuilder.append("<canvas class=\"").append(CANVAS_NAME).append("\" id=\"").append(this.id).append("\" width=\"").append(this.width).append("\" height=\"").append(this.height).append("\"><!-- --></canvas>").append(CR).append("<script>").append(CR).append(this.chartBody);
        n3 = TYPE_CATEGORY.equals(this.xscaleType) ? 1 : 0;
        boolean bl = TYPE_LINEAR.equals(this.xscaleType);
        boolean bl2 = TYPE_TIME.equals(this.xscaleType);
        stringBuilder.append(" var ").append(this.labelColumn).append("=[");
        for (n2 = 0; n2 < n5; ++n2) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            String string5 = (String)object4.getValue(n2, n4);
            String string6 = string = this.useRenderer && !bl ? StringUtil.jsonFilter((String)dBColumn.getRendererValue(n2, string5)) : string5;
            if (n3 != 0 || bl2 || this.useRenderer) {
                stringBuilder.append('\"').append(string).append('\"');
                continue;
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("];").append(CR);
        for (n2 = 0; n2 < n6; ++n2) {
            stringBuilder.append(" var ").append((String)object2[n2]).append("=[");
            for (int i = 0; i < n5; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                string = (String)object4.getValue(i, object[n2]);
                if (this.valueQuot) {
                    stringBuilder.append('\"').append(string).append('\"');
                    continue;
                }
                stringBuilder.append(string);
            }
            stringBuilder.append("];").append(CR);
        }
        if (bl) {
            for (n2 = 0; n2 < n6; ++n2) {
                Object object5 = object2[n2];
                stringBuilder.append("var LI_").append((String)object5).append("=[];").append(CR);
                this.jsChartData.get(n2).setChartColumn("LI_" + (String)object5);
            }
            stringBuilder.append("for(var i=0; i<").append(this.labelColumn).append(".length; i++){");
            for (n2 = 0; n2 < n6; ++n2) {
                Object object6 = object2[n2];
                stringBuilder.append("LI_").append((String)object6).append("[i]={x:").append(this.labelColumn).append("[i],y:").append((String)object6).append("[i]};");
            }
            stringBuilder.append("};").append(CR);
        }
        String[] stringArray = StringUtil.csv2Array((String)this.varColumns);
        for (int i = 0; i < stringArray.length; ++i) {
            int n7 = object4.getColumnNo(stringArray[i], false);
            boolean bl3 = object4.getDBColumn(n7).isNumberType();
            stringBuilder.append(" var ").append(stringArray[i]).append("=[");
            for (n = 0; n < n5; ++n) {
                if (n > 0) {
                    stringBuilder.append(',');
                }
                String string7 = (String)object4.getValue(n, n7);
                if (bl3) {
                    stringBuilder.append(string7);
                    continue;
                }
                stringBuilder.append('\"').append(string7).append('\"');
            }
            stringBuilder.append("];").append(CR);
        }
        if (!SET_CI_TYPE.contains(this.chartType)) {
            this.jsXAxis.setId("x0");
            this.jsXAxis.setUseTime(bl2);
            if (CTYPE_BAR.equals(this.chartType) || CTYPE_HBAR.equals(this.chartType)) {
                this.jsXAxis.addAxis("categoryPercentage", this.barWidthPer, true);
            }
            String string8 = this.xposition != null ? this.xposition : (bl ? "bottom" : (CTYPE_HBAR.equals(this.chartType) ? "left" : null));
            this.jsXAxis.addAxis("position", string8, false);
            stringBuilder.append(this.jsXAxis.getAxis()).append(CR);
        }
        if (CTYPE_HBAR.equals(this.chartType)) {
            char[] cArray2 = new char[2];
            cArray2[0] = 120;
            cArray = cArray2;
            cArray2[1] = 121;
        } else {
            char[] cArray3 = new char[2];
            cArray3[0] = 121;
            cArray = cArray3;
            cArray3[1] = 120;
        }
        char[] cArray4 = cArray;
        for (JsChartData jsChartData : this.jsChartData) {
            stringBuilder.append(jsChartData.getDataset(cArray4[0])).append(CR).append(jsChartData.getAxis()).append(CR);
        }
        stringBuilder.append("var ").append(string3).append("={labels:").append(this.labelColumn).append(",datasets:[");
        for (JsChartData jsChartData : this.jsChartData) {
            stringBuilder.append(jsChartData.getDatasetKey()).append(',');
        }
        stringBuilder.append("]};").append(CR).append("var ").append(string4).append("=new Chart(").append(this.id).append(",{type:'").append(this.chartType).append("',data:").append(string3);
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{this.plugins})) {
            stringBuilder.append(",plugins: [").append(this.plugins).append(']');
        }
        stringBuilder.append(",options:{responsive:false");
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{this.onClick})) {
            stringBuilder.append(",onClick:function(event,obj){").append(this.onClick).append('}');
        }
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{this.title})) {
            stringBuilder.append(",title:{display:true");
            this.setProp(stringBuilder, ",text:'", this.title, "'");
            this.setProp(stringBuilder, ",position:'", this.titlePosition, "'");
            stringBuilder.append('}');
        }
        if (this.useLegend) {
            stringBuilder.append(",legend:{");
            this.setProp(stringBuilder, "display:", this.legendDisplay, ",");
            this.setProp(stringBuilder, "position:'", this.legendPosition, "',");
            if (this.usePointStyle) {
                stringBuilder.append("labels:{usePointStyle: true}");
            }
            stringBuilder.append('}');
        }
        if (!SET_CI_TYPE.contains(this.chartType)) {
            stringBuilder.append(",scales:{").append(cArray4[0]).append("Axes:[");
            for (JsChartData jsChartData : this.jsChartData) {
                if (!jsChartData.isUseAxis()) continue;
                stringBuilder.append(jsChartData.getAxisKey()).append(',');
            }
            stringBuilder.append("],").append(cArray4[1]).append("Axes:[");
            stringBuilder.append(this.jsXAxis.getAxisKey()).append("]}");
            String[] stringArray2 = StringUtil.csv2Array((String)this.markValues);
            String[] stringArray3 = StringUtil.csv2Array((String)this.xmarkValues);
            n = stringArray2.length;
            int n8 = stringArray3.length;
            if (n > 0 || n8 > 0) {
                String[] stringArray4;
                stringBuilder.append(",annotation:{annotations:[");
                if (n > 0) {
                    stringArray4 = StringUtil.csv2Array((String)this.markColors, (char)',', (int)n, (String)MARK_DEF_COLOR);
                    String[] stringArray5 = StringUtil.csv2Array((String)this.markLbls, (char)',', (int)n);
                    String[] stringArray6 = StringUtil.csv2Array((String)this.markAdjust, (char)',', (int)n, (String)MARK_DEF_ADJUST);
                    for (int i = 0; i < n; ++i) {
                        stringBuilder.append("{type:'line',scaleID:'y0Ax',mode:'horizontal'");
                        this.setProp(stringBuilder, ",borderWidth:", this.markWidth);
                        this.setProp(stringBuilder, ",borderDash:", this.markDash);
                        this.setProp(stringBuilder, ",value:", stringArray2[i]);
                        this.setProp(stringBuilder, ",borderColor:'", stringArray4[i], "'");
                        if (!stringArray5[i].isEmpty()) {
                            stringBuilder.append(",label:{enabled:'true',position:'left',backgroundColor:'rgba(0,0,0,0)'");
                            this.setProp(stringBuilder, ",yAdjust:", stringArray6[i]);
                            this.setProp(stringBuilder, ",content:'", stringArray5[i], "'");
                            this.setProp(stringBuilder, ",fontColor:'", stringArray4[i], "'");
                            this.setProp(stringBuilder, ",fontSize:", this.markFontSize);
                            stringBuilder.append('}');
                        }
                        stringBuilder.append("},");
                    }
                }
                if (n8 > 0) {
                    stringArray4 = StringUtil.csv2Array((String)this.xmarkColors, (char)',', (int)n8, (String)MARK_DEF_COLOR);
                    for (int i = 0; i < n8; ++i) {
                        stringBuilder.append("{type:'line',scaleID:'x0Ax',mode:'vertical'");
                        this.setProp(stringBuilder, ",borderWidth:", this.markWidth);
                        this.setProp(stringBuilder, ",borderDash:", this.markDash);
                        this.setProp(stringBuilder, ",value:'", stringArray3[i], "'");
                        this.setProp(stringBuilder, ",borderColor:'", stringArray4[i], "'");
                        stringBuilder.append("},");
                    }
                }
                stringBuilder.append("]}");
            }
            if (this.useZoom) {
                stringBuilder.append(",pan:{enabled:true,mode:'xy'},zoom:{enabled:true,drag:false,mode:'xy'}");
            }
        }
        this.setProp(stringBuilder, ",", this.optOptions);
        stringBuilder.append("}");
        this.setProp(stringBuilder, ",", this.optChart);
        stringBuilder.append("});").append(CR);
        if (this.useZoom) {
            stringBuilder.append("window.onload=function(){$('#").append(this.id).append("').dblclick(function(){window.").append(string4).append(".resetZoom();});}");
        }
        stringBuilder.append(CR).append("</script>");
        return stringBuilder.toString();
    }

    private void setProp(StringBuilder stringBuilder, String string, String string2) {
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            stringBuilder.append(string).append(string2);
        }
    }

    private void setProp(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            stringBuilder.append(string).append(string2).append(string3);
        }
    }

    private void checkPara(String string, Set<String> set, String string2) {
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string}) && !this.check(string, set)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e").append(string2).append("\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append(string2).append("=[").append(string).append(']').append(CR).append(set);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setChartType(String string) {
        this.chartType = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (!this.check(this.chartType, CTYPE_SET)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e\u30c1\u30e3\u30fc\u30c8\u30bf\u30a4\u30d7\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append("chartType=[").append(this.chartType).append(']').append(CR).append(CTYPE_SET);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setId(String string) {
        this.id = StringUtil.nval((String)this.getRequestParameter(string), (String)this.id);
    }

    public void setHeight(String string) {
        this.height = StringUtil.nval((String)this.getRequestParameter(string), (String)this.height);
    }

    public void setWidth(String string) {
        this.width = StringUtil.nval((String)this.getRequestParameter(string), (String)this.width);
    }

    public void setLabelColumn(String string) {
        this.labelColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.labelColumn);
    }

    public void setTitle(String string) {
        this.title = StringUtil.nval((String)this.getRequestParameter(string), (String)this.title);
    }

    public void setTitlePosition(String string) {
        this.titlePosition = StringUtil.nval((String)this.getRequestParameter(string), (String)this.titlePosition);
        this.checkPara(this.titlePosition, SET_POSITION, "titlePosition");
    }

    public void setXlabel(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            String string3 = "{display: true,labelString:'" + string2 + "'}";
            this.jsXAxis.addAxis("scaleLabel", string3, true);
        }
    }

    public void setValueQuot(String string) {
        this.valueQuot = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.valueQuot);
    }

    public void setLegendPosition(String string) {
        this.legendPosition = StringUtil.nval((String)this.getRequestParameter(string), (String)this.legendPosition);
        if (this.legendPosition != null) {
            this.checkPara(this.legendPosition, SET_POSITION, "legendPosition");
            this.useLegend = true;
        }
    }

    public void setLegendDisplay(String string) {
        this.legendDisplay = StringUtil.nval((String)this.getRequestParameter(string), (String)this.legendDisplay);
        if (this.legendDisplay != null) {
            this.checkPara(this.legendDisplay, SET_BOOLEAN, "legendDisplay");
            this.useLegend = true;
        }
    }

    public void setUsePointStyle(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.usePointStyle = Boolean.parseBoolean(string2);
            this.useLegend = true;
        }
    }

    public void setXscaleCallback(String string) {
        this.jsXAxis.addTicks("callback", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setXposition(String string) {
        this.xposition = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.checkPara(this.xposition, SET_POSITION, "position");
    }

    public void setXscaleType(String string) {
        this.xscaleType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.xscaleType);
        try {
            this.checkPara(this.xscaleType, SET_XSCALE, "xscaleType");
        }
        catch (HybsSystemException hybsSystemException) {
            System.err.println(hybsSystemException.getMessage());
        }
        this.jsXAxis.addAxis("type", this.xscaleType, false);
    }

    public void setXbeginAtZero(String string) {
        this.jsXAxis.addTicks("beginAtZero", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setXmax(String string) {
        this.jsXAxis.addTicks("max", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setXmin(String string) {
        this.jsXAxis.addTicks("min", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setXstepSize(String string) {
        this.jsXAxis.addTicks("stepSize", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setBarWidthPer(String string) {
        this.barWidthPer = StringUtil.nval((String)this.getRequestParameter(string), (String)this.barWidthPer);
    }

    protected void addJsChartData(JsChartData jsChartData) {
        this.jsChartData.add(jsChartData);
    }

    protected int getJsChartDataSize() {
        return this.jsChartData.size();
    }

    protected boolean isOneColor() {
        return CTYPE_LINE.equalsIgnoreCase(this.chartType) || CTYPE_RADAR.equalsIgnoreCase(this.chartType);
    }

    public void setTimeSetFormat(String string) {
        this.jsXAxis.addTime("format", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setTimeLblFormat(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            StringBuilder stringBuilder = new StringBuilder(200).append("{year:'").append(string2).append("',quarter:'").append(string2).append("',month:'").append(string2).append("',week:'").append(string2).append("',day:'").append(string2).append("',hour:'").append(string2).append("',minute:'").append(string2).append("',second:'").append(string2).append("'}");
            this.jsXAxis.addTime("displayFormats", stringBuilder.toString(), true);
        }
    }

    public void setTimeMax(String string) {
        this.jsXAxis.addTime("max", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setTimeMin(String string) {
        this.jsXAxis.addTime("min", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setTimeUnit(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.checkPara(string2, SET_TIMEUNIT, "timeUnit");
        this.jsXAxis.addTime("unit", string2, false);
    }

    public void setTimeUnitStepSize(String string) {
        this.jsXAxis.addTime("unitStepSize", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setTooltipFormat(String string) {
        this.jsXAxis.addTime("tooltipFormat", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setOnClick(String string) {
        this.onClick = StringUtil.nval((String)this.getRequestParameter(string), (String)this.onClick);
    }

    public void setPlugins(String string) {
        this.plugins = StringUtil.nval((String)this.getRequestParameter(string), (String)this.plugins);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setMarkValues(String string) {
        this.markValues = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markValues);
    }

    public void setMarkColors(String string) {
        this.markColors = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markColors);
    }

    public void setMarkLbls(String string) {
        this.markLbls = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markLbls);
    }

    public void setMarkAdjust(String string) {
        this.markAdjust = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markAdjust);
    }

    public void setXmarkValues(String string) {
        this.xmarkValues = StringUtil.nval((String)this.getRequestParameter(string), (String)this.xmarkValues);
    }

    public void setXmarkColors(String string) {
        this.xmarkColors = StringUtil.nval((String)this.getRequestParameter(string), (String)this.xmarkColors);
    }

    public void setMarkWidth(String string) {
        this.markWidth = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markWidth);
    }

    public void setMarkDash(String string) {
        this.markDash = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markDash);
    }

    public void setMarkFontSize(String string) {
        this.markFontSize = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markFontSize);
    }

    public void setUseZoom(String string) {
        this.useZoom = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useZoom);
    }

    public void setVarColumns(String string) {
        this.varColumns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.varColumns);
    }

    public void setUseZeroDataOmit(String string) {
        this.useZeroDataOmit = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useZeroDataOmit);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setSortColumn(String string) {
        this.sortColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sortColumn);
    }

    public void setOptOptions(String string) {
        this.optOptions = StringUtil.nval((String)this.getRequestParameter(string), (String)this.optOptions);
    }

    public void setOptChart(String string) {
        this.optChart = StringUtil.nval((String)this.getRequestParameter(string), (String)this.optChart);
    }

    public void setOptAxis(String string) {
        this.jsXAxis.addOptions("axis", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptTicks(String string) {
        this.jsXAxis.addOptions("ticks", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptScaleLabel(String string) {
        this.jsXAxis.addOptions("scaleLabel", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptGridLines(String string) {
        this.jsXAxis.addOptions("gridLines", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("X_AXIS=").append(this.jsXAxis).append(CR);
        this.jsChartData.forEach(jsChartData -> stringBuilder.append("Y_AXIS=").append(this.jsXAxis).append(CR));
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("id", (Object)this.id).println("tableId", (Object)this.tableId).println("chartType", (Object)this.chartType).println("width", (Object)this.width).println("height", (Object)this.height).println("barWidthPer", (Object)this.barWidthPer).println("title", (Object)this.title).println("titlePosition", (Object)this.titlePosition).println("legendPosition", (Object)this.legendPosition).println("legendDisplay", (Object)this.legendDisplay).println("xscaleType", (Object)this.xscaleType).println("optOptions", (Object)this.optOptions).println("optChart", (Object)this.optChart).fixForm().println().println((Object)stringBuilder).toString();
    }
}

