/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.draw;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.odfdom.type.AnyURI;
import org.odftoolkit.odfdom.type.Length;

public class OdfDrawImage
extends DrawImageElement {
    private URI mImageURI;
    private OdfPackage mOdfPackage;
    private static final String SLASH = "/";

    public OdfDrawImage(OdfFileDom ownerDoc) {
        super(ownerDoc);
        this.mOdfPackage = ownerDoc.getOdfDocument().getPackage();
    }

    public URI getImageUri() {
        try {
            if (this.mImageURI == null) {
                this.mImageURI = new URI(AnyURI.encodePath(this.getXlinkHrefAttribute().toString()));
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(OdfDrawImage.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.mImageURI;
    }

    public void setImagePath(String packagePath) {
        try {
            packagePath = packagePath.replaceFirst(this.mOdfDocument.getDocumentPackagePath(), "");
            URI uri = new URI(AnyURI.encodePath(packagePath).toString());
            this.setXlinkHrefAttribute(AnyURI.decodePath(uri.toString()));
            this.mImageURI = uri;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(OdfDrawImage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String insertImage(URI imageUri) throws Exception {
        URL url = null;
        String imageRef = null;
        if (!imageUri.isAbsolute()) {
            imageRef = System.getProperty("user.dir") + '/' + imageUri.toString();
            url = new URL(new File(imageRef).getCanonicalFile().toURI().toString());
        } else {
            url = imageUri.toURL();
            imageRef = imageUri.toString();
        }
        String mediaType = OdfFileEntry.getMediaType(imageRef);
        OdfDrawFrame odfFrame = (OdfDrawFrame)((Object)this.getParentNode());
        if (odfFrame != null) {
            InputStream is = url.openConnection().getInputStream();
            BufferedImage image = ImageIO.read(is);
            int height = image.getHeight(null);
            int width = image.getWidth(null);
            odfFrame.setSvgHeightAttribute(Length.mapToUnit(String.valueOf(height) + "px", Length.Unit.CENTIMETER));
            odfFrame.setSvgWidthAttribute(Length.mapToUnit(String.valueOf(width) + "px", Length.Unit.CENTIMETER));
        }
        String packagePath = this.getPackagePath(imageRef);
        this.setImagePath(packagePath);
        this.mOdfPackage.insert(imageUri, packagePath, mediaType);
        return packagePath;
    }

    private String getPackagePath(String imageRef) {
        if (imageRef.contains(SLASH)) {
            imageRef = imageRef.substring(imageRef.lastIndexOf(SLASH) + 1, imageRef.length());
        }
        String packagePath = OdfPackage.OdfFile.IMAGE_DIRECTORY.getPath() + SLASH + imageRef;
        packagePath = this.mOdfDocument.getDocumentPackagePath() + packagePath;
        return packagePath;
    }

    public void insertImage(InputStream is, String packagePath, String mediaType) throws Exception {
        this.setImagePath(packagePath);
        this.mOdfPackage.insert(is, packagePath, mediaType);
    }
}

