/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.text;

import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.text.OdfTextLineBreak;
import org.odftoolkit.odfdom.doc.text.OdfTextSpace;
import org.odftoolkit.odfdom.doc.text.OdfTextTab;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OdfWhitespaceProcessor {
    private int nSpaces;
    private String partial;
    private OdfFileDom owner;
    private Element element;

    public void append(Element element, String content) {
        int i = 0;
        this.element = element;
        this.partial = "";
        this.nSpaces = 0;
        this.owner = (OdfFileDom)((Object)element.getOwnerDocument());
        for (i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (ch == ' ') {
                if (this.nSpaces == 0) {
                    this.partial = this.partial + " ";
                }
                ++this.nSpaces;
                continue;
            }
            if (ch == '\n') {
                this.emitPartial();
                element.appendChild((Node)((Object)new OdfTextLineBreak(this.owner)));
                continue;
            }
            if (ch == '\t') {
                this.emitPartial();
                element.appendChild((Node)((Object)new OdfTextTab(this.owner)));
                continue;
            }
            if (ch == '\r') continue;
            if (this.nSpaces > 1) {
                this.emitPartial();
            }
            this.partial = this.partial + ch;
            this.nSpaces = 0;
        }
        this.emitPartial();
    }

    private void emitPartial() {
        if (!this.partial.equals("")) {
            this.element.appendChild(this.owner.createTextNode(this.partial));
        }
        if (this.nSpaces > 1) {
            OdfTextSpace spaceElement = new OdfTextSpace(this.owner);
            spaceElement.setTextCAttribute(new Integer(this.nSpaces - 1));
            this.element.appendChild((Node)((Object)spaceElement));
        }
        this.nSpaces = 0;
        this.partial = "";
    }

    public String getText(Node element) {
        String result = "";
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 3) {
                result = result + node.getNodeValue();
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                int spaceCount;
                try {
                    spaceCount = Integer.parseInt(((Element)node).getAttributeNS(OdfNamespaceNames.TEXT.getNamespaceUri(), "c"));
                }
                catch (Exception e) {
                    spaceCount = 1;
                }
                for (int i = 0; i < spaceCount; ++i) {
                    result = result + " ";
                }
                continue;
            }
            result = node.getLocalName().equals("line-break") ? result + "\n" : (node.getLocalName().equals("tab") ? result + "\t" : result + this.getText(node));
        }
        return result;
    }

    public static void appendText(Element element, String content) {
        OdfWhitespaceProcessor processor = new OdfWhitespaceProcessor();
        processor.append(element, content);
    }
}

