/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfWindowing {

    public static class WmfCreateRegion
    implements HwmfRecord,
    HwmfObjectTableEntry {
        private int nextInChain;
        private int objectType;
        private int objectCount;
        private int regionSize;
        private int scanCount;
        private int maxScan;
        private int bottom;
        private int right;
        private int top;
        private int left;
        private WmfScanObject[] scanObjects;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.createRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.nextInChain = leis.readShort();
            this.objectType = leis.readShort();
            this.objectCount = leis.readInt();
            this.regionSize = leis.readShort();
            this.scanCount = leis.readShort();
            this.maxScan = leis.readShort();
            this.left = leis.readShort();
            this.top = leis.readShort();
            this.right = leis.readShort();
            this.bottom = leis.readShort();
            int size = 22;
            this.scanObjects = new WmfScanObject[this.scanCount];
            for (int i = 0; i < this.scanCount; ++i) {
                this.scanObjects[i] = new WmfScanObject();
                size += this.scanObjects[i].init(leis);
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
            Shape lastRect = null;
            Area scanLines = new Area();
            int count = 0;
            for (WmfScanObject so : this.scanObjects) {
                int y = Math.min(so.top, so.bottom);
                int h = Math.abs(so.top - so.bottom - 1);
                for (int i = 0; i < so.count / 2; ++i) {
                    int x = Math.min(so.left_scanline[i], so.right_scanline[i]);
                    int w = Math.abs(so.right_scanline[i] - so.left_scanline[i] - 1);
                    lastRect = new Rectangle2D.Double(x, y, w, h);
                    scanLines.add(new Area(lastRect));
                    ++count;
                }
            }
            Area region = null;
            if (count > 0) {
                region = count == 1 ? lastRect : scanLines;
            }
            ctx.getProperties().setRegion(region);
        }
    }

    public static class WmfScanObject {
        private int count;
        private int top;
        private int bottom;
        private int[] left_scanline;
        private int[] right_scanline;
        private int count2;

        public int init(LittleEndianInputStream leis) {
            this.count = leis.readUShort();
            this.top = leis.readUShort();
            this.bottom = leis.readUShort();
            int size = 6;
            this.left_scanline = new int[this.count / 2];
            this.right_scanline = new int[this.count / 2];
            for (int i = 0; i < this.count / 2; ++i) {
                this.left_scanline[i] = leis.readUShort();
                this.right_scanline[i] = leis.readUShort();
                size += 4;
            }
            this.count2 = leis.readUShort();
            return size += 2;
        }
    }

    public static class WmfSelectClipRegion
    implements HwmfRecord {
        private int region;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.selectClipRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.region = leis.readShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfIntersectClipRect
    implements HwmfRecord,
    HwmfObjectTableEntry {
        private int bottom;
        private int right;
        private int top;
        private int left;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.intersectClipRect;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.bottom = leis.readShort();
            this.right = leis.readShort();
            this.top = leis.readShort();
            this.left = leis.readShort();
            return 8;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }
    }

    public static class WmfExcludeClipRect
    implements HwmfRecord,
    HwmfObjectTableEntry {
        private int bottom;
        private int right;
        private int top;
        private int left;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.excludeClipRect;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.bottom = leis.readShort();
            this.right = leis.readShort();
            this.top = leis.readShort();
            this.left = leis.readShort();
            return 8;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }
    }

    public static class WmfOffsetClipRgn
    implements HwmfRecord,
    HwmfObjectTableEntry {
        private int yOffset;
        private int xOffset;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.offsetClipRgn;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.yOffset = leis.readShort();
            this.xOffset = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }
    }

    public static class WmfScaleViewportExt
    implements HwmfRecord {
        private int yDenom;
        private int yNum;
        private int xDenom;
        private int xNum;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.scaleViewportExt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.yDenom = leis.readShort();
            this.yNum = leis.readShort();
            this.xDenom = leis.readShort();
            this.xNum = leis.readShort();
            return 8;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Rectangle2D viewport = ctx.getProperties().getViewport();
            if (viewport == null) {
                viewport = ctx.getProperties().getWindow();
            }
            double width = viewport.getWidth() * (double)this.xNum / (double)this.xDenom;
            double height = viewport.getHeight() * (double)this.yNum / (double)this.yDenom;
            ctx.getProperties().setViewportExt(width, height);
        }
    }

    public static class WmfScaleWindowExt
    implements HwmfRecord {
        private int yDenom;
        private int yNum;
        private int xDenom;
        private int xNum;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.scaleWindowExt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.yDenom = leis.readShort();
            this.yNum = leis.readShort();
            this.xDenom = leis.readShort();
            this.xNum = leis.readShort();
            return 8;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Rectangle2D window = ctx.getProperties().getWindow();
            double width = window.getWidth() * (double)this.xNum / (double)this.xDenom;
            double height = window.getHeight() * (double)this.yNum / (double)this.yDenom;
            ctx.getProperties().setWindowExt(width, height);
            ctx.updateWindowMapMode();
        }
    }

    public static class WmfOffsetWindowOrg
    implements HwmfRecord {
        private int yOffset;
        private int xOffset;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.offsetWindowOrg;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.yOffset = leis.readShort();
            this.xOffset = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Rectangle2D window = ctx.getProperties().getWindow();
            ctx.getProperties().setWindowOrg(window.getX() + (double)this.xOffset, window.getY() + (double)this.yOffset);
            ctx.updateWindowMapMode();
        }
    }

    public static class WmfSetWindowExt
    implements HwmfRecord {
        private int height;
        private int width;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setWindowExt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.height = leis.readShort();
            this.width = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setWindowExt(this.width, this.height);
            ctx.updateWindowMapMode();
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static class WmfSetWindowOrg
    implements HwmfRecord {
        private int y;
        private int x;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setWindowOrg;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.y = leis.readShort();
            this.x = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setWindowOrg(this.x, this.y);
            ctx.updateWindowMapMode();
        }

        public int getY() {
            return this.y;
        }

        public int getX() {
            return this.x;
        }
    }

    public static class WmfOffsetViewportOrg
    implements HwmfRecord {
        private int yOffset;
        private int xOffset;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.offsetViewportOrg;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.yOffset = leis.readShort();
            this.xOffset = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Rectangle2D viewport = ctx.getProperties().getViewport();
            double x = viewport == null ? 0.0 : viewport.getX();
            double y = viewport == null ? 0.0 : viewport.getY();
            ctx.getProperties().setViewportOrg(x + (double)this.xOffset, y + (double)this.yOffset);
        }
    }

    public static class WmfSetViewportExt
    implements HwmfRecord {
        private int height;
        private int width;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setViewportExt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.height = leis.readShort();
            this.width = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setViewportExt(this.width, this.height);
        }
    }

    public static class WmfSetViewportOrg
    implements HwmfRecord {
        private int y;
        private int x;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setViewportOrg;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.y = leis.readShort();
            this.x = leis.readShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setViewportOrg(this.x, this.y);
        }
    }
}

