/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Color;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFShapePlaceholderDetails;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.draw.geom.CustomGeometry;
import org.apache.poi.sl.draw.geom.Guide;
import org.apache.poi.sl.draw.geom.PresetGeometries;
import org.apache.poi.sl.usermodel.LineDecoration;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.Placeholder;
import org.apache.poi.sl.usermodel.Shadow;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.sl.usermodel.StrokeStyle;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Units;

public abstract class HSLFSimpleShape
extends HSLFShape
implements SimpleShape<HSLFShape, HSLFTextParagraph> {
    private static final POILogger LOG = POILogFactory.getLogger(HSLFSimpleShape.class);
    public static final double DEFAULT_LINE_WIDTH = 0.75;
    protected HSLFHyperlink _hyperlink;

    protected HSLFSimpleShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherChildAnchorRecord anchor;
        EscherContainerRecord ecr = super.createSpContainer(isChild);
        ecr.setRecordId((short)-4092);
        EscherSpRecord sp = new EscherSpRecord();
        int flags = 2560;
        if (isChild) {
            flags |= 2;
        }
        sp.setFlags(flags);
        ecr.addChildRecord((EscherRecord)sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        ecr.addChildRecord((EscherRecord)opt);
        if (isChild) {
            anchor = new EscherChildAnchorRecord();
        } else {
            anchor = new EscherClientAnchorRecord();
            byte[] header = new byte[16];
            LittleEndian.putUShort((byte[])header, (int)0, (int)0);
            LittleEndian.putUShort((byte[])header, (int)2, (int)0);
            LittleEndian.putInt((byte[])header, (int)4, (int)8);
            anchor.fillFields(header, 0, null);
        }
        ecr.addChildRecord((EscherRecord)anchor);
        return ecr;
    }

    public double getLineWidth() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 459);
        return prop == null ? 0.75 : Units.toPoints((long)prop.getPropertyValue());
    }

    public void setLineWidth(double width) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)459, Units.toEMU((double)width));
    }

    public void setLineColor(Color color) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        if (color == null) {
            HSLFSimpleShape.setEscherProperty(opt, (short)511, 524288);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFSimpleShape.setEscherProperty(opt, (short)448, rgb);
            HSLFSimpleShape.setEscherProperty(opt, (short)511, 0x180018);
        }
    }

    public Color getLineColor() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 511);
        if (p != null && (p.getPropertyValue() & 8) == 0) {
            return null;
        }
        Color clr = this.getColor((short)448, (short)449, -1);
        return clr == null ? null : clr;
    }

    public Color getLineBackgroundColor() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 511);
        if (p != null && (p.getPropertyValue() & 8) == 0) {
            return null;
        }
        Color clr = this.getColor((short)450, (short)449, -1);
        return clr == null ? null : clr;
    }

    public void setLineBackgroundColor(Color color) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        if (color == null) {
            HSLFSimpleShape.setEscherProperty(opt, (short)511, 524288);
            opt.removeEscherProperty(450);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFSimpleShape.setEscherProperty(opt, (short)450, rgb);
            HSLFSimpleShape.setEscherProperty(opt, (short)511, 0x180018);
        }
    }

    public StrokeStyle.LineCap getLineCap() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 471);
        return prop == null ? StrokeStyle.LineCap.FLAT : StrokeStyle.LineCap.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineCap(StrokeStyle.LineCap pen) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)471, pen == StrokeStyle.LineCap.FLAT ? -1 : pen.nativeId);
    }

    public StrokeStyle.LineDash getLineDash() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 462);
        return prop == null ? StrokeStyle.LineDash.SOLID : StrokeStyle.LineDash.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineDash(StrokeStyle.LineDash pen) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)462, pen == StrokeStyle.LineDash.SOLID ? -1 : pen.nativeId);
    }

    public StrokeStyle.LineCompound getLineCompound() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 461);
        return prop == null ? StrokeStyle.LineCompound.SINGLE : StrokeStyle.LineCompound.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineCompound(StrokeStyle.LineCompound style) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)461, style == StrokeStyle.LineCompound.SINGLE ? -1 : style.nativeId);
    }

    public StrokeStyle getStrokeStyle() {
        return new StrokeStyle(){

            public PaintStyle getPaint() {
                return DrawPaint.createSolidPaint((Color)HSLFSimpleShape.this.getLineColor());
            }

            public StrokeStyle.LineCap getLineCap() {
                return null;
            }

            public StrokeStyle.LineDash getLineDash() {
                return HSLFSimpleShape.this.getLineDash();
            }

            public StrokeStyle.LineCompound getLineCompound() {
                return HSLFSimpleShape.this.getLineCompound();
            }

            public double getLineWidth() {
                return HSLFSimpleShape.this.getLineWidth();
            }
        };
    }

    public Color getFillColor() {
        return this.getFill().getForegroundColor();
    }

    public void setFillColor(Color color) {
        this.getFill().setForegroundColor(color);
    }

    public Guide getAdjustValue(String name) {
        short escherProp;
        if (name == null || !name.matches("adj([1-9]|10)?")) {
            LOG.log(3, new Object[]{"Adjust value '" + name + "' not supported. Using default value."});
            return null;
        }
        if ((name = name.replace("adj", "")).isEmpty()) {
            name = "1";
        }
        switch (Integer.parseInt(name)) {
            case 1: {
                escherProp = 327;
                break;
            }
            case 2: {
                escherProp = 328;
                break;
            }
            case 3: {
                escherProp = 329;
                break;
            }
            case 4: {
                escherProp = 330;
                break;
            }
            case 5: {
                escherProp = 331;
                break;
            }
            case 6: {
                escherProp = 332;
                break;
            }
            case 7: {
                escherProp = 333;
                break;
            }
            case 8: {
                escherProp = 334;
                break;
            }
            case 9: {
                escherProp = 335;
                break;
            }
            case 10: {
                escherProp = 336;
                break;
            }
            default: {
                throw new HSLFException();
            }
        }
        int adjval = this.getEscherProperty(escherProp, -1);
        return adjval == -1 ? null : new Guide(name, "val " + adjval);
    }

    public CustomGeometry getGeometry() {
        ShapeType st;
        String name;
        PresetGeometries dict = PresetGeometries.getInstance();
        CustomGeometry geom = (CustomGeometry)dict.get((Object)(name = (st = this.getShapeType()) != null ? st.getOoxmlName() : null));
        if (geom == null) {
            if (name == null) {
                name = st != null ? st.toString() : "<unknown>";
            }
            LOG.log(5, new Object[]{"No preset shape definition for shapeType: " + name});
        }
        return geom;
    }

    public double getShadowAngle() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 517);
        int offX = prop == null ? 0 : prop.getPropertyValue();
        prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 518);
        int offY = prop == null ? 0 : prop.getPropertyValue();
        return Math.toDegrees(Math.atan2(offY, offX));
    }

    public double getShadowDistance() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 517);
        int offX = prop == null ? 0 : prop.getPropertyValue();
        prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 518);
        int offY = prop == null ? 0 : prop.getPropertyValue();
        return Units.toPoints((long)((long)Math.hypot(offX, offY)));
    }

    public Color getShadowColor() {
        Color clr = this.getColor((short)513, (short)516, -1);
        return clr == null ? Color.black : clr;
    }

    public Shadow<HSLFShape, HSLFTextParagraph> getShadow() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        if (opt == null) {
            return null;
        }
        EscherProperty shadowType = opt.lookup(512);
        if (shadowType == null) {
            return null;
        }
        return new Shadow<HSLFShape, HSLFTextParagraph>(){

            public SimpleShape<HSLFShape, HSLFTextParagraph> getShadowParent() {
                return HSLFSimpleShape.this;
            }

            public double getDistance() {
                return HSLFSimpleShape.this.getShadowDistance();
            }

            public double getAngle() {
                return HSLFSimpleShape.this.getShadowAngle();
            }

            public double getBlur() {
                return 0.0;
            }

            public PaintStyle.SolidPaint getFillStyle() {
                return DrawPaint.createSolidPaint((Color)HSLFSimpleShape.this.getShadowColor());
            }
        };
    }

    public LineDecoration.DecorationShape getLineHeadDecoration() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 464);
        return prop == null ? null : LineDecoration.DecorationShape.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineHeadDecoration(LineDecoration.DecorationShape decoShape) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)464, decoShape == null ? -1 : decoShape.nativeId);
    }

    public LineDecoration.DecorationSize getLineHeadWidth() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 466);
        return prop == null ? null : LineDecoration.DecorationSize.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineHeadWidth(LineDecoration.DecorationSize decoSize) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)466, decoSize == null ? -1 : decoSize.nativeId);
    }

    public LineDecoration.DecorationSize getLineHeadLength() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 467);
        return prop == null ? null : LineDecoration.DecorationSize.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineHeadLength(LineDecoration.DecorationSize decoSize) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)467, decoSize == null ? -1 : decoSize.nativeId);
    }

    public LineDecoration.DecorationShape getLineTailDecoration() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 465);
        return prop == null ? null : LineDecoration.DecorationShape.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineTailDecoration(LineDecoration.DecorationShape decoShape) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)465, decoShape == null ? -1 : decoShape.nativeId);
    }

    public LineDecoration.DecorationSize getLineTailWidth() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 468);
        return prop == null ? null : LineDecoration.DecorationSize.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineTailWidth(LineDecoration.DecorationSize decoSize) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)468, decoSize == null ? -1 : decoSize.nativeId);
    }

    public LineDecoration.DecorationSize getLineTailLength() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 469);
        return prop == null ? null : LineDecoration.DecorationSize.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineTailLength(LineDecoration.DecorationSize decoSize) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)469, decoSize == null ? -1 : decoSize.nativeId);
    }

    public LineDecoration getLineDecoration() {
        return new LineDecoration(){

            public LineDecoration.DecorationShape getHeadShape() {
                return HSLFSimpleShape.this.getLineHeadDecoration();
            }

            public LineDecoration.DecorationSize getHeadWidth() {
                return HSLFSimpleShape.this.getLineHeadWidth();
            }

            public LineDecoration.DecorationSize getHeadLength() {
                return HSLFSimpleShape.this.getLineHeadLength();
            }

            public LineDecoration.DecorationShape getTailShape() {
                return HSLFSimpleShape.this.getLineTailDecoration();
            }

            public LineDecoration.DecorationSize getTailWidth() {
                return HSLFSimpleShape.this.getLineTailWidth();
            }

            public LineDecoration.DecorationSize getTailLength() {
                return HSLFSimpleShape.this.getLineTailLength();
            }
        };
    }

    public HSLFShapePlaceholderDetails getPlaceholderDetails() {
        return new HSLFShapePlaceholderDetails(this);
    }

    public Placeholder getPlaceholder() {
        return this.getPlaceholderDetails().getPlaceholder();
    }

    public void setPlaceholder(Placeholder placeholder) {
        this.getPlaceholderDetails().setPlaceholder(placeholder);
    }

    public void setStrokeStyle(Object ... styles) {
        if (styles.length == 0) {
            this.setLineColor(null);
            return;
        }
        for (Object st : styles) {
            if (st instanceof Number) {
                this.setLineWidth(((Number)st).doubleValue());
                continue;
            }
            if (st instanceof StrokeStyle.LineCap) {
                this.setLineCap((StrokeStyle.LineCap)st);
                continue;
            }
            if (st instanceof StrokeStyle.LineDash) {
                this.setLineDash((StrokeStyle.LineDash)st);
                continue;
            }
            if (st instanceof StrokeStyle.LineCompound) {
                this.setLineCompound((StrokeStyle.LineCompound)st);
                continue;
            }
            if (!(st instanceof Color)) continue;
            this.setLineColor((Color)st);
        }
    }

    public HSLFHyperlink getHyperlink() {
        return this._hyperlink;
    }

    public HSLFHyperlink createHyperlink() {
        if (this._hyperlink == null) {
            this._hyperlink = HSLFHyperlink.createHyperlink(this);
        }
        return this._hyperlink;
    }

    protected void setHyperlink(HSLFHyperlink link) {
        this._hyperlink = link;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }
}

