/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.networking.SubnetService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.openstack.networking.domain.NeutronSubnet;
import org.openstack4j.openstack.networking.domain.NeutronSubnetUpdate;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class SubnetServiceImpl
extends BaseNetworkingServices
implements SubnetService {
    @Override
    public List<? extends Subnet> list() {
        return this.get(NeutronSubnet.Subnets.class, this.uri("/subnets", new Object[0])).execute().getList();
    }

    @Override
    public Subnet get(String subnetId) {
        Preconditions.checkNotNull((Object)subnetId);
        return this.get(NeutronSubnet.class, this.uri("/subnets/%s", subnetId)).execute();
    }

    @Override
    public ActionResponse delete(String subnetId) {
        Preconditions.checkNotNull((Object)subnetId);
        return this.deleteWithResponse(this.uri("/subnets/%s", subnetId)).execute();
    }

    @Override
    public Subnet create(Subnet subnet) {
        Preconditions.checkNotNull((Object)subnet);
        return this.post(NeutronSubnet.class, this.uri("/subnets", new Object[0])).entity(subnet).execute();
    }

    @Override
    public Subnet update(Subnet subnet) {
        Preconditions.checkNotNull((Object)subnet);
        return this.update(subnet.getId(), subnet);
    }

    @Override
    public Subnet update(String subnetId, Subnet subnet) {
        Preconditions.checkNotNull((Object)subnetId);
        Preconditions.checkNotNull((Object)subnet);
        return this.put(NeutronSubnet.class, this.uri("/subnets/%s", subnetId)).entity(NeutronSubnetUpdate.createFromSubnet(subnet)).execute();
    }
}

