/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.queryparam;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.request.AttributeProvider;

public class Map
extends HashMap<String, List<String>>
implements Iterable<Map.Entry<String, List<String>>> {
    private static final long serialVersionUID = 7290854782114370126L;
    private static final List<String> emptyValue = Arrays.asList("");

    public Map() {
    }

    public Map(java.util.Map<? extends String, ?> source) {
        this.put(source.entrySet());
    }

    public String getFirst(Object key) {
        List values = (List)this.get(key == null ? null : key.toString());
        String value = values == null || values.isEmpty() ? null : (String)values.get(0);
        return value;
    }

    public void put(Iterable<? extends Map.Entry<?, ?>> params) {
        for (Map.Entry<?, ?> param : params) {
            Object rawKey = param.getKey();
            String key = rawKey == null ? null : rawKey.toString();
            Object rawValues = param.getValue();
            if (rawValues == null) {
                this.put(key, emptyValue);
                continue;
            }
            List<Object> values = null;
            if (rawValues instanceof Iterable) {
                values = new LinkedList();
                for (Object value : (Iterable)rawValues) {
                    if (value == null) continue;
                    values.add(value.toString());
                }
            }
            if (rawValues.getClass().isArray()) {
                values = new ArrayList(((Object[])rawValues).length);
                for (Object value : (Object[])rawValues) {
                    if (value == null) continue;
                    values.add(value.toString());
                }
            }
            if (values == null) {
                values = Arrays.asList(rawValues.toString());
            }
            if (values.isEmpty()) {
                values = emptyValue;
            }
            this.put(key, values);
        }
    }

    public StringBuilder appendTo(StringBuilder url, boolean mask) {
        if (url == null) {
            url = new StringBuilder();
        }
        int start = url.length();
        for (String key : this.keySet()) {
            List values = (List)this.get(key);
            for (String value : values == null || values.isEmpty() ? emptyValue : values) {
                if (value == null || value.isEmpty()) {
                    url.append('&').append(key).append('=');
                    continue;
                }
                value = this.mask(mask, key, value);
                url.append('&').append(key).append('=').append(value);
            }
        }
        if (url.length() > start) {
            url.setCharAt(start, '?');
        }
        return url;
    }

    protected String mask(boolean mask, String key, String value) {
        return value;
    }

    @Override
    public String toString() {
        return this.appendTo(null, true).toString();
    }

    public Map encode() {
        return this.encode(AttributeProvider.UTF_8);
    }

    public Map encode(Charset encoding) {
        for (Map.Entry entry : this.entrySet()) {
            ArrayList<String> encoded = new ArrayList<String>(((List)entry.getValue()).size());
            for (String value : (List)entry.getValue()) {
                encoded.add(AttributeProvider.encode(encoding, value, (String)entry.getKey()));
            }
            entry.setValue(encoded);
        }
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return this.entrySet().iterator();
    }
}

