/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opengion.fukurou.model.CloudFileOperation;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class FileOperation_AWS
extends CloudFileOperation {
    private final AmazonS3 amazonS3;
    private final String PLUGIN = "aws";

    public FileOperation_AWS(String string, String string2) {
        super(StringUtil.nval((String)string, (String)HybsSystem.sys((String)"CLOUD_BUCKET")), string2);
        StringBuilder stringBuilder;
        this.setPlugin("aws");
        String string3 = HybsSystem.sys((String)"CLOUD_STORAGE_S3_ACCESS_KEY");
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (StringUtils.isEmpty((CharSequence)string3)) {
            this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false))).build();
        } else {
            string4 = HybsSystem.sys((String)"CLOUD_STORAGE_S3_SECRET_KEY");
            string5 = HybsSystem.sys((String)"CLOUD_STORAGE_S3_SERVICE_END_POINT");
            string6 = HybsSystem.sys((String)"CLOUD_STORAGE_S3_REGION");
            BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(string3, string4);
            stringBuilder = new AwsClientBuilder.EndpointConfiguration(string5, string6);
            this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials))).withEndpointConfiguration((AwsClientBuilder.EndpointConfiguration)stringBuilder)).build();
        }
        try {
            if (!this.amazonS3.doesBucketExist(this.conBucket)) {
                this.amazonS3.createBucket(this.conBucket);
            }
        }
        catch (AmazonS3Exception amazonS3Exception) {
            stringBuilder = new StringBuilder(200);
            if (StringUtils.isEmpty((CharSequence)string3)) {
                stringBuilder.append("IAM\u30ed\u30fc\u30eb\u306b\u3088\u308b\u8a8d\u8a3c\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            } else {
                stringBuilder.append("\u30a2\u30af\u30bb\u30b9\u30ad\u30fc\u306b\u3088\u308b\u8a8d\u8a3c\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                stringBuilder.append(" CLOUD_STORAGE_S3_ACCESS_KEY\uff1a").append(string3);
                stringBuilder.append(" CLOUD_STORAGE_S3_SECRET_KEY\uff1a\u975e\u8868\u793a");
                stringBuilder.append(" CLOUD_STORAGE_S3_SERVICE_END_POINT\uff1a").append(string5);
                stringBuilder.append(" CLOUD_STORAGE_S3_REGION\uff1a").append(string6);
            }
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(amazonS3Exception.getMessage());
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void write(InputStream inputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            byte[] byArray = this.toByteArray(inputStream);
            objectMetadata.setContentLength((long)byArray.length);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.conBucket, this.conPath, (InputStream)byteArrayInputStream, objectMetadata);
            this.amazonS3.putObject(putObjectRequest);
        }
        catch (Exception exception) {
            try {
                StringBuilder stringBuilder = new StringBuilder(200);
                stringBuilder.append("AWS\u30d0\u30b1\u30c3\u30c8\u306b\u66f8\u304d\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002path\uff1a").append(this.conPath);
                stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
                throw new IOException(stringBuilder.toString());
            }
            catch (Throwable throwable) {
                Closer.ioClose(byteArrayInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)byteArrayInputStream);
    }

    public InputStream read() throws FileNotFoundException {
        S3Object s3Object = null;
        try {
            s3Object = this.amazonS3.getObject(this.conBucket, this.conPath);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("AWS\u30d0\u30b1\u30c3\u30c8\u304b\u3089\u8aad\u307f\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002path\uff1a").append(this.conPath);
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
            throw new FileNotFoundException(stringBuilder.toString());
        }
        return s3Object.getObjectContent();
    }

    public boolean delete() {
        boolean bl = false;
        try {
            if (this.isFile()) {
                this.amazonS3.deleteObject(this.conBucket, this.conPath);
            } else if (this.isDirectory()) {
                ObjectListing objectListing = this.amazonS3.listObjects(this.conBucket, this.conPath);
                List list = objectListing.getObjectSummaries();
                for (S3ObjectSummary s3ObjectSummary : list) {
                    this.amazonS3.deleteObject(this.conBucket, s3ObjectSummary.getKey());
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean copy(String string) {
        boolean bl = false;
        try {
            this.amazonS3.copyObject(this.conBucket, this.conPath, this.conBucket, string);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public long length() {
        long l = 0L;
        try {
            ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(this.conBucket, this.conPath);
            l = objectMetadata.getContentLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public long lastModified() {
        long l = 0L;
        try {
            ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(this.conBucket, this.conPath);
            l = objectMetadata.getLastModified().getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public boolean isFile() {
        boolean bl = false;
        if (!this.isDirectory()) {
            bl = this.amazonS3.doesObjectExist(this.conBucket, this.conPath);
        }
        return bl;
    }

    public boolean isDirectory() {
        boolean bl = false;
        if (StringUtils.isEmpty((CharSequence)this.conPath)) {
            return true;
        }
        ObjectListing objectListing = this.amazonS3.listObjects(this.conBucket, this.setDirTail(this.conPath));
        List list = objectListing.getObjectSummaries();
        bl = list.size() != 0;
        return bl;
    }

    public File[] listFiles(FileFilter fileFilter) {
        Object object;
        String string;
        Object object22;
        if (!this.exists()) {
            return new FileOperationInfo[0];
        }
        String string2 = this.conPath;
        if (this.isDirectory()) {
            string2 = this.setDirTail(this.conPath);
        }
        ArrayList<FileOperationInfo> arrayList = new ArrayList<FileOperationInfo>();
        ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.conBucket).withPrefix(string2).withDelimiter("/");
        ListObjectsV2Result listObjectsV2Result = this.amazonS3.listObjectsV2(listObjectsV2Request);
        List list = listObjectsV2Result.getObjectSummaries();
        for (Object object22 : list) {
            string = object22.getKey();
            object = new FileOperationInfo("aws", this.conBucket, string);
            object.setLastModifiedValue(object22.getLastModified().getTime());
            object.setFile(true);
            object.setSize(object22.getSize());
            arrayList.add((FileOperationInfo)object);
        }
        List list2 = listObjectsV2Result.getCommonPrefixes();
        object22 = list2.iterator();
        while (object22.hasNext()) {
            string = (String)object22.next();
            object = this.rTrim(string, '/');
            FileOperationInfo fileOperationInfo = new FileOperationInfo("aws", this.conBucket, (String)object);
            fileOperationInfo.setDirectory(true);
            arrayList.add(fileOperationInfo);
        }
        object22 = this.filter(arrayList, fileFilter);
        return object22;
    }

    public FileOperation getParentFile() {
        return new FileOperation_AWS(this.conBucket, this.getParent());
    }
}

