/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import java.io.Closeable;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import oracle.cloud.storage.CloudStorage;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.CloudStorageFactory;
import oracle.cloud.storage.exception.NoSuchContainerException;
import oracle.cloud.storage.exception.NoSuchObjectException;
import oracle.cloud.storage.model.Key;
import oracle.cloud.storage.model.QueryOption;
import oracle.cloud.storage.model.StorageInputStream;
import org.apache.commons.lang3.StringUtils;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.StorageAPI;

public class StorageAPI_oracle
implements StorageAPI {
    private String serviceName = "";
    private String userName = "";
    private String password = "";
    private String serviceUrl = "";
    private String containerNm = "";
    CloudStorage myConnection = null;

    public StorageAPI_oracle(String string, HttpSession httpSession) {
        CloudStorageConfig cloudStorageConfig = new CloudStorageConfig();
        this.serviceName = HybsSystem.sys((String)"CLOUD_STORAGE_ORACLE_SERVICE_NAME");
        this.userName = HybsSystem.sys((String)"CLOUD_STORAGE_ORACLE_USERNAME");
        this.password = HybsSystem.sys((String)"CLOUD_STORAGE_ORACLE_PASSWORD");
        this.serviceUrl = HybsSystem.sys((String)"CLOUD_STORAGE_ORACLE_SERVICEURL");
        this.initCheck();
        this.containerNm = string;
        try {
            cloudStorageConfig.setServiceName(this.serviceName).setUsername(this.userName).setPassword(this.password.toCharArray()).setServiceUrl(this.serviceUrl);
            this.myConnection = CloudStorageFactory.getStorage((CloudStorageConfig)cloudStorageConfig);
            try {
                this.myConnection.describeContainer(this.containerNm);
            }
            catch (NoSuchContainerException noSuchContainerException) {
                this.myConnection.createContainer(string);
            }
        }
        catch (Exception exception) {
            throw new HybsSystemException((Throwable)exception);
        }
    }

    private void initCheck() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)this.serviceName)) {
            stringBuilder.append("CLOUD_STORAGE_ORACLE_SERVICE_NAME");
        }
        if (StringUtils.isEmpty((CharSequence)this.userName)) {
            stringBuilder.append(",CLOUD_STORAGE_ORACLE_USERNAME");
        }
        if (StringUtils.isEmpty((CharSequence)this.password)) {
            stringBuilder.append(",CLOUD_STORAGE_ORACLE_PASSWORD");
        }
        if (StringUtils.isEmpty((CharSequence)this.serviceUrl)) {
            stringBuilder.append(",CLOUD_STORAGE_ORACLE_SERVICEURL");
        }
        if (stringBuilder.length() > 0) {
            throw new HybsSystemException("\u30af\u30e9\u30a6\u30c9\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30ad\u30fc\u60c5\u5831(" + stringBuilder.toString() + ")\u304c\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    private String editPath(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        if ("/".equals(string.substring(0, 1))) {
            string = string.substring(1);
        }
        string = string.replaceAll("//", "/");
        return string;
    }

    public void add(InputStream inputStream, String string, String string2, HttpSession httpSession) {
        try {
            string = this.editPath(string);
            this.myConnection.storeObject(this.containerNm, string + string2, "application/octet-stream", inputStream);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u3078\u306e\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002updFolder:");
            stringBuilder.append(string);
            stringBuilder.append(" updFileName:");
            stringBuilder.append(string2);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        finally {
            Closer.ioClose((Closeable)inputStream);
        }
    }

    public InputStream get(String string, HttpSession httpSession) {
        StorageInputStream storageInputStream = null;
        try {
            string = this.editPath(string);
            storageInputStream = this.myConnection.retrieveObject(this.containerNm, string);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u304b\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        return storageInputStream;
    }

    public void copy(String string, String string2, HttpSession httpSession) {
        InputStream inputStream = null;
        try {
            string = this.editPath(string);
            string2 = this.editPath(string2);
            inputStream = this.get(string, httpSession);
            this.add(inputStream, string2, "", httpSession);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u30b3\u30d4\u30fc\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002oldFilePath:");
            stringBuilder.append(string);
            stringBuilder.append(" newFilePath:");
            stringBuilder.append(string2);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void delete(String string, HttpSession httpSession) {
        try {
            string = this.editPath(string);
            this.myConnection.deleteObject(this.containerNm, string);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void rename(String string, String string2, String string3, boolean bl, HttpSession httpSession) {
        String string4 = string + string3;
        String string5 = string + string2;
        if (this.exists(string4, httpSession) && bl) {
            String string6 = string + "_backup/" + string3 + "_" + System.currentTimeMillis() + '.' + FileUtil.getExtension((String)string3);
            this.copy(string4, string6, httpSession);
        }
        this.copy(string5, string4, httpSession);
        this.delete(string5, httpSession);
    }

    public boolean exists(String string, HttpSession httpSession) {
        boolean bl = true;
        try {
            string = this.editPath(string);
            try {
                this.myConnection.describeObject(this.containerNm, string);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                bl = false;
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        return bl;
    }

    public String[] list(String string, HttpSession httpSession) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            string = this.editPath(string);
            HashMap<QueryOption, String> hashMap = new HashMap<QueryOption, String>();
            hashMap.put(QueryOption.PREFIX, string);
            List list = this.myConnection.listObjects(this.containerNm, hashMap);
            for (Key key : list) {
                arrayList.add(key.getKey());
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002startsWith:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append("e");
            throw new HybsSystemException(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Map<String, String> getInfo(String string, HttpSession httpSession) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Key key = null;
        try {
            string = this.editPath(string);
            key = this.myConnection.describeObject(this.containerNm, string);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002path:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        hashMap.put("SIZE", String.valueOf(key.getSize()));
        hashMap.put("LASTMODIFIED", simpleDateFormat.format(key.getLastModified()));
        return hashMap;
    }
}

