/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.metrics;

import com.ibm.cloud.objectstorage.metrics.AwsSdkMetrics;
import com.ibm.cloud.objectstorage.metrics.ByteThroughputProvider;
import com.ibm.cloud.objectstorage.metrics.ServiceMetricCollector;
import com.ibm.cloud.objectstorage.metrics.ThroughputMetricType;
import java.util.concurrent.TimeUnit;

class ByteThroughputHelper
extends ByteThroughputProvider {
    private static final int REPORT_INTERVAL_SECS = 10;

    ByteThroughputHelper(ThroughputMetricType type) {
        super(type);
    }

    long startTiming() {
        if (TimeUnit.NANOSECONDS.toSeconds(this.getDurationNano()) > 10L) {
            this.reportMetrics();
        }
        return System.nanoTime();
    }

    void reportMetrics() {
        if (this.getByteCount() > 0) {
            Object col = AwsSdkMetrics.getServiceMetricCollector();
            ((ServiceMetricCollector)col).collectByteThroughput(this);
            this.reset();
        }
    }

    @Override
    public void increment(int bytesDelta, long startTimeNano) {
        super.increment(bytesDelta, startTimeNano);
    }
}

