<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE7003"
	title    = "処理定義ﾏｽﾀ"
	date     = "2017/06/27"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
		select	SYSTEM_ID , EXECID , NAME_JA , SEQNO , RUNTYPE , RUNPG , CLMS , PARAMS
				 , DBID , TABLE_NAME , SHT_NOS , FILE_ENC , SKIP_CNT
				 , RELEASE_NOTES , RDC_CODE , DYUPD , USRUPD , FGJ , UNIQ
		from GE72
	<og:where>
		<og:and value = "SYSTEM_ID	=		'{@SYSTEM_ID}'"		/>
		<og:and value = "EXECID		like	'{@EXECID}'"		/>
		<og:and value = "NAME_JA	like	'{@NAME_JA}'"		/>
		<og:and value = "RUNTYPE	=		'{@RUNTYPE}'"		/>
		<og:and value = "RUNPG		like	'{@RUNPG}'"			/>
		<og:and value = "TABLE_NAME	like	'{@TABLE_NAME}'"	/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhere.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,SEQNO" />
</og:query>

<form method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,EXECID"  />
		<og:submit  action="DELETE"  columnWritable="null" />
		<br />
	</og:writeCheck>

	<og:columnEditor columns="PARAMS" clazz="W100" />
	<og:columnEditor columns="SYSTEM_ID,EXECID,SEQNO,RUNTYPE,SKIP_CNT" must="true" />

	<og:view
		viewFormType = "HTMLTable"
		command 	= "{@command}"
		noDisplay	= "UNIQ"
		checked 	= "{@checked}"
		startNo 	= "{@startNo}"
		pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
