package org.opengion.hayabusa.io;

import javax.servlet.http.HttpSession;

import org.opengion.hayabusa.common.HybsSystemException;

/**
 * クラウド別のクラス生成
 * 
 * @og.rev 5.9.25.0 (2017/10/06) 新規作成
 * @og.group
 *
 * @version 5.0
 * @author T.OTA
 * @since JDK7.0
 */
public final class StorageAPIFactory {
	/**
	 * デフォルトコンストラクタを private 化しておきます。
	 */
	private StorageAPIFactory(){};

	/**
	 * 指定されたクラウド対象クラスを生成する。
	 *
	 * @param storage クラウド種別
	 * @param container コンテナ
	 * @param hsession セッション
	 * @return StorageAPIを継承したクラス
	 */
	public static StorageAPI newStorageAPI(final String storage, final String container, final HttpSession hsession){
		StorageAPI storageapi;
		try{
			// StorageAPIの実装ｸﾗｽをstorage別に生成する
			final Object[] args = new Object[]{container, hsession};
			storageapi = (StorageAPI)Class.forName( "org.opengion.plugin.cloud.StorageAPI_" + storage )
					.getConstructor(String.class, HttpSession.class)
					.newInstance(args);
//		} catch( final Exception ex ) {
		} catch( final Throwable th ) {		// PMD : 6.9.9.4 (2018/10/01)
			final StringBuilder sbErrMsg = new StringBuilder()
				.append("ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ用のｸﾗｽ生成に失敗しました。storage:").append(storage)
				.append(" container:").append(container)
				.append(" errInfo:"  ).append(th)
				.append(" errCause:" ).append(th.getCause());
			throw new HybsSystemException(sbErrMsg.toString());
		}
		return storageapi;
	}
}
