<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE7003"
	title    = "処理定義ﾏｽﾀ"
	date     = "2017/06/27"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
		select	A.SYSTEM_ID , A.EXECID , A.NAME_JA , A.SEQNO , A.RUNTYPE , A.RUNPG , A.CLMS , A.PARAMS
				 , A.DBID , A.TABLE_NAME , A.SHT_NOS , A.FILE_ENC , A.SKIP_CNT
				 , A.RELEASE_NOTES , A.RDC_CODE , A.DYUPD , A.USRUPD , A.FGJ , A.UNIQ
		from GE72 A
	<og:where>
		<og:and value = "A.SYSTEM_ID	=		'{@SYSTEM_ID}'"		/>
		<og:and value = "A.EXECID		like	'{@EXECID}'"		/>
		<og:and value = "A.NAME_JA		like	'{@NAME_JA}'"		/>
		<og:and value = "A.RUNTYPE		=		'{@RUNTYPE}'"		/>
		<og:and value = "A.RUNPG		like	'{@RUNPG}'"			/>
		<og:and value = "A.TABLE_NAME	like	'{@TABLE_NAME}'"	/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.SEQNO" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="EXECID" gamenId="GE7001" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,EXECID,FGJ"
		vals="NEW,{@SYSTEM_ID},[EXECID],1" />
</og:viewLink>

<form method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,EXECID"  />
		<og:submit  action="DELETE"  columnWritable="null" />
		<br />
	</og:writeCheck>

	<og:columnEditor columns="PARAMS" clazz="W100" />
	<og:columnEditor columns="SYSTEM_ID,EXECID,SEQNO,RUNTYPE,SKIP_CNT" must="true" />

	<og:view
		viewFormType = "HTMLTable"
		command 	= "{@command}"
		noDisplay	= "UNIQ"
		checked 	= "{@checked}"
		startNo 	= "{@startNo}"
		pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
