/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DatabaseConfig;
import org.opengion.fukurou.db.EDbid;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.AbstractObjectPool;

public final class ConnectionFactory {
    private static final ConcurrentMap<String, ConnectionPool> CONN_MAP = new ConcurrentHashMap<String, ConnectionPool>();
    private static String defDBID = "DEFAULT";
    private static ConnectionPool defPOOL;
    private static DatabaseConfig dbConf;

    private ConnectionFactory() {
    }

    public static void init(String string, String string2) {
        dbConf = new DatabaseConfig(string2);
        defDBID = string == null || string.isEmpty() || dbConf.getDbid(string) == null ? "DEFAULT" : string;
        defPOOL = new ConnectionPool(dbConf, defDBID);
    }

    public static Connection connection(String string, ApplicationInfo applicationInfo) {
        Object object;
        ConnectionPool connectionPool;
        if (string == null || string.isEmpty() || defDBID.equalsIgnoreCase(string)) {
            connectionPool = defPOOL;
        } else {
            object = string.toUpperCase(Locale.JAPAN);
            connectionPool = CONN_MAP.computeIfAbsent((String)object, arg_0 -> ConnectionFactory.lambda$connection$0((String)object, arg_0));
        }
        object = (Connection)connectionPool.newInstance();
        if (applicationInfo != null && connectionPool.useApplicationInfo()) {
            applicationInfo.callAppInfo((Connection)object);
        }
        return object;
    }

    public static void close(Connection connection, String string) {
        if (connection != null) {
            Closer.commit(connection);
            if (string == null || string.isEmpty() || defDBID.equalsIgnoreCase(string)) {
                defPOOL.release(connection);
            } else {
                String string2 = string.toUpperCase(Locale.JAPAN);
                ConnectionPool connectionPool = (ConnectionPool)CONN_MAP.get(string2);
                if (connectionPool != null) {
                    connectionPool.release(connection);
                }
            }
        }
    }

    public static void remove(Connection connection, String string) {
        if (connection != null) {
            if (string == null || string.isEmpty() || defDBID.equalsIgnoreCase(string)) {
                defPOOL.remove(connection);
            } else {
                String string2 = string.toUpperCase(Locale.JAPAN);
                ConnectionPool connectionPool = (ConnectionPool)CONN_MAP.get(string2);
                if (connectionPool != null) {
                    connectionPool.remove(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void realClose() {
        ConnectionPool connectionPool2 = defPOOL;
        synchronized (connectionPool2) {
            if (!defPOOL.isEmpty()) {
                defPOOL.clear();
            }
        }
        CONN_MAP.forEach((string, connectionPool) -> connectionPool.clear());
        CONN_MAP.clear();
    }

    public static String information() {
        return ConnectionFactory.information(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String information(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<b>\u3010Connection Information\u3011</b>").append(HybsConst.CR);
        ConnectionPool connectionPool2 = defPOOL;
        synchronized (connectionPool2) {
            if (!defPOOL.isEmpty()) {
                if (bl) {
                    stringBuilder.append(defPOOL.toString()).append("<br><hr>");
                } else {
                    stringBuilder.append(defPOOL.dbidInfo());
                }
            }
        }
        CONN_MAP.forEach((string, connectionPool) -> {
            if (connectionPool.getDBName() != null) {
                if (bl) {
                    stringBuilder.append(connectionPool.toString()).append("<br><hr>");
                } else {
                    stringBuilder.append(connectionPool.dbidInfo());
                }
            }
        });
        return stringBuilder.append(HybsConst.CR).toString();
    }

    public static boolean useParameterMetaData(String string) {
        String string2 = string == null || string.isEmpty() ? defDBID : string.toUpperCase(Locale.JAPAN);
        EDbid eDbid = dbConf.getDbid(string2);
        return eDbid != null && eDbid.useParamMetaData();
    }

    public static String getDBName(String string) {
        String string2;
        if (string == null || string.isEmpty() || defDBID.equalsIgnoreCase(string)) {
            string2 = defPOOL.getDBName();
        } else {
            String string3 = string.toUpperCase(Locale.JAPAN);
            ConnectionPool connectionPool = null;
            connectionPool = (ConnectionPool)CONN_MAP.get(string3);
            if (connectionPool == null) {
                ConnectionFactory.connection(string, null);
                connectionPool = (ConnectionPool)CONN_MAP.get(string3);
            }
            if (connectionPool == null) {
                String string4 = "\u6307\u5b9a\u306eDBID\u30ad\u30fc\u306b\u5bfe\u5fdc\u3059\u308b\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u3092\u53d6\u5f97\u51fa\u6765\u307e\u305b\u3093\u3002[Key =" + string + "]";
                throw new OgRuntimeException(string4);
            }
            string2 = connectionPool.getDBName();
        }
        return string2.toUpperCase(Locale.JAPAN);
    }

    private static /* synthetic */ ConnectionPool lambda$connection$0(String string, String string2) {
        return new ConnectionPool(dbConf, string);
    }

    private static final class ConnectionPool
    extends AbstractObjectPool<Connection> {
        private final transient EDbid edbid;
        private static final int TIMEOUT = 10;

        private ConnectionPool(DatabaseConfig databaseConfig, String string) {
            EDbid eDbid = databaseConfig.getDbid(string);
            if (eDbid == null) {
                String string2 = "\u6307\u5b9a\u306eDBID\u30ad\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[Key =" + string + "]";
                throw new OgRuntimeException(string2);
            }
            this.edbid = eDbid;
            this.init(eDbid.getMincount(), eDbid.getMaxcount(), true, eDbid.getPooltime());
        }

        @Override
        protected void objectFinal(Connection connection) {
            Closer.connClose(connection);
        }

        @Override
        protected Connection createInstance() {
            Connection connection = null;
            try {
                Properties properties = this.edbid.getProps();
                properties.put("user", this.edbid.getUser());
                properties.put("password", this.edbid.getPassword());
                DriverManager.setLoginTimeout(10);
                connection = DriverManager.getConnection(this.edbid.getUrl(), properties);
                connection.setReadOnly(this.edbid.isReadonly());
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(2);
                if (this.edbid.getDbProductName() == null) {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    this.edbid.setMetaDataInfo(databaseMetaData);
                }
                return connection;
            }
            catch (SQLException sQLException) {
                String string = "\u30b3\u30cd\u30af\u30c8\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + HybsConst.CR + "DBID=[" + this.edbid.getDbidKey() + "]" + HybsConst.CR + sQLException.getMessage() + " , status=" + sQLException.getSQLState();
                Closer.connClose(connection);
                throw new OgRuntimeException(string, sQLException);
            }
        }

        public boolean useApplicationInfo() {
            return this.edbid.isApplicationInfo();
        }

        public String getDBName() {
            return this.edbid.getDbProductName();
        }

        public String getDBVersion() {
            return this.edbid.getDbProductVersion();
        }

        public String dbidInfo() {
            return this.edbid.info();
        }

        @Override
        public String toString() {
            return this.edbid.toString() + super.toString();
        }
    }
}

