/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.fileexec.CommandLine;
import org.opengion.fukurou.fileexec.FileExec;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public final class MainProcess {
    private static final XLogger LOGGER = XLogger.getLogger(MainProcess.class.getName());
    private final ConcurrentMap<String, FileExec> execMap = new ConcurrentHashMap<String, FileExec>();
    public static final String USAGE = "Usage: java org.opengion.fukurou.fileexec.MainProcess [-LOOP n(\u79d2)] [-help]";

    public void startTask(CommandLine commandLine) {
        String string = commandLine.getValue(CommandLine.GE70.SYSTEM_ID);
        String string2 = commandLine.getValue(CommandLine.GE70.RSRV_NO);
        String string3 = string + "_" + string2;
        this.stopTask(string3);
        String string4 = commandLine.getValue(CommandLine.GE70.FGYKAN);
        if ("1".equals(string4) || "3".equals(string4)) {
            FileExec fileExec = new FileExec(commandLine);
            LOGGER.info(() -> "startTask: yoyakuNo=[" + string3 + "]");
            fileExec.watchStart();
            this.execMap.put(string3, fileExec);
        } else {
            LOGGER.warning(() -> "\u3010WARNING\u3011startTask: yoyakuNo=[" + string3 + "] , fgkan=[" + string4 + "]");
        }
    }

    private void stopTask(String string) {
        FileExec fileExec = (FileExec)this.execMap.remove(string);
        if (fileExec != null) {
            fileExec.watchStop();
        }
        LOGGER.info(() -> "stopTask: yoyakuNo=[" + string + "]");
    }

    public void watchStop() {
        this.execMap.forEach((string, fileExec) -> fileExec.watchStop());
    }

    public static void main(String[] stringArray) {
        int n = 10;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-help".equalsIgnoreCase(string)) {
                System.out.println(USAGE);
                return;
            }
            if (!"-LOOP".equalsIgnoreCase(string)) {
                throw MsgUtil.throwException("MSG2011", Arrays.toString(stringArray));
            }
            n = Integer.parseInt(stringArray[++i]);
        }
        MainProcess mainProcess = new MainProcess();
        boolean bl = true;
        int n2 = 0;
        while (true) {
            try {
                while (true) {
                    List<CommandLine> list = CommandLine.dbCommand(bl);
                    list.forEach(commandLine -> mainProcess.startTask((CommandLine)commandLine));
                    try {
                        Thread.sleep((long)n * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = false;
                    System.out.println(StringUtil.getTimeFormat("yyyyMMdd HH:mm:ss [" + n2++ + "]"));
                }
            }
            catch (Throwable throwable) {
                MsgUtil.errPrintln(throwable, "MSG0021", throwable.getMessage());
                try {
                    Thread.sleep((long)(10 * n) * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                mainProcess.watchStop();
                continue;
            }
            break;
        }
    }
}

