/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.query;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractQuery;

public class Query_JDBCCallable
extends AbstractQuery {
    private static final String VERSION = "6.9.3.0 (2018/03/26)";

    public void execute(String ... stringArray) {
        CallableStatement callableStatement = null;
        try {
            int n;
            callableStatement = this.getConnection().prepareCall(this.getStatement());
            callableStatement.setQueryTimeout(DB_MAX_QUERY_TIMEOUT);
            callableStatement.setFetchSize(251);
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 12);
            for (n = 0; n < stringArray.length; ++n) {
                callableStatement.setObject(n + 3, (Object)StringUtil.rTrim((String)stringArray[n]));
            }
            callableStatement.execute();
            n = callableStatement.getInt(1);
            this.setErrorCode(n);
            if (n > 0) {
                String string = callableStatement.getString(2);
                ErrorMessage errorMessage = new ErrorMessage("Query_JDBCCallable Error!!");
                errorMessage.addMessage(new String[]{string});
                this.setErrorMessage(errorMessage);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.setErrorCode(8);
                String string = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + this.getStatement() + CR;
                throw new HybsSystemException(string, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Closer.stmtClose(callableStatement);
                throw throwable;
            }
        }
        Closer.stmtClose((Statement)callableStatement);
    }
}

