/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.opengion.fukurou.system.OgBuilder;
import org.opengion.fukurou.util.ColorMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.plugin.view.ViewForm_HTMLTable;

public class ViewForm_ImageTimeBar
extends ViewForm_HTMLTable {
    private static final String VERSION = "7.1.0.0 (2020/01/20)";
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Color NULL_COLOR = Color.WHITE;
    private static final int M_60 = 60;
    private static final int H_24 = 24;
    private static final int DEC = 10;
    private static final int MINUTE_OF_DAY = 1440;
    private static final long MILLI_MINUTE = 60000L;
    private long startDate;
    private long timeSpan;
    private boolean useLegend;
    private int maxLabelWidth;
    private int maxTimeWidth;
    private int chartHeight;
    private int headerHeight;
    private int chartPadding;
    private int recodeMargin;
    private boolean useLastData;
    private boolean isDebug;
    private String tempDir;
    private String tempUrl;
    private String headerUpFmt;
    private String headerDwFmt;
    private static final int KEY_CLMNO = 0;
    private static final int DY_CLMNO = 1;
    private static final int FGJ_CLMNO = 2;
    private int[] labelClmsNo;
    private int[] maxClmWidth;
    private int colClmNo = -1;
    private int tipsClmNo = -1;
    private int linkClmNo = -1;
    private int str2DateTime;
    private int startTime;
    private long nowTime;
    private int maxX;
    private int maxY;
    private boolean useCR;
    private static final Stroke DSAH_STROK = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 1.0f}, 0.0f);

    @Override
    public String create(int n, int n2) {
        File file;
        Object object;
        if (this.getRowCount() == 0) {
            return "";
        }
        this.paramInit();
        int n3 = this.getLastNo(n, n2);
        this.calcImageSize(n, n3);
        BufferedImage bufferedImage = new BufferedImage(this.maxX, this.maxY, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(this.chartPadding, this.chartPadding, this.maxX - this.chartPadding * 2 + 1, this.maxY - this.chartPadding * 2 + 1);
        StringBuilder stringBuilder = new StringBuilder(500);
        String string = "";
        long l = 0L;
        Color color = NULL_COLOR;
        FlgColorMap flgColorMap = new FlgColorMap();
        int n4 = this.chartPadding + (this.headerHeight + this.recodeMargin * 2) * (this.useLegend ? 2 : 1);
        int n5 = this.chartHeight + this.recodeMargin * 2;
        double d = (double)this.maxTimeWidth / (double)this.timeSpan;
        boolean bl = this.tipsClmNo >= 0 || this.linkClmNo >= 0;
        for (int i = n; i < n3; ++i) {
            Object object2;
            String string2;
            int n6;
            int n7;
            long l2;
            String string3 = this.getValue(i, 0);
            String string4 = this.getValue(i, 1);
            if (!string.equals(string3)) {
                if (i > n) {
                    l2 = this.nowTime;
                    if (l2 > this.timeSpan || l2 < l) {
                        l2 = this.timeSpan;
                    }
                    if (!this.useLastData) {
                        color = NULL_COLOR;
                    }
                    while (l < this.timeSpan) {
                        n7 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
                        n6 = (int)((double)(l2 - l) * d);
                        if (this.isDebug) {
                            string2 = this.getTime2Str(this.startTime + (int)l);
                            object2 = this.getTime2Str(this.startTime + (int)l2);
                            System.out.println("\u2461 ROW[" + i + "]=" + string2 + " - " + (String)object2 + " imgX=" + n7 + " imgW=" + n6);
                        }
                        this.imageMeker(graphics2D, color, n7, n4, n6, bl, i, stringBuilder);
                        l = l2;
                        l2 = this.timeSpan;
                        color = NULL_COLOR;
                    }
                    n4 += n5;
                }
                string = string3;
                int n8 = this.labelClmsNo.length;
                int n9 = this.chartPadding;
                n7 = n4 + this.chartHeight + this.recodeMargin;
                graphics2D.setColor(LABEL_COLOR);
                for (n6 = 0; n6 < n8; ++n6) {
                    string2 = StringUtil.spanCut((String)this.getValueLabel(i, this.labelClmsNo[n6]));
                    if (this.useCR) {
                        object2 = string2.split("\\n|\\\\n");
                        for (int j = 0; j < ((String[])object2).length; ++j) {
                            int n10 = n7 - (((String[])object2).length - 1 - j) * n5 / ((String[])object2).length;
                            graphics2D.drawString(object2[j], n9 + this.recodeMargin, n10);
                        }
                    } else {
                        graphics2D.drawString(string2, n9 + this.recodeMargin, n7);
                    }
                    n9 += this.recodeMargin * 2 + this.maxClmWidth[n6];
                }
                graphics2D.drawRect(this.chartPadding, n4, this.maxX - this.chartPadding * 2, n5);
                l = 0L;
                color = NULL_COLOR;
            }
            if ((l2 = this.getStr2Date(string4) - this.startDate) < l) {
                l2 = l;
            }
            n7 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
            n6 = (int)((double)(l2 - l) * d);
            if (this.isDebug) {
                string2 = this.getTime2Str(this.startTime + (int)l);
                object2 = this.getTime2Str(this.startTime + (int)l2);
                System.out.println("\u2460 ROW[" + i + "]=" + string2 + " - " + (String)object2 + " imgX=" + n7 + " imgW=" + n6);
            }
            this.imageMeker(graphics2D, color, n7, n4, n6, bl, i, stringBuilder);
            l = l2;
            string2 = this.getValue(i, 2);
            object2 = this.getValueLabel(i, 2);
            color = this.colClmNo >= 0 ? flgColorMap.getColor(string2, (String)object2, this.getValueLabel(i, this.colClmNo)) : flgColorMap.getColor(string2, (String)object2);
        }
        long l3 = this.nowTime;
        if (l3 > this.timeSpan || l3 < l) {
            l3 = this.timeSpan;
        }
        if (!this.useLastData) {
            color = NULL_COLOR;
        }
        while (l < this.timeSpan) {
            int n11 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
            int n12 = (int)((double)(l3 - l) * d);
            if (this.isDebug) {
                String string5 = this.getTime2Str(this.startTime + (int)l);
                String string6 = this.getTime2Str(this.startTime + (int)l3);
                System.out.println("\u2462 ROW[" + n3 + "]=" + string5 + " - " + string6 + " imgX=" + n11 + " imgW=" + n12);
            }
            this.imageMeker(graphics2D, color, n11, n4, n12, bl, n3, stringBuilder);
            l = l3;
            l3 = this.timeSpan;
            color = NULL_COLOR;
        }
        this.imageHeaderPaint(graphics2D, d, flgColorMap);
        try {
            object = new File(this.tempDir);
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                String string7 = "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u5148\u306e\u30d5\u30a9\u30eb\u30c0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002tempDir=[" + (File)object + "]";
                throw new HybsSystemException(string7);
            }
            file = File.createTempFile("Img", ".png", (File)object);
            file.deleteOnExit();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
            graphics2D.dispose();
        }
        catch (IOException iOException) {
            String string8 = "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002tempDir=[" + this.tempDir + "]";
            throw new HybsSystemException(string8, (Throwable)iOException);
        }
        object = this.getWidth();
        Object object3 = this.getHeight();
        if (StringUtil.isEmpty((CharSequence[])new CharSequence[]{object}) && StringUtil.isEmpty((CharSequence[])new CharSequence[]{object3})) {
            object = this.maxX + "px";
            object3 = this.maxY + "px";
        }
        return new OgBuilder().append(new CharSequence[]{"<img id='ImageTimeBar' alt='ImageTimeBar' title='ImageTimeBar' border='0'"}).appendNN(new CharSequence[]{" width='", object, "'"}).appendNN(new CharSequence[]{" height='", object3, "'"}).append(new CharSequence[]{" src='", this.tempUrl, file.getName(), "'"}).appendCase(stringBuilder.length() > 0, () -> new String[]{" usemap='#TimeBarMap' ><map name='TimeBarMap'>", stringBuilder.toString(), "</map>"}, () -> new String[]{" >"}).toString();
    }

    private void imageMeker(Graphics2D graphics2D, Color color, int n, int n2, int n3, boolean bl, int n4, StringBuilder stringBuilder) {
        if (n3 > 0) {
            boolean bl2;
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2 + this.recodeMargin, n3, this.chartHeight);
            boolean bl3 = bl2 = color != NULL_COLOR && bl && n4 > 0;
            if (bl2) {
                String string;
                String string2;
                String string3 = string2 = this.tipsClmNo >= 0 ? this.getValueLabel(n4 - 1, this.tipsClmNo) : this.getValueLabel(n4 - 1, 2);
                if (string2 != null && string2.indexOf(39) >= 0) {
                    string2 = string2.replaceAll("'", "&#39;");
                }
                string2 = StringUtil.spanCut((String)string2);
                stringBuilder.append("<area shape='rect' alt='").append(string2).append("' title='").append(string2).append('\'');
                if (this.linkClmNo >= 0 && (string = this.getValueLabel(n4 - 1, this.linkClmNo)) != null && string.trim().length() > 0) {
                    stringBuilder.append(' ');
                    int n5 = string.indexOf("href");
                    int n6 = string.indexOf(62);
                    if (n5 >= 0) {
                        if (n6 >= 0) {
                            stringBuilder.append(string.substring(n5, n6));
                        } else {
                            stringBuilder.append(string.substring(n5));
                        }
                    } else {
                        stringBuilder.append(" href='").append(string).append('\'');
                    }
                }
                if (stringBuilder.indexOf("title=") < 0) {
                    string = this.getValueLabel(n4 - 1, 0);
                    stringBuilder.append("' title='").append(string).append('\'');
                }
                stringBuilder.append(" coords='").append(n).append(',').append(n2 + this.recodeMargin).append(',').append(n + n3).append(',').append(n2 + this.recodeMargin + this.chartHeight).append("' >\n");
            }
        } else {
            graphics2D.setColor(color);
            graphics2D.fillRect(n - 1, n2 + this.recodeMargin, 1, this.chartHeight);
        }
    }

    private void paramInit() {
        String string = this.getParam("START_DATE");
        int n = this.getIntParam("TIME_SPAN");
        String[] stringArray = StringUtil.csv2Array((String)this.getParam("LABEL_CLMS"));
        String string2 = this.getParam("COLOR_CLM");
        String string3 = this.getParam("TIPS_CLM");
        String string4 = this.getParam("LINK_CLM");
        this.useLegend = this.getBoolParam("USE_LEGEND");
        this.maxLabelWidth = this.getIntParam("MAX_LABEL_WIDTH");
        this.maxTimeWidth = this.getIntParam("MAX_TIME_WIDTH");
        this.chartHeight = this.getIntParam("CHART_HEIGHT");
        this.headerHeight = this.getIntParam("HEADER_HEIGHT");
        if (this.headerHeight < 0) {
            this.headerHeight = this.chartHeight;
        }
        this.chartPadding = this.getIntParam("CHART_PADDING");
        this.recodeMargin = this.getIntParam("RECODE_MARGIN");
        this.useLastData = this.getBoolParam("USE_LAST_DATA");
        this.isDebug = this.getBoolParam("debug");
        this.tempDir = this.getParam("TEMP_DIR");
        this.tempUrl = this.getParam("TEMP_URL");
        this.headerUpFmt = this.getParam("HEADER_UP_FMT");
        this.headerDwFmt = this.getParam("HEADER_DW_FMT");
        this.startDate = this.getStr2Date(string);
        this.startTime = this.str2DateTime;
        this.timeSpan = (long)n * 60L;
        int n2 = stringArray.length;
        if (n2 > 0) {
            this.labelClmsNo = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.labelClmsNo[i] = this.getColumnNo(stringArray[i]);
            }
        } else {
            this.labelClmsNo = new int[]{0};
        }
        if (string2 != null) {
            this.colClmNo = this.getColumnNo(string2);
        }
        if (string3 != null) {
            this.tipsClmNo = this.getColumnNo(string3);
        }
        if (string4 != null) {
            this.linkClmNo = this.getColumnNo(string4);
        }
        Calendar calendar = Calendar.getInstance();
        this.nowTime = calendar.getTimeInMillis() / 60000L - this.startDate;
    }

    private void calcImageSize(int n, int n2) {
        String string = "";
        int n3 = this.labelClmsNo.length;
        this.maxClmWidth = new int[n3];
        int n4 = 0;
        if (this.maxLabelWidth < 0) {
            String string2;
            int n5;
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (n5 = 0; n5 < n3; ++n5) {
                string2 = StringUtil.spanCut((String)this.getColumnLabel(this.labelClmsNo[n5]));
                String[] stringArray = string2.split("\\n|\\\\n");
                if (stringArray.length > 1) {
                    this.useCR = true;
                    for (String string3 : stringArray) {
                        int n6 = fontMetrics.stringWidth(string3);
                        if (this.maxClmWidth[n5] >= n6) continue;
                        this.maxClmWidth[n5] = n6;
                    }
                    continue;
                }
                this.maxClmWidth[n5] = fontMetrics.stringWidth(string2);
            }
            for (n5 = n; n5 < n2; ++n5) {
                string2 = this.getValue(n5, 0);
                if (string.equals(string2)) continue;
                string = string2;
                ++n4;
                for (int i = 0; i < n3; ++i) {
                    String string4 = StringUtil.spanCut((String)this.getValueLabel(n5, this.labelClmsNo[i]));
                    String[] stringArray = string4.split("\\n|\\\\n");
                    if (stringArray.length > 1) {
                        this.useCR = true;
                        for (String string5 : stringArray) {
                            int n7 = fontMetrics.stringWidth(string5);
                            if (this.maxClmWidth[i] >= n7) continue;
                            this.maxClmWidth[i] = n7;
                        }
                        continue;
                    }
                    int n8 = fontMetrics.stringWidth(string4);
                    if (this.maxClmWidth[i] >= n8) continue;
                    this.maxClmWidth[i] = n8;
                }
            }
            graphics2D.dispose();
            this.maxLabelWidth = this.recodeMargin * 2 * n3;
            for (n5 = 0; n5 < n3; ++n5) {
                this.maxLabelWidth += this.maxClmWidth[n5];
            }
        } else {
            int n9;
            for (n9 = n; n9 < n2; ++n9) {
                String string6 = this.getValue(n9, 0);
                if (string.equals(string6)) continue;
                string = string6;
                ++n4;
            }
            n9 = (this.maxLabelWidth - this.recodeMargin * 2 * n3) / n3;
            for (int i = 0; i < n3; ++i) {
                this.maxClmWidth[i] = n9;
            }
        }
        this.maxX = this.chartPadding * 2 + this.maxLabelWidth + this.maxTimeWidth;
        this.maxY = this.chartPadding * 2 + (this.headerHeight + this.recodeMargin * 2) * (this.useLegend ? 2 : 1) + (this.chartHeight + this.recodeMargin * 2) * n4;
    }

    private void imageHeaderPaint(Graphics2D graphics2D, double d, FlgColorMap flgColorMap) {
        String string;
        int n;
        int n2;
        int n3;
        int n4 = this.chartPadding;
        int n5 = this.chartPadding + this.headerHeight + this.recodeMargin;
        if (this.useLegend && flgColorMap != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            n3 = fontMetrics.stringWidth(flgColorMap.getMaxLengthLabel());
            n2 = this.headerHeight;
            int n6 = this.recodeMargin;
            int n7 = n3 + this.recodeMargin;
            n = this.chartPadding;
            for (FlgColorObj object2 : flgColorMap.values()) {
                graphics2D.setColor(object2.COL);
                graphics2D.fillRect(n, n4 + this.recodeMargin, n2, this.headerHeight);
                graphics2D.setColor(LABEL_COLOR);
                graphics2D.drawString(object2.LBL, n += n2 + n6, n5);
                n += n7;
            }
            n4 += this.headerHeight + this.recodeMargin * 2;
            n5 += this.headerHeight + this.recodeMargin * 2;
        }
        graphics2D.setColor(LABEL_COLOR);
        graphics2D.drawRect(this.chartPadding, n4, this.maxX - this.chartPadding * 2, this.maxY - n4 - this.chartPadding);
        int n8 = this.labelClmsNo.length;
        n3 = this.chartPadding;
        for (n2 = 0; n2 < n8; ++n2) {
            String string2 = StringUtil.spanCut((String)this.getColumnLabel(this.labelClmsNo[n2]));
            if (this.useCR) {
                String[] stringArray = string2.split("\\n|\\\\n");
                for (n = 0; n < stringArray.length; ++n) {
                    int n9 = n5 - (stringArray.length - 1 - n) * this.headerHeight / stringArray.length;
                    graphics2D.drawString(stringArray[n], n3 + this.recodeMargin, n9);
                }
            } else {
                graphics2D.drawString(string2, n3 + this.recodeMargin, n5);
            }
            graphics2D.drawLine(n3 += this.recodeMargin * 2 + this.maxClmWidth[n2], n4, n3, this.maxY - this.chartPadding);
        }
        n2 = TimeScaleStep.getStep(d);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.startDate * 60000L);
        String string2 = this.headerUpFmt != null ? this.headerUpFmt : (string = n2 >= 1440 ? "M\u6708" : "M/d(EE)");
        String string4 = this.headerDwFmt != null ? this.headerDwFmt : (n2 >= 1440 ? "dEE" : "H:mm");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string4, Locale.JAPAN);
        graphics2D.setStroke(DSAH_STROK);
        n3 = this.chartPadding + this.maxLabelWidth;
        int n6 = -1;
        int n7 = 0;
        while ((long)n7 < this.timeSpan) {
            int n9;
            int n10 = this.headerHeight / 2 + this.recodeMargin;
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis((this.startDate + (long)n7) * 60000L);
            int n11 = n9 = n2 >= 1440 ? calendar2.get(2) : calendar2.get(5);
            if (n6 != n9) {
                n6 = n9;
                graphics2D.drawString(simpleDateFormat.format(calendar2.getTime()), n3 + this.recodeMargin, n5 - n10);
                n10 = 0;
            }
            graphics2D.drawString(simpleDateFormat2.format(calendar2.getTime()), n3 + this.recodeMargin, n5);
            graphics2D.drawLine(n3, n4 + n10, n3, this.maxY - this.chartPadding);
            n3 += (int)((double)n2 * d);
            n7 += n2;
        }
    }

    private long getStr2Date(String string) {
        Calendar calendar = Calendar.getInstance();
        this.str2DateTime = 0;
        if (string == null) {
            calendar.set(11, 0);
            calendar.clear(12);
            calendar.clear(13);
            calendar.clear(14);
        } else if (string.length() == 8) {
            calendar.clear();
            calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)));
        } else {
            calendar.clear();
            calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)));
            this.str2DateTime = Integer.parseInt(string.substring(8, 10)) * 60 + Integer.parseInt(string.substring(10, 12));
        }
        return calendar.getTimeInMillis() / 60000L;
    }

    private String getTime2Str(int n) {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n2 = n / 60 % 24;
        stringBuilder.append(n2);
        int n3 = n % 60;
        stringBuilder.append(':');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    public boolean isEditable() {
        return false;
    }

    private static final class FlgColorObj {
        private final String LBL;
        private final Color COL;

        FlgColorObj(String string, Color color) {
            this.LBL = string;
            this.COL = color;
        }

        FlgColorObj(String string, String string2) {
            this.LBL = string;
            this.COL = ColorMap.getColorInstance((String)string2);
        }

        FlgColorObj(String string, int n) {
            this.LBL = string;
            this.COL = ColorMap.getColorInstance((int)n);
        }

        String getLabel() {
            return this.LBL;
        }

        Color getColor() {
            return this.COL;
        }
    }

    private static final class FlgColorMap {
        private final Map<String, FlgColorObj> colMap = new TreeMap<String, FlgColorObj>();
        private int lastCnt;
        private String maxLabel = "";
        private int maxlen = -1;

        private FlgColorMap() {
        }

        public Color getColor(String string, String string2) {
            return this.getColor(string, string2, null);
        }

        public Color getColor(String string, String string2, String string3) {
            Color color;
            if (string == null) {
                color = LABEL_COLOR;
            } else {
                int n;
                if (string2 != null && (n = string2.length()) > this.maxlen) {
                    this.maxLabel = string2;
                    this.maxlen = n;
                }
                String string4 = string3 == null ? String.valueOf(this.lastCnt++) : string3;
                color = this.colMap.computeIfAbsent((String)string, (Function<String, FlgColorObj>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getColor$0(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;)Lorg/opengion/plugin/view/ViewForm_ImageTimeBar$FlgColorObj;)((String)string2, (String)string4)).COL;
            }
            return color;
        }

        public Collection<FlgColorObj> values() {
            return this.colMap.values();
        }

        public String getMaxLengthLabel() {
            return this.maxLabel;
        }

        private static /* synthetic */ FlgColorObj lambda$getColor$0(String string, String string2, String string3) {
            return new FlgColorObj(string, string2);
        }
    }

    private static final class TimeScaleStep {
        private static final int[] STEPS = new int[]{10, 30, 60, 360, 720, 1440};
        private static final int MIN_PX = 25;

        private TimeScaleStep() {
        }

        public static int getStep(double d) {
            int n = (int)Math.ceil(25.0 / d);
            for (int i = 0; i < STEPS.length; ++i) {
                if (n > STEPS[i]) continue;
                return STEPS[i];
            }
            return (int)Math.ceil((double)n / (double)STEPS[STEPS.length - 1]) * STEPS[STEPS.length - 1];
        }
    }
}

