<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL03"
	title	= "送信履歴検索"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
>
	5.6.8.0 (2013/09/06) order by 変更
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck
	command   = "{@command}"
	columns   = "DYSET_FROM,DYSET_TO"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	 FGJ FGJ_SEND
				,SYSTEM_ID
				,A.PTN_ID
				,A.YKNO
				,A.FROM_ADDR
				,A.TITLE MAIL_TITLE
				,A.CONTENTS
				,A.ATTACH1
				,A.ATTACH2
				,A.ATTACH3
				,A.ATTACH4
				,A.ATTACH5
				,PARA_KEY
				,DYSET
				,USRSET
				,DYUPD
				,USRUPD
				,PGUPD
				,A.UNIQ
		FROM	GE32 A
	<og:where>
		<og:and value = "A.SYSTEM_ID		= '{@SYSTEM_ID}'"	 	/>
		<og:and value = "A.PTN_ID		= '{@PTN_ID}'"			 	/>
		<og:and value = "A.PARA_KEY		= '{@PARA_KEY}'"	 	/>
		<og:and value = "A.FROM_ADDR		LIKE '{@FROM_ADDR}'"	/>
		<og:and value = "A.TITLE			LIKE '%{@MAIL_TITLE}'"	/>
		<og:and value = "COALESCE(A.FGJ,'0')	!= '9'"				 	/>
		<og:and value = "A.DYSET			&gt; '{@DYSET_FROM}000000'"	/>
		<og:and value = "A.DYSET			&lt; '{@DYSET_TO}999999'"  	/>
		<og:and value = "exists (select 'X' from GE34 B where B.YKNO=A.YKNO and B.FGJ = '{@FGJ_SEND}')"  />
	</og:where>
		order by A.YKNO DESC,A.UNIQ DESC
</og:query>

<og:columnEditor column="CONTENTS"    must="true" renderer="SLABEL" size="40" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<og:viewLink command="{@command}">
    <og:link href="showDetails.jsp" column="MAIL_TITLE" keys="command,YKNO,SYSTEM_ID" vals="NEW,[YKNO],[SYSTEM_ID]" />
</og:viewLink>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ"
	writable     = "false"
/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
