package org.opengion.fukurou.queue;

import javax.jms.MessageListener;

/**
 * キュー受信クラス用インタフェース
 * キュー受信処理のインタフェースです。
 * MQとSQSのメッセージ受信に対応しています。
 *
 * @og.group メッセージ連携
 *
 * @og.rev 5.10.15.2 (2019/09/20) 新規作成
 * 
 * @version 5
 * @author oota
 * @since JDK7
 */
public interface QueueReceive {
	
	/**
	 * 接続処理
	 * メッセージキューサーバに接続します。
	 * 
	 *  @param jmsServer jsmサーバ
	 *  @param sqsAccessKey sqs用awsアクセスキー
	 *  @param sqsSecretKey sqs用awsシークレットキー
	 */
	public void connect(final String jmsServer, final String sqsAccessKey, final String sqsSecretKey);
	
	/**
	 * 受信処理
	 * 受信処理を行います。
	 * 
	 * @param queueName キュー名
	 * @return キュー情報格納クラス
	 */
	public QueueInfo receive(final String queueName);
	
	/**
	 * リスナーの設定
	 * 指定キュー名に対して、
	 * メッセージキュー受信時に処理を行う、
	 * メッセージリスナーを設定します。
	 * 
	 * @param queueName キュー名
	 * @param listener メッセージリスナー
	 */
	public void setListener(final String queueName, MessageListener listener);

	/**
	 * リスナーの終了
	 * リスナーの終了処理を行います。
	 */
	public void closeListener();
	
	/**
	 * クローズ処理
	 * MQ:受信リスナーの解除。
	 * SQS:クローズ処理はありません。
	 */
	public void close();
	
	/**
	 * バッチフラグの設定
	 * バッチ処理として行う用の、
	 * バッチフラグを設定します。
	 * 
	 * @param batchFlg バッチフラグ
	 */
	public void setBatchFlg(final Boolean batchFlg);
}
