package org.opengion.fukurou.queue;

import java.util.Locale;

import org.opengion.fukurou.util.StringUtil;

/**
 * キュータイプ別の受信クラス生成
 * 指定されたキュータイプの受信クラスを生成します。
 * 
 * 下記のキュータイプを指定可能です。
 * MQ：Active MQ or Amazon MQ
 * SQS：Amazon SQS。
 *
 * @og.group メッセージ連携
 *
 * @og.rev 5.10.15.2 (2019/09/20) 新規作成
 * 
 * @version 5
 * @author oota
 * @since JDK7
 * 
 */
final public class QueueReceiveFactory {
	private static final int BUFFER_MIDDLE = 200;

	/**
	 * デフォルトコンストラクター
	 * static用クラスのため、クラス生成は不可にします。
	 */
	private QueueReceiveFactory() {
	}

	/**
	 * キュー受信クラス生成
	 * 
	 * 引数のキュータイプのキュー受信クラスを生成します。
	 * MQ：Apache ActiveMq、amazonMQの場合に設定します。
	 * SQS：Amazon SQSの場合に設定します。
	 * 
	 * @param queueType キュータイプ
	 * @return キュータイプのキュー受信クラス
	 */
	public static QueueReceive newQueueReceive(final String queueType) {
		QueueReceive queueReceive = null;
		String setQueueType = null;

		final StringBuilder path = new StringBuilder(BUFFER_MIDDLE);

		// 1. 前処理
		// 大文字変換
		if (!StringUtil.isNull(queueType)) {
			setQueueType = queueType.toUpperCase(Locale.JAPAN);
		}

		// 2. 生成クラスの文字列生成
		path.append("org.opengion.fukurou.queue.");
		path.append("QueueReceive_");
		path.append(setQueueType);

		try {
			// 3. 対象クラスの生成
//			queueReceive = (QueueReceive) Class.forName(path.toString()).newInstance();
			queueReceive = (QueueReceive) Class.forName(path.toString()).getDeclaredConstructor().newInstance();
		} catch (final Throwable th) {
			// キャッチしたエラー情報をスロー
			throw new RuntimeException(th);
		}

		return queueReceive;
	}
}
