/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * スタックガントチャート(テーブル形式)表示クラス用のパラメータ定数定義クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public static final で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.rev 5.5.7.0 (2012/10/01) 新規作成
 * @og.rev 5.5.8.1 (2012/11/17) 追加
 * @og.rev 5.5.9.0 (2012/12/03) STACK_CAL_KEY削除
 * @og.rev 5.6.1.2 (2013/02/22) 能力値関係追加
 * @og.group その他
 *
 * @version  5.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public final class ViewStackTableParam {

	/** 積上単位とするカラム名(CSV形式)をセットするキー {@value} */
	public static final String STACK_COLUMNS_KEY	= "h_stackColumns" ;
	/** 工数関係のカラム（工数,開始日,終了日）を指定するキー {@value} */
	public static final String COST_COLUMNS_KEY		= "h_costColumn" ;		// 5.5.8.3 (2012/11/17)
	/** エンジン内部で積上げするかどうかを指定するキー {@value} */
	public static final String INNER_STACK_KEY		= "h_innerStack" ;		// 5.5.8.3 (2012/11/17)
	/** エンジン内部で積上げする場合に休日も積上げるかどうかを指定するキー {@value} */
	public static final String STACK_HOLIDAY_KEY	= "h_stackHoliday";		// 5.5.8.3 (2012/11/17)
	/** 行の能力値カラムを指定するキー {@value} */
	public static final String CAP_COLUMN_KEY		= "h_capColumn" ;		// 5.6.1.2 (2013/02/22)

	/** パラメータ初期値:{@value} */
	public static final String STACK_COLUMNS_VALUE	= "" ;
	/** パラメータ初期値:{@value} */
	public static final String COST_COLUMNS_VALUE	= "" ;			// 5.5.8.2. (2012/11/17)
	/** パラメータ初期値:{@value} */
	public static final String INNER_STACK_VALUE	= "false" ;		// 5.5.8.3 (2012/11/17)
	/** パラメータ初期値:{@value} */
	public static final String STACK_HOLIDAY_VALUE	= "true" ;		// 5.5.8.3 (2012/11/17)
	/** パラメータ初期値:{@value} */
	public static final String CAP_COLUMN_VALUE		= ""  ;			// 5.6.1.2 (2013/02/22)

	/** Zoom設定値:{@value} */
	public static final String STACK_ZOOM_MONTH		= "MONTH" ;
	/** Zoom設定値:{@value} */
	public static final String STACK_ZOOM_WEEK		= "WEEK" ;
	/** Zoom設定値:{@value} */
	public static final String STACK_ZOOM_DAY		= "DAY" ;

	/**
	 * デフォルトコンストラクター
	 * 定数クラスなので、オブジェクトを生成できないように、private にしておきます。
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	private ViewStackTableParam() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
}
