/**
 * <pre>
 * はやぶさのタグライブラリー関係のクラスを提供します。
 * 
 * カスタムタグ &lt;og.tagname ･･･ /&gt; では、リクエスト変数を
 * {&#064;XXXX}で取り出すことが出来ます。
 * また、特別なシステム定義の変数を使用して、各種情報を
 * 取得することが可能です。
 * </pre>
 * 
 * <table class="plain">
 * <caption>タグライブラリー関係のクラス</caption>
 * <tr><th>キー</th><th>値(意味)</th></tr>
 * <tr><td>{&#064;SYS.XXXX}			</td><td>XXXX に、SystemResource.proparty で定義した値を取得できます。</td></tr>
 * <tr><td>{&#064;SYS.SERVER_NAME}	</td><td>このTomcatが実行しているサーバー名 （例：localhost 等）</td></tr>
 * <tr><td>{&#064;SYS.SERVER_URL}	</td><td>Portも含むURLアドレス （例：http://localhost:8823/ 等）</td></tr>
 * <tr><td>{&#064;SYS.CONTEXT_URL}	</td><td>実行しているコンテキストのURLアドレス （例：http://localhost:8823/dbdef2/ 等）</td></tr>
 * <tr><td>{&#064;SYS.REAL_PATH}	</td><td>URL の /（ルート）に対応する物理ディレクトリを取得できます。 （例：d:/webapps/dbdef2/ 等）</td></tr>
 * <tr><td>{&#064;SYS.CONTEXT_NAME}	</td><td>ドキュメントルートのコンテキスト名（仮想アドレス）を取得できます。 （例：dbdef 等）</td></tr>
 * <tr><td>{&#064;SYS.DATE}			</td><td>SystemResource.properties の SYS_TIME で設定された日付けフォーマットで現在時刻を取得できます。yyyy/MM/dd HH:mm:ss</td></tr>
 * <tr><td>{&#064;USER.XXXX}		</td><td>XXXX に、UserInfo で定義されている値、および、独自に設定した共有データを取得できます。</td></tr>
 * <tr><td>{&#064;USER.JNAME}		</td><td>ユーザー日本語名称</td></tr>
 * <tr><td>{&#064;USER.ID}			</td><td>ユーザーＩＤ</td></tr>
 * <tr><td>{&#064;USER.IDNO}		</td><td>USER.IDが５Byte以上の時のみ先頭１文字を除いたユーザーＩＤ</td></tr>
 * <tr><td>{&#064;USER.INFO}		</td><td>ユーザー情報（ユーザーID：日本語名称）</td></tr>
 * <tr><td>{&#064;USER.LANG}		</td><td>言語</td></tr>
 * <tr><td>{&#064;USER.ROLE}		</td><td>ロール</td></tr>
 * <tr><td>{&#064;USER.IPADDRESS}	</td><td>IPアドレス</td></tr>
 * <tr><td>{&#064;USER.LOGINTIME}	</td><td>ログイン時刻</td></tr>
 * <tr><td>{&#064;USER.YMD}			</td><td>８byteの今日のシステム日付</td></tr>
 * <tr><td>{&#064;USER.YMDH}		</td><td>１４byteの今日のシステム日時</td></tr>
 * <tr><td>{&#064;GUI.XXXX}			</td><td>XXXX に、GUIInfo で定義されている値、および、実際にアクセスしている画面情報を取得できます。</td></tr>
 * <tr><td>{&#064;GUI.KEY}			</td><td>画面ID</td></tr>
 * <tr><td>{&#064;GUI.ADDRESS}		</td><td>実行アドレス</td></tr>
 * <tr><td>{&#064;GUI.REALADDRESS}	</td><td>実行実アドレス</td></tr>
 * <tr><td>{&#064;GUI.SEQUENCE}		</td><td>表示順</td></tr>
 * <tr><td>{&#064;GUI.CLASSIFY}		</td><td>メニュ分類</td></tr>
 * <tr><td>{&#064;GUI.NAME}			</td><td>画面名称</td></tr>
 * <tr><td>{&#064;GUI.LONGNAME}		</td><td>画面名称(long)</td></tr>
 * <tr><td>{&#064;GUI.ROLE}			</td><td>ロール</td></tr>
 * <tr><td>{&#064;GUI.MODE}			</td><td>アクセスモード 'rwrwrwrw'</td></tr>
 * <tr><td>{&#064;GUI.TARGET}		</td><td>ターゲット</td></tr>
 * <tr><td>{&#064;GUI.KBLINK}		</td><td>リンク区分</td></tr>
 * <tr><td>{&#064;GUI.COMMENTS}		</td><td>コメント</td></tr>
 * <tr><td>{&#064;DB.COUNT}			</td><td>クエリー実行後の検索結果の件数</td></tr>
 * <tr><td>{&#064;DB.ERR_CODE}		</td><td>クエリー実行後の検索結果のエラーコード</td></tr>
 * </table>
 * 
 */
package org.opengion.hayabusa.taglib;
