<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6460"
	title	= "標準偏差"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="0" stopZero="true">
			SELECT 	 DEPTNO							<!-- 営業担当者 -->
					,ENAME
					,JOB
					,SAL
					,MGR
					,COMM
					,SAL	AS S_MIN
					,SAL	AS S_MAX
					,SAL	AS AVG
					,1		AS CNT
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
			order by DEPTNO
</og:query>

<og:tableFilter classId="STDDEV" selectedAll="true" caseKey="{@filter}" caseVal="STDDEV"
	keys="GROUP_KEY,VAL_KEY"
	vals="DEPTNO,SAL"
/>

<og:tableFilter classId="KEY_BREAK" selectedAll="true" caseKey="{@filter}" caseVal="KEY_BREAK"
	keys="GROUP_KEY,OUT_TYPE,MIN_CLM,MAX_CLM,AVG_CLM,CNT_CLM"
	vals="DEPTNO,{@OUT_TYPE},S_MIN,S_MAX,AVG,CNT"
/>

	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
