<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result"  useChartJS="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7301"
	title	= "横棒／縦棒グラフ"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="NEW" stopZero="{@stopZero}">
	SELECT 	 ENAME										<!-- 営業担当者 -->
			,ROUND( SAL / 2   * DBMS_RANDOM.VALUE ) as SAL1		<!-- 売上( 1月) -->
			,ROUND( SAL / 2.5 * DBMS_RANDOM.VALUE ) as SAL2		<!-- 売上( 2月) -->
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
</og:query>

<canvas id="mycanvas" height="400" width="400"><!-- --></canvas>

<script type="text/javascript">
		// https://beiznotes.org/data-label-on-chart-js/
		// Define a plugin to provide data labels
		Chart.plugins.register({
			afterDatasetsDraw: function(chart) {
				var ctx = document.getElementById('mycanvas').getContext('2d');
		//		var ctx = chart.ctx;

				// Draw the text in black, with the specified font
				ctx.fillStyle = 'rgb(0, 0, 0)';
				var fontSize   = 12;
				var fontStyle  = 'normal';
				var fontFamily = 'Helvetica Neue';
				ctx.font = Chart.helpers.fontString(fontSize, fontStyle, fontFamily);

				// Make sure alignment settings are correct
				ctx.textAlign    = 'center';
	//			ctx.textBaseline = 'middle';
				ctx.textBaseline = 'bottom';

				var padding = 2;
	//			var lblOffset = (fontSize / 2) + padding + fontSize
	//			var valOffset = (fontSize / 2) + padding
				var lblOffset =  padding + fontSize;
				var valOffset =  padding;

				chart.data.datasets.forEach(function(dataset, i) {
//if( i==0 ) { // 例：グラフ番号=0を指定
					var meta = chart.getDatasetMeta(i);
					if (!meta.hidden) {
						meta.data.forEach( function(element, index) {
//if( index % 2 == 0 ) {	// 例：データの間引き
							// Just naively convert to string for now
							var dataString  = dataset.data[index].toString();		// 値の表示
							var labelString = chart.data.labels[index];				// ﾗﾍﾞﾙの表示

							var position = element.tooltipPosition();
							ctx.fillText(labelString, position.x, position.y - lblOffset );		// ﾗﾍﾞﾙ
							ctx.fillText(dataString , position.x, position.y - valOffset );		// 値
//}
						});
					}
//}
				});
			}
		});
</script>

<script type="text/javascript">
	// jsonで取得
	var querydata =
	<og:view
		viewFormType	= "JSON"
		command			= "NEW"
		useHilightRow	= "false"
		useAfterHtmlTag	= "false"
		useConsistency	= "false"
		pageSize		= "0" />
	;

	var datadata1   = [];
	var datadata2   = [];
	var datalabels = [];
	for(var i=0; i&lt; querydata.DATA.length; i++){
		datadata1[i]  = querydata.DATA[i].SAL1;
		datadata2[i]  = querydata.DATA[i].SAL2;
		datalabels[i] = querydata.DATA[i].ENAME;
	}

	var chartdata = {
		labels: datalabels,
		datasets: [{
			label: 'SAL1',		//凡例
			fill: false,		//面の表示
			lineTension: 0.5,		//線のカーブ
			data: datadata1,		
			backgroundColor: 	'rgba(255, 99, 132, 0.2)',
			borderColor:		'rgba(255,99,132,1)',
			borderWidth: 1
		},{
			label: 'SAL2',		//凡例
			fill: false,		//面の表示
			lineTension: 0.5,		//線のカーブ
			data: datadata2,		
			backgroundColor: [ "#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56" ],
			borderColor:		'rgba(75,192,192,1)',
			borderWidth: 1
		}]
	};

	<og:text>
	var myChart = new Chart( mycanvas,{
					type: '{@chartType}',
					data: chartdata,
					options: {
					    responsive: false ,
						animation : false			// false にしないと、Chart.plugins.register で、２回呼ばれる。
					}
				});
	</og:text>
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
