/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* TEST11P ( PACKAGE BODY )                                                 */
/* Created : 2018/09/28 16:03:33                                            */
/****************************************************************************/

CREATE 
PACKAGE BODY TEST11P AS
	PROCEDURE TEST11 (
		PO_STATUS    OUT NUMBER ,
		PO_ERR_CODE  OUT VARCHAR2 ,
		PI_PRGID     IN  VARCHAR2 ,
		PI_YKNO      IN  NUMBER
	)
IS
	-- このサンプルでは、WKGE52_XIN と WKGE54_XIN テーブルについて
	-- 処理を行います。
	-- 具体的には、RELEASE_NOTES に、EXCELIN という文字列をセットします。
	-- わざわざ、１件ずつ処理するのは、サンプルだからです。:)

	CURSOR WKGE52 IS
		SELECT GESYSTEM_ID,GEYKNO,GESHEETNO,GEEDNO,RELEASE_NOTES,ROWID
			FROM WKGE52_XIN
			WHERE GEYKNO = PI_YKNO
			ORDER BY GESHEETNO,GEEDNO ;

	WKGE52REC WKGE52%ROWTYPE;

	CURSOR WKGE54 IS
		SELECT GESYSTEM_ID,GEYKNO,GESHEETNO,GEEDNO,RELEASE_NOTES,ROWID
			FROM WKGE54_XIN
			WHERE GEYKNO = PI_YKNO
			ORDER BY GESHEETNO,GEEDNO ;

	WKGE54REC WKGE54%ROWTYPE;

BEGIN
	PO_STATUS := 2;	-- 初期設定(エラー)

	OPEN	WKGE52;
	LOOP
		FETCH WKGE52 INTO WKGE52REC;
		EXIT WHEN WKGE52%NOTFOUND;

		UPDATE WKGE52_XIN SET RELEASE_NOTES = 'EXCELIN' WHERE ROWID = WKGE52REC.ROWID ;
	END LOOP;
	CLOSE WKGE52;

	OPEN	WKGE54;
	LOOP
		FETCH WKGE54 INTO WKGE54REC;
		EXIT WHEN WKGE54%NOTFOUND;

		UPDATE WKGE54_XIN SET RELEASE_NOTES = 'EXCELIN' WHERE ROWID = WKGE54REC.ROWID ;
	END LOOP;
	CLOSE WKGE54;

--	COMMIT;		呼び出し元で行います。
	PO_STATUS := 0;	-- 正常終了

EXCEPTION
	WHEN OTHERS THEN
--		ROLLBACK;		呼び出し元で行います。
		PO_STATUS := 2;
		PO_ERR_CODE	:= 'PGID=' || PI_PRGID || ' YKNO=' || PI_YKNO || ' ERR=' || TO_CHAR(SQLCODE) ;

END TEST11;
END TEST11P;
;
