/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.opengion.fukurou.model.POIUtil;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.taglib.QueryTag;

public class FileQueryTag
extends QueryTag {
    private static final String VERSION = "7.1.0.0 (2020/01/20)";
    private static final long serialVersionUID = 710020200120L;
    private static final ArraySet<String> SELECT_SET = new ArraySet((Object[])new String[]{"LEVEL", "FILE_TYPE", "PARENT", "NAME", "LASTMODIFIED", "FILE_LENGTH", "RWH"});
    private static final String[] USE_UPDATE_CLM = new String[]{"TO_PARENT", "TO_NAME"};
    private transient FileFilter filter;
    private boolean multi;
    private int level = 100;
    private String from = HybsSystem.sys("FILE_URL");
    private String orderBy;
    private boolean desc;
    private String[] addClms = new String[0];
    private String[] defClms;
    private String fileType;
    private boolean useWritable;
    private boolean useMD5;
    private boolean useText;
    private boolean useUpdateClms;
    private boolean addFrom = true;
    private int fromLen = -1;

    @Override
    public int doAfterBody() {
        return 0;
    }

    @Override
    public int doEndTag() {
        File file;
        if (!this.useTag()) {
            return 0;
        }
        this.executeCount = 0;
        this.table = this.initDBTable();
        if (this.maxRowCount < 0) {
            this.maxRowCount = this.sysInt("DB_MAX_ROW_COUNT");
        }
        if ((file = new File(this.from)).exists()) {
            this.execute(file, 0);
            if (this.orderBy != null) {
                int n = this.table.getColumnNo(this.orderBy);
                DBTableModelSorter dBTableModelSorter = new DBTableModelSorter();
                dBTableModelSorter.setModel(this.table);
                dBTableModelSorter.sortByColumn(n, !this.desc);
                this.table = dBTableModelSorter;
            }
        }
        return super.doEndTag();
    }

    @Override
    protected void release2() {
        super.release2();
        this.filter = null;
        this.multi = false;
        this.level = 100;
        this.from = HybsSystem.sys("FILE_URL");
        this.orderBy = null;
        this.desc = false;
        this.addClms = new String[0];
        this.defClms = null;
        this.fileType = null;
        this.useWritable = false;
        this.useMD5 = false;
        this.useText = false;
        this.useUpdateClms = false;
        this.addFrom = true;
        this.fromLen = -1;
    }

    protected void execute(File file, int n) {
        File[] fileArray;
        if (!this.multi && n > 1 || n > this.level) {
            return;
        }
        if (this.executeCount > this.maxRowCount) {
            this.table.setOverflow(true);
            return;
        }
        boolean bl = file.isDirectory();
        if ((this.fileType == null || bl && "DIR".equalsIgnoreCase(this.fileType) || !bl && "FILE".equalsIgnoreCase(this.fileType)) && (this.addFrom || n > 0)) {
            this.addFileData(this.executeCount++, n, file);
        }
        if (bl && (fileArray = file.listFiles(this.filter)) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.execute(fileArray[i], n + 1);
            }
        }
    }

    private DBTableModel initDBTable() {
        DBColumn dBColumn;
        DBColumn dBColumn2;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        int n2 = SELECT_SET.size();
        if (this.useWritable) {
            ++n2;
        }
        if (this.useMD5) {
            ++n2;
        }
        if (this.useText) {
            ++n2;
        }
        if (this.useUpdateClms) {
            n2 += USE_UPDATE_CLM.length;
        }
        dBTableModel.init(n2 += this.addClms.length);
        this.defClms = new String[n2];
        int n3 = 0;
        if (this.useWritable) {
            dBColumn2 = this.getDBColumn("WRITABLE");
            this.defClms[n3] = "1";
            dBTableModel.setDBColumn(n3++, dBColumn2);
        }
        SELECT_SET.forEach(n3, (n, string) -> {
            DBColumn dBColumn = this.getDBColumn((String)string);
            dBTableModel.setDBColumn((int)n, dBColumn);
        });
        n3 += SELECT_SET.size();
        if (this.useMD5) {
            dBColumn2 = this.getDBColumn("MD5");
            this.defClms[n3] = "";
            dBTableModel.setDBColumn(n3++, dBColumn2);
        }
        if (this.useText) {
            dBColumn2 = this.getDBColumn("TEXT");
            this.defClms[n3] = "";
            dBTableModel.setDBColumn(n3++, dBColumn2);
        }
        if (this.useUpdateClms) {
            for (int i = 0; i < USE_UPDATE_CLM.length; ++i) {
                dBColumn = this.getDBColumn(USE_UPDATE_CLM[i]);
                this.defClms[n3] = dBColumn.getDefault();
                dBTableModel.setDBColumn(n3++, dBColumn);
            }
        }
        for (int i = 0; i < this.addClms.length; ++i) {
            dBColumn = this.getDBColumn(this.addClms[i]);
            this.defClms[n3] = dBColumn.getDefault();
            dBTableModel.setDBColumn(n3++, dBColumn);
        }
        return dBTableModel;
    }

    private void addFileData(int n, int n2, File file) {
        try {
            File file2 = file.getCanonicalFile();
            String string = (file2.canRead() ? "r" : "-") + (file2.canWrite() ? "w" : "-") + (file2.isHidden() ? "h" : "-");
            String string2 = DateSet.getDate((long)file2.lastModified(), (String)"yyyyMMddHHmmss");
            boolean bl = file2.isFile();
            int n3 = this.table.getColumnCount();
            String[] stringArray = Arrays.copyOf(this.defClms, n3);
            int n4 = 0;
            if (this.useWritable) {
                // empty if block
            }
            int n5 = ++n4;
            stringArray[n5] = String.valueOf(n2);
            int n6 = ++n4;
            ++n4;
            stringArray[n6] = bl ? "F" : "D";
            String string3 = file2.getParent();
            stringArray[n4++] = this.fromLen > 0 ? (string3.length() < this.fromLen ? "" : string3.substring(this.fromLen)) : string3;
            stringArray[n4++] = file2.getName();
            stringArray[n4++] = string2;
            stringArray[n4++] = String.valueOf(FileUtil.length((File)file2));
            stringArray[n4++] = string;
            if (this.useMD5 && bl) {
                stringArray[n4++] = HybsCryptography.getMD5((File)file2);
            }
            if (this.useText && bl) {
                String string4 = FileInfo.getSUFIX((File)file2);
                String string5 = "";
                try {
                    string5 = POIUtil.isPOI((File)file2) ? POIUtil.extractor((File)file2) : ("txt,jsp,java,xml,css,js".contains(string4) ? POIUtil.extractor((File)file2, (String)"UTF-8") : POIUtil.extractor((File)file2, (String)"Windows-31J"));
                }
                catch (RuntimeException runtimeException) {
                    String string6 = "\u30d5\u30a1\u30a4\u30eb\u306e\u30c6\u30ad\u30b9\u30c8\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + file + "] ROW=[" + n + "]" + CR + runtimeException.getMessage();
                    System.err.println(string6);
                }
                stringArray[n4++] = string5;
            }
            this.table.addColumnValues(stringArray);
        }
        catch (IOException iOException) {
            String string = "\u6b63\u5f0f\u306a\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + file + "] ROW=[" + n + "]" + CR + iOException.getMessage();
            throw new HybsSystemException(string, iOException);
        }
    }

    public void setFrom(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.from = HybsSystem.url2dir(this.from, string2, ".");
    }

    public void setMulti(String string) {
        this.multi = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.multi);
    }

    public void setLevel(String string) {
        this.level = StringUtil.nval((String)this.getRequestParameter(string), (int)this.level);
    }

    public void setOrderBy(String string) {
        this.orderBy = StringUtil.nval((String)this.getRequestParameter(string), (String)this.orderBy);
        if (this.orderBy != null && !this.check(this.orderBy, (Set<String>)SELECT_SET)) {
            String string2 = "\u6307\u5b9a\u306e orderBy \u306f\u3001\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "orderBy=[" + this.orderBy + "] " + CR + "orderByList=" + String.join((CharSequence)", ", SELECT_SET);
            throw new HybsSystemException(string2);
        }
    }

    public void setDesc(String string) {
        this.desc = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.desc);
    }

    public void setUseWritable(String string) {
        this.useWritable = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useWritable);
    }

    public void setUseMD5(String string) {
        this.useMD5 = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMD5);
    }

    public void setUseText(String string) {
        this.useText = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useText);
    }

    public void setUseUpdateClms(String string) {
        this.useUpdateClms = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useUpdateClms);
    }

    public void setAddClms(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null && string2.length() > 0) {
            this.addClms = StringUtil.csv2Array((String)string2);
        }
    }

    public void setFileType(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fileType);
        if (string2 != null && !"DIR".equalsIgnoreCase(string2) && !"FILE".equalsIgnoreCase(string2)) {
            String string3 = "\u3053\u306e\u3001fileType \u5c5e\u6027\u306b\u306f\u3001DIR,FILE \u4ee5\u5916\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002[" + string2 + "]";
            throw new HybsSystemException(string3);
        }
        this.fileType = string2;
    }

    public void setAddFrom(String string) {
        this.addFrom = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.addFrom);
    }

    public void setFromBase(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            try {
                this.fromLen = new File(string2).getCanonicalPath().length();
                char c = string2.charAt(string2.length() - 1);
                if (c == '\\' || c == '/') {
                    ++this.fromLen;
                }
            }
            catch (IOException iOException) {
                String string3 = "fromBase\u306e\u6b63\u5f0f\u306a\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]" + CR + iOException.getMessage();
                throw new HybsSystemException(string3, iOException);
            }
        }
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("multi", (Object)this.multi).println("level", (Object)this.level).println("from", (Object)this.from).println("orderBy", (Object)this.orderBy).println("desc", (Object)this.desc).println("addClms", (Object)Arrays.toString(this.addClms)).println("defClms", (Object)Arrays.toString(this.defClms)).println("fileType", (Object)this.fileType).println("useWritable", (Object)this.useWritable).println("useMD5", (Object)this.useMD5).println("useText", (Object)this.useText).println("useUpdateClms", (Object)this.useUpdateClms).println("addFrom", (Object)this.addFrom).println("filter", (Object)this.filter).fixForm().toString() + CR + super.toString();
    }
}

