/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.table;

import java.util.Arrays;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractTableFilter;
import org.opengion.hayabusa.db.DBTableModel;

public class TableFilter_SKIPROW
extends AbstractTableFilter {
    private static final String VERSION = "6.9.3.0 (2018/03/26)";
    public static final int AUTO_SKIP_MIN_COUNT = 1000;
    public static final int AUTO_SKIP_SIZE = 500;
    private DBTableModel table;

    public TableFilter_SKIPROW() {
        this.initSet("DT_SKIP", "\u307e\u3068\u3081\u6570(-1:\u81ea\u52d5(\u521d\u671f\u5024)\u30010:\u307e\u3068\u3081\u306a\u3057\u3001\u6570\u5024:\u307e\u3068\u3081\u6570");
        this.initSet("GROUP_KEY", "\u30b0\u30eb\u30fc\u30d7\u30ab\u30e9\u30e0           (\u8907\u6570\u6307\u5b9a\u53ef)");
        this.initSet("VAL_CLMS", "\u307e\u3068\u3081\u308b\u306b\u5f53\u305f\u3063\u3066\u3001\u6700\u5927\u3001\u6700\u5c0f\u5224\u5b9a\u3092\u884c\u3046\u30ab\u30e9\u30e0\u5217");
        this.initSet("SKIP_MIN_COUNT", "\u81ea\u52d5\u8a2d\u5b9a\u6642\u306b\u30bb\u30c3\u30c8\u3057\u305f\u5834\u5408\u306e\u3001\uff83\uff9e\uff70\uff80\u306e\u6700\u5c0f\u5358\u4f4d");
        this.initSet("SKIP_SIZE", "\u81ea\u52d5\u8a2d\u5b9a\u6642\u306e\u9593\u5f15\u304d\u5f8c\u306e\u30b5\u30a4\u30ba(\u306e\u76ee\u5b89)");
    }

    public DBTableModel execute() {
        this.table = this.getDBTableModel();
        int n = StringUtil.nval((String)this.getValue("DT_SKIP"), (int)-1);
        int n2 = StringUtil.nval((String)this.getValue("SKIP_MIN_COUNT"), (int)1000);
        int n3 = StringUtil.nval((String)this.getValue("SKIP_SIZE"), (int)500);
        int n4 = this.table.getRowCount();
        if (n < 0) {
            int n5 = n = n4 < n2 ? 0 : n4 / n3;
        }
        if (n == 0) {
            return this.table;
        }
        String[] stringArray = StringUtil.csv2Array((String)this.getValue("GROUP_KEY"));
        int[] nArray = this.getTableColumnNo(stringArray);
        String[] stringArray2 = StringUtil.csv2Array((String)this.getValue("VAL_CLMS"));
        int[] nArray2 = this.getTableColumnNo(stringArray2);
        OmitTable omitTable = new OmitTable(this.table, nArray2, n);
        String string = this.getSeparatedValue(0, nArray);
        omitTable.check(0, false);
        for (int i = 1; i < n4; ++i) {
            String string2;
            String string3 = string2 = i + 1 == n4 ? "" : this.getSeparatedValue(i, nArray);
            if (string.equals(string2)) {
                omitTable.check(i, false);
                continue;
            }
            omitTable.check(i, true);
            string = string2;
        }
        return omitTable.getTable();
    }

    private String getSeparatedValue(int n, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            if (nArray[i] < 0 || (string = (String)this.table.getValue(n, nArray[i])) == null || string.length() <= 0) continue;
            stringBuilder.append(string).append('_');
        }
        return stringBuilder.toString();
    }

    private static final class OmitTable {
        private final DBTableModel orgTable;
        private final DBTableModel rtnTable;
        private final int[] clmNos;
        private final int clmSize;
        private final int skipNum;
        private final double[] minVals;
        private final double[] maxVals;
        private int minRow;
        private int maxRow;
        private int count;

        public OmitTable(DBTableModel dBTableModel, int[] nArray, int n) {
            this.orgTable = dBTableModel;
            this.rtnTable = dBTableModel.newModel();
            this.clmNos = nArray;
            this.clmSize = nArray.length;
            this.skipNum = n * 2;
            this.minVals = new double[this.clmSize];
            this.maxVals = new double[this.clmSize];
            this.dataInit();
        }

        private void dataInit() {
            Arrays.fill(this.minVals, Double.POSITIVE_INFINITY);
            Arrays.fill(this.maxVals, Double.NEGATIVE_INFINITY);
            this.minRow = -1;
            this.maxRow = -1;
        }

        private void change(int n) {
            String[] stringArray = (String[])this.orgTable.getValues(n);
            for (int i = 0; i < this.clmSize; ++i) {
                String string = stringArray[this.clmNos[i]];
                if (StringUtil.isNull((CharSequence[])new CharSequence[]{string})) continue;
                double d = Double.parseDouble(string);
                if (this.minVals[i] > d) {
                    this.minVals[i] = d;
                    this.minRow = n;
                }
                if (!(this.maxVals[i] < d)) continue;
                this.maxVals[i] = d;
                this.maxRow = n;
            }
        }

        public void check(int n, boolean bl) {
            this.change(n);
            ++this.count;
            if (bl || this.count % this.skipNum == 0) {
                String[] stringArray = (String[])this.orgTable.getValues(this.minRow < 0 ? n : this.minRow);
                String[] stringArray2 = (String[])this.orgTable.getValues(this.maxRow < 0 ? n : this.maxRow);
                for (int i = 0; i < this.clmSize; ++i) {
                    int n2 = this.clmNos[i];
                    if (this.minVals[i] != Double.POSITIVE_INFINITY) {
                        stringArray[n2] = String.valueOf(this.minVals[i]);
                    }
                    if (this.maxVals[i] == Double.NEGATIVE_INFINITY) continue;
                    stringArray2[n2] = String.valueOf(this.maxVals[i]);
                }
                if (this.minRow < this.maxRow) {
                    this.rtnTable.addColumnValues(stringArray);
                    this.rtnTable.addColumnValues(stringArray2);
                } else {
                    this.rtnTable.addColumnValues(stringArray2);
                    this.rtnTable.addColumnValues(stringArray);
                }
                this.dataInit();
            }
            if (bl) {
                this.count = 0;
            }
        }

        public DBTableModel getTable() {
            return this.rtnTable;
        }
    }
}

