<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false"/>

<og:comment
	system	= "GE:エンジン標準"
	pgid	= "WHTSNEW"
	title	= "標準(新着情報登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
>
	2018/06/29	T.OTA	05200-180319-01 ﾃｷｽﾄｴﾘｱをﾘｯﾁﾃｷｽﾄに変更。
</og:comment>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" dbid="RESOURCE" scope="request">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	 SYSTEM_ID												<!-- ｼｽﾃﾑID-->
				,SYSCODE												<!-- ｼｽﾃﾑｺｰﾄﾞ-->
				,CDDEG													<!-- 属性-->
				,TITLE													<!-- ﾀｲﾄﾙ-->
				,{@DBF.SUBSTR}(NAIYO,1,100) GAIYO1						<!-- 概要-->
				,NAIYO				NAIYO								<!-- 内容-->
				,MAND													<!-- 掲載者-->
				,DYSTRD													<!-- 掲載開始日-->
				,DYENDD													<!-- 掲載終了日-->
				,FGJ													<!-- (非表示)状況-->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ-->
				,BUSHOD													<!-- (非表示)掲載部署-->
				,TEL													<!-- (非表示)電話番号-->
				,MAILAD													<!-- (非表示)ﾒｰﾙｱﾄﾞﾚｽ-->
				,FILE1													<!-- (ﾌｧｲﾙ1-->
				,FILE2													<!-- (非表示)ﾌｧｲﾙ2-->
				,FILE3													<!-- (非表示)ﾌｧｲﾙ3-->
				,FILEPATH			PARENT								<!-- (非表示)ﾌｧｲﾙ保管場所-->
		FROM	GE81
	<og:where>
		<og:and value = "UNIQ		=	'{@UNIQ}'"			/>			<!-- GE81》ﾕﾆｰｸ = 画面》ﾕﾆｰｸ-->
		<og:and value = "SYSTEM_ID	=	'{@SYS.SYSTEM_ID}'"	/>
		<og:and value = "SYSCODE	=	'{@USER.SYSCODE}'"	/>
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "DYSTRD DESC,TITLE" />						<!-- 掲載開始日(降順),ﾀｲﾄﾙ	-->
</og:query>
<!--  2018/06/29 rendererをRICHLABELに変更。2018/09/25 リソース化
<og:columnEditor columns="NAIYO" renderer="RICHLABEL" />
<og:columnEditor columns="NAIYO" renderer="PRE" scope="request"/>
-->
<og:viewLink command="{@command}">
	<!-- 添付ﾌｧｲﾙ-->
	<og:link column="FILE1" href="{@SYS.JSP}/fileDownload" useGamenId="false" keys="file,name" vals="[PARENT]/[FILE1],[FILE1]"/>
	<og:link column="FILE2" href="{@SYS.JSP}/fileDownload" useGamenId="false" keys="file,name" vals="[PARENT]/[FILE2],[FILE2]"/>
	<og:link column="FILE3" href="{@SYS.JSP}/fileDownload" useGamenId="false" keys="file,name" vals="[PARENT]/[FILE3],[FILE3]"/>
</og:viewLink>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLFormatTextField"
	command		 = "{@command}" 
	scope		 = "request"
	writable	 = "false"
	noMessage	 = "true"
>
<div class="WN-MEISAI">
	<table summary="layout">
		<tr>
			<td style="height:10px;"></td>
		</tr>
		<tr>
			<td colspan="4" class="DYSTRD">[$DYSTRD]</td>	<!-- 掲載開始日	-->
		</tr>
		<tr>
			<td colspan="4" class="TITLE">[$TITLE]</td>		<!--ﾀｲﾄﾙ-->
		</tr>
		<tr>
			<td style="height:10px;"></td>
		</tr>
		<tr>
			<td colspan="4" class="WIDSIZE">[$NAIYO]</td>	<!--内容-->
		</tr>
		<tr>
			<td style="height:10px;"></td>
		</tr>
	</table>

	<table summary="layout" class="KEISAI">
		<tr>
			<td style="height:10px;"></td>
		</tr>
		<tr>
			<td>[$BUSHOD]</td>							<!-- 掲載部署-->
			<td>[$MAND]</td>							<!-- 掲載者-->
		</tr>
		<tr>
			<td>[$TEL]</td>								<!-- 電話番号-->
		</tr>
		<tr>
			<td>[$MAILAD]</td>							<!-- ﾒｰﾙｱﾄﾞﾚｽ-->
		</tr>
	</table>

	<!-- 添付ﾌｧｲﾙ	-->
	<table>
		<tr>
			<td>[$FILE1]</td>						<!-- 添付1-->
		</tr>
		<tr>
			<td>[$FILE2]</td>						<!-- 添付2-->
		</tr>
		<tr>
			<td>[$FILE3]</td>						<!-- 添付3-->
		</tr>
	</table>
</div>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
