<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0002"
	title    = "画面"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	5.4.3.6 2012/01/19 add PARENT_GRP
	5.6.6.0 2013/07/05 ROLE検索方法変更
	5.6.9.2 2013/10/18 {@scope}対応
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,GUIKEY,NAME_JA,LONGNAME,ADDRESS"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@FROMGUIKEY}" nullCheck="true" notEquals="true">
	<og:value command="SQL">
			SELECT SEQNO AS FROMKEY FROM GEA11
			WHERE GUIKEY='{@FROMGUIKEY}' AND SYSTEM_ID='{@SYSTEM_ID}' AND FGJ='1'
	</og:value>
	<og:value command="SQL">
			SELECT COALESCE ( MIN(SEQNO), 999999 ) AS TOKEY FROM GEA11 WHERE
			SEQNO &gt; {@FROMKEY} AND GUILVL &lt;= '{@GUILVL}' AND SYSTEM_ID='{@SYSTEM_ID}' AND FGJ='1'
	</og:value>
</og:equals>

<og:equals val1="{@USE_UPLOADFILE}{@command}" val2="trueNEW">
	<og:value key="scope" value="request" />
</og:equals>

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}" scope="{@scope}">
		select
			'1' as WRITABLE,A.GUIKEY,A.ADDRESS,A.SEQNO,A.GUILVL,A.LABEL_CLM,A.GROUPS
			,A.NAME_JA,B.LNAME,B.SNAME,A.ROLES
			,A.RWMODE,A.KBLINK,A.TARGET,A.PARAM,B.DESCRIPTION,A.COMMENTS,B.LANG,A.SYSTEM_ID
			,A.KBSAKU,A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH
			,A.FGJ,A.UNIQ,'' CLM,'0' EXIST_GEA08,0 UNIQ_GEA08
			, '3' as KBLBL
		from GEA11 A left outer join GEA08 B
						on  A.SYSTEM_ID = B.SYSTEM_ID
						and A.GUIKEY    = B.CLM
						and B.FGJ       = '1'
	--					and A.KBSAKU    = B.KBSAKU
			where A.SYSTEM_ID IN ( '{@SYSTEM_ID}','{@AST}' )
		<og:where startKey="and">
			<og:and value = "UPPER(A.GUIKEY)	like UPPER('{@GUIKEY}')"	/>
			<og:and value = "A.NAME_JA			like '{@NAME_JA}'"			/>
			<og:and value = "A.ADDRESS			like '{@ADDRESS}'"			/>
			<og:and value = "A.ROLES			like '{@ROLES}'"			/>
			<og:and value = "A.SEQNO BETWEEN {@FROMKEY} and {@TOKEY} - 1"	/>
			<og:and value = "B.LNAME			like '{@LNAME}'"			/>
			<og:and value = "B.SNAME			like '{@SNAME}'"			/>
			<og:and value = "B.LANG				=    '{@LANG}'"				/>
			<og:and value = "A.KBSAKU			=    '{@KBSAKU}'"			/>
			<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
		</og:where>
		<og:appear startKey="order by" value="{@ORDER_BY}"
					defaultVal="A.SEQNO,A.GUIKEY,A.ADDRESS,B.LANG,A.SYSTEM_ID DESC,A.KBSAKU DESC,B.KBSAKU DESC" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,GUIKEY,SEQNO,GUILVL,RWMODE" must="true" />
<og:columnEditor columns="DESCRIPTION,COMMENTS"			clazz="W100" />

<og:viewMarker isRenderer="false"  command="NEW">
	<og:columnMarker column="ROLES" onMark="true">
	[ROLES]<img style="cursor:pointer;" src="{@SYS.JSP}/image/multiChoose.gif"
				onClick="ogOpen('{@SYS.JSP}/custom/multiChoose.jsp?name=ROLES&amp;SYSTEM_ID={@SYSTEM_ID}&amp;editor=DBMENU&amp;param=select ROLES,NMROLE from GEA05 where SYSTEM_ID=\'{@SYSTEM_ID}\' and KBROLE=\'1\' and FGJ=\'1\'', event,'ROLES__[I]','width=500,height=200,resizable=no' );" />
	</og:columnMarker>
	<og:columnMarker column="GROUPS" onMark="true">
	[GROUPS]<img style="cursor:pointer;" src="{@SYS.JSP}/image/multiChoose.gif" onClick="ogOpen('{@SYS.JSP}/custom/multiChoose.jsp?name=GROUPS&amp;separator=,&amp;SYSTEM_ID={@SYSTEM_ID}', event,'GROUPS__[I]','width=500,height=200,resizable=no' );" />
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<og:link column="GUIKEY" gamenId="GE0005" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG"
		vals="NEW,[SYSTEM_ID],[GUIKEY],1,[LANG]" />
</og:viewLink>

<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:equals val1="{@ACTION}" nullCheck="true">
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,GUIKEY,KBSAKU,RDC_CODE,CDKH"  />
		<og:submit  action="DELETE"  columnWritable="null"  keys="logicalDelete" vals="true" />
		<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL" accesskey="" />
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA11" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit action="COPY" noWritable="null" keys="sysins" vals="true" accesskey="" />
		</fieldset>
	</og:equals>
	<og:equals val1="{@ACTION}" val2="MINUS">
		<og:submit  action="COPY"    noWritable="null" />
	</og:equals>
	<og:equals val1="{@ACTION}" val2="DIFFERENCE">
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,GUIKEY,KBSAKU,RDC_CODE,CDKH"  />
	</og:equals>
	<br />
</og:writeCheck>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}" mainTrans="false">
		{@USER.LASTSQL}
	</og:query>

	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,GUIKEY,ROLES,KBSAKU"
		diffKeys      = "SEQNO,NAME_JA,GUILVL,ADDRESS,RWMODE,KBLINK,TARGET,PARAM,GROUPS,LABEL_CLM,LNAME,SNAME"
		slaveScope    = "request"
		modifyClms    = "UNIQ,UNIQ_GEA08"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}"
	noDisplay    = "UNIQ,CLM,EXIST_GEA08,UNIQ_GEA08,KBLBL"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"  />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
