<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP02"
	title    = "データテーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- forward.jsp から command = "COPY" がセットされて遷移してくるので、複写画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" />

<!-- メッセージ表示を行います。必ずリソースファイルに表示するメッセージを登録し、 -->
<!-- lbl属性を使用して表示させて下さい。 -->
<og:message lbl="MSG0045" comment="複写処理を行います。" /><br />

<form method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />

</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType   = "HTMLTable"
	command        = "{@command}"
	columnWritable = "SYSTEM_ID,YKNO,EDNO,KBTEXT,TEXT_DATA"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
/>

<og:hidden name="SQL" >
	insert into GE51
	(
		SYSTEM_ID,YKNO,EDNO,KBTEXT,TEXT_DATA,
		FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD
	)
	values
	(
		[SYSTEM_ID],[YKNO],[EDNO],[KBTEXT],[TEXT_DATA],
		'1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}'
	)
</og:hidden>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
